/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.CommandExecutor;
import com.player2.playerengine.player2api.AgentConversationData;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.manager.ConversationManager;
import com.player2.playerengine.player2api.manager.TTSManager;
import com.player2.playerengine.tasks.LookAtOwnerTask;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentSideEffects {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onEntityMessage(MinecraftServer server, Event.CharacterMessage characterMessage) {
        if (characterMessage.message() != null && !characterMessage.message().isBlank()) {
            AgentConversationData sendingCharacterData = characterMessage.sendingCharacterData();
            String message = String.format("<%s> %s", sendingCharacterData.getName(), characterMessage.message());
            for (class_3222 player : server.method_3760().method_14571()) {
                AgentSideEffects.broadcastChatToPlayer(server, message, player);
            }
            TTSManager.TTS(characterMessage.message(), sendingCharacterData.getCharacter(), sendingCharacterData.getPlayer2apiService());
            ConversationManager.onAICharacterMessage(characterMessage, characterMessage.sendingCharacterData().getUUID());
        }
        if (characterMessage.command() != null && !characterMessage.command().isBlank()) {
            AgentSideEffects.onCommandListGenerated(characterMessage.sendingCharacterData().getMod(), characterMessage.command(), characterMessage.sendingCharacterData()::onCommandFinish);
        }
    }

    public static void onError(MinecraftServer server, String errMsg, class_3222 player) {
        LOGGER.error(errMsg);
        AgentSideEffects.broadcastErrorMsgToPlayer(server, errMsg, player);
    }

    public static void onCommandListGenerated(PlayerEngineController mod, String command, Consumer<CommandExecutionStopReason> onStop) {
        CommandExecutor cmdExecutor = mod.getCommandExecutor();
        String commandWithPrefix = cmdExecutor.isClientCommand(command) ? command : cmdExecutor.getCommandPrefix() + command;
        mod.isStopping = commandWithPrefix.equals("@stop");
        if (commandWithPrefix.contains("idle")) {
            mod.runUserTask(new LookAtOwnerTask());
            return;
        }
        String processedCommandWithPrefix = commandWithPrefix.replaceFirst("^(@build_structure)\\s+(?![\"'])(.+)$", "$1 \"$2\"");
        cmdExecutor.execute(processedCommandWithPrefix, () -> {
            if (mod.isStopping) {
                LOGGER.info("[AgentSideEffects/AgentSideEffects]: (%s) was cancelled. Not adding finish event to queue.", (Object)processedCommandWithPrefix);
                onStop.accept(new CommandExecutionStopReason.Cancelled(commandWithPrefix));
                LOGGER.info("after cancel, not running look at owner");
            } else {
                if (!commandWithPrefix.equals("@bodylang greeting")) {
                    LOGGER.info("Running on stop after finish cmd={}", (Object)commandWithPrefix);
                    onStop.accept(new CommandExecutionStopReason.Finished(commandWithPrefix));
                } else {
                    LOGGER.info("Ignore onStop for bodylang greeting");
                }
                LOGGER.info("Running look at owner task after finish cmd={}", (Object)commandWithPrefix);
                mod.runUserTask(new LookAtOwnerTask());
            }
        }, err -> {
            onStop.accept(new CommandExecutionStopReason.Error(commandWithPrefix, err.getMessage()));
            LOGGER.info("Running look at owner aftr error in cmd={}", (Object)commandWithPrefix);
            mod.runUserTask(new LookAtOwnerTask());
        });
    }

    public static void broadcastChatToPlayer(MinecraftServer server, String message, class_3222 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)message), false);
    }

    private static void broadcastErrorMsgToPlayer(MinecraftServer server, String message, class_3222 player) {
        class_5250 output = class_2561.method_43470((String)message);
        output.method_10862(output.method_10866().method_27706(class_124.field_1061));
        player.method_7353((class_2561)output, false);
    }

    public static void broadcastChatToAllPlayers(MinecraftServer server, String message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            AgentSideEffects.broadcastChatToPlayer(server, message, player);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface CommandExecutionStopReason {
        public String commandName();

        public record Error(String commandName, String errMsg) implements CommandExecutionStopReason
        {
        }

        public record Finished(String commandName) implements CommandExecutionStopReason
        {
        }

        public record Cancelled(String commandName) implements CommandExecutionStopReason
        {
        }
    }
}

