/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.class_243;

public abstract class AbstractDoToClosestObjectTask<T>
extends Task {
    private final HashMap<T, CachedHeuristic> heuristicMap = new HashMap();
    private T currentlyPursuing = null;
    private boolean wasWandering;
    private Task goalTask = null;

    protected abstract class_243 getPos(PlayerEngineController var1, T var2);

    protected abstract Optional<T> getClosestTo(PlayerEngineController var1, class_243 var2);

    protected abstract class_243 getOriginPos(PlayerEngineController var1);

    protected abstract Task getGoalTask(T var1);

    protected abstract boolean isValid(PlayerEngineController var1, T var2);

    protected Task getWanderTask(PlayerEngineController mod) {
        return new TimeoutWanderTask(true);
    }

    public void resetSearch() {
        this.currentlyPursuing = null;
        this.heuristicMap.clear();
        this.goalTask = null;
    }

    public boolean wasWandering() {
        return this.wasWandering;
    }

    private double getCurrentCalculatedHeuristic(PlayerEngineController mod) {
        OptionalDouble ticksRemainingOp = mod.getBaritone().getPathingBehavior().ticksRemainingInSegment();
        return ticksRemainingOp.orElse(Double.POSITIVE_INFINITY);
    }

    @Override
    protected Task onTick() {
        Optional<T> checkNewClosest;
        this.wasWandering = false;
        PlayerEngineController mod = this.controller;
        if (this.currentlyPursuing != null && !this.isValid(mod, this.currentlyPursuing)) {
            this.heuristicMap.remove(this.currentlyPursuing);
            this.currentlyPursuing = null;
        }
        if ((checkNewClosest = this.getClosestTo(mod, this.getOriginPos(mod))).isPresent() && !checkNewClosest.get().equals(this.currentlyPursuing)) {
            T newClosest = checkNewClosest.get();
            if (this.currentlyPursuing == null) {
                this.currentlyPursuing = newClosest;
            } else if (this.goalTask != null) {
                this.setDebugState("Moving towards closest...");
                double currentHeuristic = this.getCurrentCalculatedHeuristic(mod);
                double closestDistanceSqr = this.getPos(mod, this.currentlyPursuing).method_1025(mod.getPlayer().method_19538());
                int lastTick = this.controller.getWorld().method_8503().method_3780();
                if (!this.heuristicMap.containsKey(this.currentlyPursuing)) {
                    this.heuristicMap.put(this.currentlyPursuing, new CachedHeuristic());
                }
                CachedHeuristic h = this.heuristicMap.get(this.currentlyPursuing);
                h.updateHeuristic(currentHeuristic);
                h.updateDistance(closestDistanceSqr);
                h.setTickAttempted(lastTick);
                if (this.heuristicMap.containsKey(newClosest)) {
                    CachedHeuristic maybeReAttempt = this.heuristicMap.get(newClosest);
                    double maybeClosestDistance = this.getPos(mod, newClosest).method_1025(mod.getPlayer().method_19538());
                    if (maybeReAttempt.getHeuristicValue() < h.getHeuristicValue() || maybeClosestDistance < maybeReAttempt.getClosestDistanceSqr() / 4.0) {
                        this.setDebugState("Retrying old heuristic!");
                        this.currentlyPursuing = newClosest;
                        maybeReAttempt.updateDistance(maybeClosestDistance);
                    }
                } else {
                    this.setDebugState("Trying out NEW pursuit");
                    this.currentlyPursuing = newClosest;
                }
            } else {
                this.setDebugState("Waiting for move task to kick in...");
            }
        }
        if (this.currentlyPursuing != null) {
            this.goalTask = this.getGoalTask(this.currentlyPursuing);
            return this.goalTask;
        }
        this.goalTask = null;
        if (checkNewClosest.isEmpty()) {
            this.setDebugState("Waiting for calculations I think (wandering)");
            this.wasWandering = true;
            return this.getWanderTask(mod);
        }
        this.setDebugState("Waiting for calculations I think (NOT wandering)");
        return null;
    }

    private static class CachedHeuristic {
        private double closestDistanceSqr;
        private int tickAttempted;
        private double heuristicValue;

        public CachedHeuristic() {
            this.closestDistanceSqr = Double.POSITIVE_INFINITY;
            this.heuristicValue = Double.POSITIVE_INFINITY;
        }

        public CachedHeuristic(double closestDistanceSqr, int tickAttempted, double heuristicValue) {
        }

        public double getHeuristicValue() {
            return this.heuristicValue;
        }

        public void updateHeuristic(double heuristicValue) {
            heuristicValue = Math.min(heuristicValue, heuristicValue);
        }

        public double getClosestDistanceSqr() {
            return this.closestDistanceSqr;
        }

        public void updateDistance(double closestDistanceSqr) {
            closestDistanceSqr = Math.min(closestDistanceSqr, closestDistanceSqr);
        }

        public int getTickAttempted() {
            return this.tickAttempted;
        }

        public void setTickAttempted(int tickAttempted) {
        }
    }
}

