/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalBucketTask;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2338;

public class EnterNetherPortalTask
extends Task {
    private final Task getPortalTask;
    private final Dimension targetDimension;
    private final TimerGame portalTimeout = new TimerGame(10.0);
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final Predicate<class_2338> goodPortal;
    private boolean leftPortal;

    public EnterNetherPortalTask(Task getPortalTask, Dimension targetDimension, Predicate<class_2338> goodPortal) {
        if (targetDimension == Dimension.END) {
            throw new IllegalArgumentException("Can't build a nether portal to the end.");
        }
        this.getPortalTask = getPortalTask;
        this.targetDimension = targetDimension;
        this.goodPortal = goodPortal;
    }

    public EnterNetherPortalTask(Dimension targetDimension, Predicate<class_2338> goodPortal) {
        this(null, targetDimension, goodPortal);
    }

    public EnterNetherPortalTask(Task getPortalTask, Dimension targetDimension) {
        this(getPortalTask, targetDimension, blockPos -> true);
    }

    public EnterNetherPortalTask(Dimension targetDimension) {
        this(null, targetDimension);
    }

    @Override
    protected void onStart() {
        this.leftPortal = false;
        this.portalTimeout.reset();
        this.wanderTask.resetWander();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Exiting portal for a bit.");
            this.portalTimeout.reset();
            this.leftPortal = true;
            return this.wanderTask;
        }
        if (mod.getWorld().method_8320(mod.getPlayer().method_24515()).method_26204() == class_2246.field_10316) {
            if (this.portalTimeout.elapsed() && !this.leftPortal) {
                return this.wanderTask;
            }
            this.setDebugState("Waiting inside portal");
            mod.getBaritone().getExploreProcess().onLostControl();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getMineProcess().onLostControl();
            mod.getBaritone().getFarmProcess().onLostControl();
            mod.getBaritone().getGetToBlockProcess();
            mod.getBaritone().getBuilderProcess();
            mod.getBaritone().getFollowProcess();
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
            return null;
        }
        this.portalTimeout.reset();
        Predicate<class_2338> standablePortal = blockPos -> {
            if (mod.getWorld().method_8320(blockPos).method_26204() == class_2246.field_10316) {
                return this.goodPortal.test((class_2338)blockPos);
            }
            if (!mod.getChunkTracker().isChunkLoaded((class_2338)blockPos)) {
                return this.goodPortal.test((class_2338)blockPos);
            }
            class_2338 below = blockPos.method_10074();
            boolean canStand = WorldHelper.isSolidBlock(this.controller, below) && !mod.getBlockScanner().isBlockAtPosition(below, class_2246.field_10316);
            return canStand && this.goodPortal.test((class_2338)blockPos);
        };
        if (mod.getBlockScanner().anyFound(standablePortal, class_2246.field_10316)) {
            this.setDebugState("Going to found portal");
            return new DoToClosestBlockTask(blockPos -> new GetToBlockTask((class_2338)blockPos, false), standablePortal, class_2246.field_10316);
        }
        if (!mod.getBlockScanner().anyFound(standablePortal, class_2246.field_10316)) {
            this.setDebugState("Making new nether portal.");
            return WorldHelper.getCurrentDimension(this.controller) == Dimension.OVERWORLD ? new ConstructNetherPortalBucketTask() : new ConstructNetherPortalObsidianTask();
        }
        this.setDebugState("Getting our portal");
        return this.getPortalTask;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return WorldHelper.getCurrentDimension(this.controller) == this.targetDimension;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof EnterNetherPortalTask)) {
            bl = false;
        } else {
            EnterNetherPortalTask task = (EnterNetherPortalTask)other;
            bl = Objects.equals(task.getPortalTask, this.getPortalTask) && Objects.equals((Object)task.targetDimension, (Object)this.targetDimension);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Entering nether portal";
    }
}

