/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.multiversion.FoodComponentWrapper;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class EscapeFromLavaTask
extends CustomBaritoneGoalTask {
    private final float strength;
    private int ticks = 0;
    private final Predicate<class_2338> avoidPlacingRiskyBlock;

    public EscapeFromLavaTask(PlayerEngineController mod, float strength) {
        this.strength = strength;
        this.avoidPlacingRiskyBlock = blockPos -> mod.getPlayer().method_5829().method_994(new class_238(blockPos)) && (mod.getWorld().method_8320(mod.getPlayer().method_24515().method_10074()).method_26204() == class_2246.field_10164 || mod.getPlayer().method_5771());
    }

    public EscapeFromLavaTask(PlayerEngineController mod) {
        this(mod, 100.0f);
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBaritone().getExploreProcess().onLostControl();
        mod.getBaritone().getCustomGoalProcess().onLostControl();
        mod.getBehaviour().allowSwimThroughLava(true);
        mod.getBehaviour().setBlockPlacePenalty(0.0);
        mod.getBehaviour().setBlockBreakAdditionalPenalty(0.0);
        this.checker = new MovementProgressChecker(Integer.MAX_VALUE);
        mod.getExtraBaritoneSettings().avoidBlockPlace(this.avoidPlacingRiskyBlock);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        mod.getInputControls().hold(Input.JUMP);
        mod.getInputControls().hold(Input.SPRINT);
        Optional<class_1792> food = this.calculateFood(mod);
        if (food.isPresent() && mod.getBaritone().getEntityContext().hungerManager().getFoodLevel() < 20) {
            if (mod.getPlayer().method_6039()) {
                mod.log("want to eat, trying to stop shielding...");
                mod.getInputControls().release(Input.CLICK_RIGHT);
            } else {
                mod.getSlotHandler().forceEquipItem(new ItemTarget(food.get()), true);
                mod.getInputControls().hold(Input.CLICK_RIGHT);
            }
        }
        if (mod.getPlayer().method_5771() || mod.getWorld().method_8320(mod.getPlayer().method_24515().method_10074()).method_26204() == class_2246.field_10164) {
            this.setDebugState("run away from lava");
            class_2338 steppingPos = mod.getPlayer().method_23312();
            if (!(mod.getWorld().method_8320(steppingPos.method_10078()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10067()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10072()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10095()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10078().method_10095()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10078().method_10072()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10067().method_10095()).method_26204().equals(class_2246.field_10164) && mod.getWorld().method_8320(steppingPos.method_10067().method_10072()).method_26204().equals(class_2246.field_10164))) {
                return super.onTick();
            }
            if (mod.getPlayer().method_6039()) {
                mod.log("want to place block, trying to stop shielding...");
                mod.getInputControls().release(Input.CLICK_RIGHT);
            }
            for (float pitch = 25.0f; pitch < 90.0f; pitch += 1.0f) {
                for (float yaw = -180.0f; yaw < 180.0f; yaw += 1.0f) {
                    class_2350 facing;
                    class_3965 blockHitResult;
                    class_2338 pos;
                    class_239 result = this.raycast(mod, 4.0, pitch, yaw);
                    if (result.method_17783() != class_239.class_240.field_1332 || (pos = (blockHitResult = (class_3965)result).method_17777()).method_10264() > mod.getPlayer().method_23312().method_10264() || (facing = blockHitResult.method_17780()) == class_2350.field_11036) continue;
                    LookHelper.lookAt(this.controller, new Rotation(yaw, pitch));
                    if (mod.getItemStorage().hasItem(class_1802.field_8328)) {
                        mod.getSlotHandler().forceEquipItem(class_1802.field_8328);
                    } else {
                        mod.getSlotHandler().forceEquipItem(mod.getBaritoneSettings().acceptableThrowawayItems.get().toArray(new class_1792[0]));
                    }
                    mod.log(String.valueOf(pos));
                    mod.log(String.valueOf(facing));
                    mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                    return null;
                }
            }
        }
        return super.onTick();
    }

    private Optional<class_1792> calculateFood(PlayerEngineController mod) {
        class_1792 bestFood = null;
        double bestFoodScore = Double.NEGATIVE_INFINITY;
        class_1309 player = mod.getPlayer();
        float hunger = player != null ? (float)mod.getBaritone().getEntityContext().hungerManager().getFoodLevel() : 20.0f;
        float saturation = player != null ? mod.getBaritone().getEntityContext().hungerManager().getSaturationLevel() : 20.0f;
        for (class_1799 stack : mod.getItemStorage().getItemStacksPlayerInventory(true)) {
            float score;
            if (!ItemVer.isFood(stack) || stack.method_7909() == class_1802.field_8680 || !((double)(score = EscapeFromLavaTask.getScore(stack, hunger, saturation)) > bestFoodScore)) continue;
            bestFoodScore = score;
            bestFood = stack.method_7909();
        }
        return Optional.ofNullable(bestFood);
    }

    private static float getScore(class_1799 stack, float hunger, float saturation) {
        FoodComponentWrapper food = ItemVer.getFoodComponent(stack.method_7909());
        assert (food != null);
        float hungerIfEaten = Math.min(hunger + (float)food.getHunger(), 20.0f);
        float saturationIfEaten = Math.min(hungerIfEaten, saturation + food.getSaturationModifier());
        float gainedSaturation = saturationIfEaten - saturation;
        float hungerNotFilled = 20.0f - hungerIfEaten;
        float saturationGoodScore = gainedSaturation * 10.0f;
        float hungerNotFilledPenalty = hungerNotFilled * 2.0f;
        float score = saturationGoodScore - hungerNotFilledPenalty;
        if (stack.method_7909() == class_1802.field_8511) {
            score = 0.0f;
        }
        return score;
    }

    public class_239 raycast(PlayerEngineController mod, double maxDistance, float pitch, float yaw) {
        class_243 cameraPos = mod.getPlayer().method_5836(0.0f);
        class_243 rotationVector = this.getRotationVector(pitch, yaw);
        class_243 vec3d3 = cameraPos.method_1031(rotationVector.field_1352 * maxDistance, rotationVector.field_1351 * maxDistance, rotationVector.field_1350 * maxDistance);
        return mod.getPlayer().method_37908().method_17742(new class_3959(cameraPos, vec3d3, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)mod.getPlayer()));
    }

    protected final class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStop(Task interruptTask) {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().pop();
        mod.getInputControls().release(Input.JUMP);
        mod.getInputControls().release(Input.SPRINT);
        mod.getInputControls().release(Input.CLICK_RIGHT);
        Object object = mod.getExtraBaritoneSettings().getPlaceMutex();
        synchronized (object) {
            mod.getExtraBaritoneSettings().getPlaceAvoiders().remove(this.avoidPlacingRiskyBlock);
        }
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new EscapeFromLavaGoal();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof EscapeFromLavaTask;
    }

    @Override
    public boolean isFinished() {
        class_1309 player = this.controller.getPlayer();
        return !player.method_5771() && !player.method_5809();
    }

    @Override
    protected String toDebugString() {
        return "Escaping lava";
    }

    private class EscapeFromLavaGoal
    implements Goal {
        private EscapeFromLavaGoal() {
        }

        private boolean isLava(int x, int y, int z) {
            return EscapeFromLavaTask.this.controller.getWorld() == null ? false : MovementHelper.isLava(EscapeFromLavaTask.this.controller.getWorld().method_8320(new class_2338(x, y, z)));
        }

        private boolean isLavaAdjacent(int x, int y, int z) {
            return this.isLava(x + 1, y, z) || this.isLava(x - 1, y, z) || this.isLava(x, y, z + 1) || this.isLava(x, y, z - 1) || this.isLava(x + 1, y, z - 1) || this.isLava(x + 1, y, z + 1) || this.isLava(x - 1, y, z - 1) || this.isLava(x - 1, y, z + 1);
        }

        private boolean isWater(int x, int y, int z) {
            return EscapeFromLavaTask.this.controller.getWorld() == null ? false : MovementHelper.isWater(EscapeFromLavaTask.this.controller.getWorld().method_8320(new class_2338(x, y, z)));
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return !this.isLava(x, y, z) && !this.isLavaAdjacent(x, y, z);
        }

        @Override
        public double heuristic(int x, int y, int z) {
            if (this.isLava(x, y, z)) {
                return EscapeFromLavaTask.this.strength;
            }
            if (this.isLavaAdjacent(x, y, z)) {
                return EscapeFromLavaTask.this.strength * 0.5f;
            }
            return this.isWater(x, y, z) ? -100.0 : 0.0;
        }
    }
}

