/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GoInDirectionXZTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1672;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_7045;

public class LocateStrongholdCoordinatesTask
extends Task {
    private static final int EYE_RETHROW_DISTANCE = 10;
    private static final int SECOND_EYE_THROW_DISTANCE = 30;
    private final int targetEyes;
    private final int minimumEyes;
    private final TimerGame throwTimer = new TimerGame(5.0);
    private EyeDirection cachedEyeDirection = null;
    private EyeDirection cachedEyeDirection2 = null;
    private class_1297 currentThrownEye = null;
    private class_2382 strongholdEstimatePos = null;

    public LocateStrongholdCoordinatesTask(int targetEyes, int minimumEyes) {
        this.targetEyes = targetEyes;
        this.minimumEyes = minimumEyes;
    }

    public LocateStrongholdCoordinatesTask(int targetEyes) {
        this(targetEyes, 12);
    }

    static class_2382 calculateIntersection(class_243 start1, class_243 direction1, class_243 start2, class_243 direction2) {
        double t2 = (direction1.field_1350 * start2.field_1352 - direction1.field_1350 * start1.field_1352 - direction1.field_1352 * start2.field_1350 + direction1.field_1352 * start1.field_1350) / (direction1.field_1352 * direction2.field_1350 - direction1.field_1350 * direction2.field_1352);
        class_2338 blockPos = BlockPosVer.ofFloored((class_2374)start2.method_1019(direction2.method_1021(t2)));
        return new class_2382(blockPos.method_10263(), 0, blockPos.method_10260());
    }

    @Override
    protected void onStart() {
    }

    public boolean isSearching() {
        return this.cachedEyeDirection != null;
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD) {
            this.setDebugState("Going to overworld");
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        if (mod.getItemStorage().getItemCount(class_1802.field_8449) < this.minimumEyes && mod.getEntityTracker().itemDropped(class_1802.field_8449) && !mod.getEntityTracker().entityFound(class_1672.class)) {
            this.setDebugState("Picking up dropped ender eye.");
            return new PickupDroppedItemTask(class_1802.field_8449, this.targetEyes);
        }
        if (mod.getEntityTracker().entityFound(class_1672.class)) {
            if (this.currentThrownEye == null || !this.currentThrownEye.method_5805()) {
                Debug.logMessage("New eye direction");
                Debug.logMessage(this.currentThrownEye == null ? "null" : "is not alive");
                List<class_1672> enderEyes = mod.getEntityTracker().getTrackedEntities(class_1672.class);
                if (!enderEyes.isEmpty()) {
                    for (class_1672 enderEye : enderEyes) {
                        this.currentThrownEye = enderEye;
                    }
                }
                if (this.cachedEyeDirection2 != null) {
                    this.cachedEyeDirection = null;
                    this.cachedEyeDirection2 = null;
                } else if (this.cachedEyeDirection == null) {
                    this.cachedEyeDirection = new EyeDirection(this.currentThrownEye.method_19538());
                } else {
                    this.cachedEyeDirection2 = new EyeDirection(this.currentThrownEye.method_19538());
                }
            }
            if (this.cachedEyeDirection2 != null) {
                this.cachedEyeDirection2.updateEyePos(this.currentThrownEye.method_19538());
            } else if (this.cachedEyeDirection != null) {
                this.cachedEyeDirection.updateEyePos(this.currentThrownEye.method_19538());
            }
            if (mod.getEntityTracker().getClosestEntity(class_1672.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(class_1672.class).get().method_33571());
            }
            this.setDebugState("Waiting for eye to travel.");
            return null;
        }
        if (this.cachedEyeDirection2 != null && !mod.getEntityTracker().entityFound(class_1672.class) && this.strongholdEstimatePos == null) {
            if (this.cachedEyeDirection2.getAngle() >= this.cachedEyeDirection.getAngle()) {
                Debug.logMessage("2nd eye thrown at wrong position, or points to different stronghold. Rethrowing");
                this.cachedEyeDirection = this.cachedEyeDirection2;
                this.cachedEyeDirection2 = null;
            } else {
                class_243 throwOrigin = this.cachedEyeDirection.getOrigin();
                class_243 throwOrigin2 = this.cachedEyeDirection2.getOrigin();
                class_243 throwDelta = this.cachedEyeDirection.getDelta();
                class_243 throwDelta2 = this.cachedEyeDirection2.getDelta();
                this.strongholdEstimatePos = LocateStrongholdCoordinatesTask.calculateIntersection(throwOrigin, throwDelta, throwOrigin2, throwDelta2);
                Debug.logMessage("Stronghold is at " + this.strongholdEstimatePos.method_10263() + ", " + this.strongholdEstimatePos.method_10260() + " (" + (int)mod.getPlayer().method_19538().method_1022(class_243.method_24954((class_2382)this.strongholdEstimatePos)) + " blocks away)");
            }
        }
        if (this.strongholdEstimatePos != null && mod.getPlayer().method_19538().method_1022(class_243.method_24954((class_2382)this.strongholdEstimatePos)) < 10.0 && WorldHelper.getCurrentDimension(this.controller) == Dimension.OVERWORLD) {
            this.strongholdEstimatePos = null;
            this.cachedEyeDirection = null;
            this.cachedEyeDirection2 = null;
        }
        if (!mod.getEntityTracker().entityFound(class_1672.class) && this.strongholdEstimatePos == null) {
            if (WorldHelper.getCurrentDimension(this.controller) == Dimension.NETHER) {
                this.setDebugState("Going to overworld.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
            if (!mod.getItemStorage().hasItem(class_1802.field_8449)) {
                this.setDebugState("Collecting eye of ender.");
                return TaskCatalogue.getItemTask(class_1802.field_8449, 1);
            }
            if (this.cachedEyeDirection == null) {
                this.setDebugState("Throwing first eye.");
            } else {
                this.setDebugState("Throwing second eye.");
                double sqDist = mod.getPlayer().method_5707(this.cachedEyeDirection.getOrigin());
                if (sqDist < 900.0 && this.cachedEyeDirection != null) {
                    return new GoInDirectionXZTask(this.cachedEyeDirection.getOrigin(), this.cachedEyeDirection.getDelta().method_1024(1.5707964f), 1.0);
                }
            }
            if (mod.getSlotHandler().forceEquipItem(class_1802.field_8449)) {
                this.throwEye(this.controller.getWorld(), this.controller.getEntity());
            } else {
                Debug.logWarning("Failed to equip eye of ender to throw.");
            }
            return null;
        }
        if ((this.cachedEyeDirection == null || this.cachedEyeDirection.hasDelta()) && (this.cachedEyeDirection2 == null || this.cachedEyeDirection2.hasDelta())) {
            return null;
        }
        this.setDebugState("Waiting for thrown eye to appear...");
        return null;
    }

    private void throwEye(class_3218 world, class_1309 user) {
        class_2338 blockPos = world.method_8487(class_7045.field_37040, user.method_24515(), 100, false);
        if (blockPos != null) {
            class_1672 eyeOfEnderEntity = new class_1672((class_1937)world, user.method_23317(), user.method_23323(0.5), user.method_23321());
            eyeOfEnderEntity.method_16933(user.method_6047());
            eyeOfEnderEntity.method_7478(blockPos);
            world.method_32888(class_5712.field_28161, eyeOfEnderEntity.method_19538(), class_5712.class_7397.method_43285((class_1297)user));
            world.method_8649((class_1297)eyeOfEnderEntity);
            world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15155, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
            world.method_8444((class_1657)null, 1003, user.method_24515(), 0);
            user.method_6047().method_7934(1);
            user.method_23667(class_1268.field_5808, true);
        }
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    public Optional<class_2338> getStrongholdCoordinates() {
        return this.strongholdEstimatePos == null ? Optional.empty() : Optional.of(new class_2338(this.strongholdEstimatePos));
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof LocateStrongholdCoordinatesTask;
    }

    @Override
    protected String toDebugString() {
        return "Locating stronghold coordinates";
    }

    @Override
    public boolean isFinished() {
        return this.strongholdEstimatePos != null;
    }

    private static class EyeDirection {
        private final class_243 start;
        private class_243 end;

        public EyeDirection(class_243 startPos) {
            this.start = startPos;
        }

        public void updateEyePos(class_243 endPos) {
            this.end = endPos;
        }

        public class_243 getOrigin() {
            return this.start;
        }

        public class_243 getDelta() {
            return this.end == null ? class_243.field_1353 : this.end.method_1020(this.start);
        }

        public double getAngle() {
            return this.end == null ? 0.0 : Math.atan2(this.getDelta().method_10216(), this.getDelta().method_10215());
        }

        public boolean hasDelta() {
            return this.end != null && this.getDelta().method_1027() > 1.0E-5;
        }
    }
}

