/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public class TimeoutWanderTask
extends Task
implements ITaskRequiresGrounded {
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final float distanceToWander;
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final boolean increaseRange;
    private final TimerGame timer = new TimerGame(60.0);
    class_2248[] annoyingBlocks = new class_2248[]{class_2246.field_10597, class_2246.field_22117, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22124, class_2246.field_9983, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_10214, class_2246.field_10479, class_2246.field_16999};
    private class_243 origin;
    private boolean forceExplore;
    private Task unstuckTask = null;
    private int failCounter;
    private double wanderDistanceExtension;

    public TimeoutWanderTask(float distanceToWander, boolean increaseRange) {
        this.distanceToWander = distanceToWander;
        this.increaseRange = increaseRange;
        this.forceExplore = false;
    }

    public TimeoutWanderTask(float distanceToWander) {
        this(distanceToWander, false);
    }

    public TimeoutWanderTask() {
        this(Float.POSITIVE_INFINITY, false);
    }

    public TimeoutWanderTask(boolean forceExplore) {
        this();
        this.forceExplore = forceExplore;
    }

    private static class_2338[] generateSides(class_2338 pos) {
        return new class_2338[]{pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, class_2338 pos) {
        int b = 0;
        class_2248[] arrayOfBlock = this.annoyingBlocks;
        int i = arrayOfBlock.length;
        if (b >= i) {
            return false;
        }
        class_2248 AnnoyingBlocks = arrayOfBlock[b];
        return mod.getWorld().method_8320(pos).method_26204() == AnnoyingBlocks || mod.getWorld().method_8320(pos).method_26204() instanceof class_2323 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2354 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2349 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2356;
    }

    public void resetWander() {
        this.wanderDistanceExtension = 0.0;
    }

    private class_2338 stuckInBlock(PlayerEngineController mod) {
        class_2338[] toCheckHigh;
        class_2338[] toCheck;
        class_2338 p = mod.getPlayer().method_24515();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.method_10084())) {
            return p.method_10084();
        }
        for (class_2338 check : toCheck = TimeoutWanderTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (class_2338 checkx : toCheckHigh = TimeoutWanderTask.generateSides(p.method_10084())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        this.timer.reset();
        mod.getBaritone().getPathingBehavior().forceCancel();
        this.origin = mod.getPlayer().method_19538();
        this.progressChecker.reset();
        this.stuckCheck.reset();
        this.failCounter = 0;
        class_1799 cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
        if (!cursorStack.method_7960()) {
            Optional<Slot> moveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursorStack, false);
            moveTo.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, class_1713.field_7790));
            if (ItemHelper.canThrowAwayStack(mod, cursorStack)) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, class_1713.field_7790));
            mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, class_1713.field_7790);
        }
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                mod.getInputControls().hold(Input.SNEAK);
                mod.getInputControls().hold(Input.MOVE_FORWARD);
                return null;
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progressChecker.check(mod) || !this.stuckCheck.check(mod)) {
            for (class_1297 CloseEntities : mod.getEntityTracker().getCloseEntities()) {
                if (!(CloseEntities instanceof class_1308) || !CloseEntities.method_19538().method_24802((class_2374)mod.getPlayer().method_19538(), 1.0) || CloseEntities == mod.getEntity()) continue;
                this.setDebugState("Killing annoying entity.");
                return new KillEntitiesTask(CloseEntities.getClass());
            }
            class_2338 blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                ++this.failCounter;
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        this.setDebugState("Exploring.");
        switch (WorldHelper.getCurrentDimension(this.controller)) {
            case END: {
                if (!(this.timer.getDuration() >= 30.0)) break;
                this.timer.reset();
                break;
            }
            case OVERWORLD: 
            case NETHER: {
                if (this.timer.getDuration() >= 30.0) {
                    // empty if block
                }
                if (!this.timer.elapsed()) break;
                this.timer.reset();
            }
        }
        if (!mod.getBaritone().getExploreProcess().isActive()) {
            mod.getBaritone().getExploreProcess().explore((int)this.origin.method_10216(), (int)this.origin.method_10215());
        }
        if (!this.progressChecker.check(mod)) {
            this.progressChecker.reset();
            if (!this.forceExplore) {
                ++this.failCounter;
                Debug.logMessage("Failed exploring.");
                if (this.progressChecker.lastBreakingBlock != null) {
                    // empty if block
                }
            }
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        if (this.isFinished() && this.increaseRange) {
            this.wanderDistanceExtension += (double)this.distanceToWander;
            Debug.logMessage("Increased wander range");
        }
    }

    @Override
    public boolean isFinished() {
        if (Float.isInfinite(this.distanceToWander)) {
            return false;
        }
        if (this.failCounter > 10) {
            return true;
        }
        class_1309 player = this.controller.getPlayer();
        if (player != null && player.method_19538() != null && (player.method_24828() || player.method_5799())) {
            double toWander;
            double sqDist = player.method_19538().method_1025(this.origin);
            return sqDist > (toWander = (double)this.distanceToWander + this.wanderDistanceExtension) * toWander;
        }
        return false;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof TimeoutWanderTask) {
            TimeoutWanderTask task = (TimeoutWanderTask)other;
            return !Float.isInfinite(task.distanceToWander) && !Float.isInfinite(this.distanceToWander) ? Math.abs(task.distanceToWander - this.distanceToWander) < 0.5f : Float.isInfinite(task.distanceToWander) == Float.isInfinite(this.distanceToWander);
        }
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Wander for " + this.distanceToWander + this.wanderDistanceExtension + " blocks";
    }
}

