/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.speedrun;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.GoalGetToBlock;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.mixins.LivingEntityMixin;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractKillEntityTask;
import com.player2.playerengine.tasks.entity.DoToClosestEntityTask;
import com.player2.playerengine.tasks.misc.EquipArmorTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.CollectBlockByOneTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1521;
import net.minecraft.class_1527;
import net.minecraft.class_1560;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class KillEnderDragonTask
extends Task {
    private static final String[] DIAMOND_ARMORS = new String[]{"diamond_chestplate", "diamond_leggings", "diamond_helmet", "diamond_boots"};
    private final TimerGame lookDownTimer = new TimerGame(0.5);
    private final Task collectBuildMaterialsTask = new CollectBlockByOneTask.CollectEndStoneTask(100);
    private final PunkEnderDragonTask punkTask = new PunkEnderDragonTask();
    private class_2338 exitPortalTop;

    private static Task getPickupTaskIfAny(PlayerEngineController mod, class_1792 ... itemsToPickup) {
        for (class_1792 check : itemsToPickup) {
            if (!mod.getEntityTracker().itemDropped(check)) continue;
            return new PickupDroppedItemTask(new ItemTarget(check), true);
        }
        return null;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().addForceFieldExclusion(entity -> entity instanceof class_1560 || entity instanceof class_1510 || entity instanceof class_1508);
        mod.getBehaviour().setPreferredStairs(true);
    }

    @Override
    protected Task onTick() {
        Task pickupDrops;
        PlayerEngineController mod = this.controller;
        if (this.exitPortalTop == null) {
            this.exitPortalTop = this.locateExitPortalTop(mod);
        }
        ArrayList<class_1792> toPickUp = new ArrayList<class_1792>(Arrays.asList(class_1802.field_8802, class_1802.field_8285, class_1802.field_8348, class_1802.field_8058, class_1802.field_8805));
        if (StorageHelper.calculateInventoryFoodScore(mod) < 10) {
            toPickUp.addAll(Arrays.asList(class_1802.field_8229, class_1802.field_8176, class_1802.field_8544, class_1802.field_8347, class_1802.field_8752, class_1802.field_8261));
        }
        if ((pickupDrops = KillEnderDragonTask.getPickupTaskIfAny(mod, (class_1792[])toPickUp.toArray(class_1792[]::new))) != null) {
            this.setDebugState("Picking up drops in end.");
            return pickupDrops;
        }
        for (class_1792 armor : ItemHelper.DIAMOND_ARMORS) {
            try {
                if (!mod.getItemStorage().hasItem(armor) || StorageHelper.isArmorEquipped(mod, armor)) continue;
                this.setDebugState("Equipping " + String.valueOf(armor));
                return new EquipArmorTask(armor);
            }
            catch (NullPointerException var9) {
                Debug.logError("NullpointerException that Should never happen.");
                var9.printStackTrace();
            }
        }
        if (!this.isRailingOnDragon() && this.lookDownTimer.elapsed() && !mod.getControllerExtras().isBreakingBlock() && mod.getPlayer().method_24828()) {
            this.lookDownTimer.reset();
            mod.getBaritone().getLookBehavior().updateTarget(new Rotation(0.0f, 90.0f), true);
        }
        if (mod.getBlockScanner().anyFound(class_2246.field_10027)) {
            this.setDebugState("Entering portal to beat the game.");
            return new DoToClosestBlockTask(blockPos -> new GetToBlockTask(blockPos.method_10084(), false), class_2246.field_10027);
        }
        int MINIMUM_BUILDING_BLOCKS = 1;
        if (mod.getEntityTracker().entityFound(class_1511.class) && mod.getItemStorage().getItemCount(class_1802.field_8831, class_1802.field_20412, class_1802.field_8328, class_1802.field_20399) < MINIMUM_BUILDING_BLOCKS || this.collectBuildMaterialsTask.isActive() && !this.collectBuildMaterialsTask.isFinished()) {
            if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD)) {
                mod.getBehaviour().addProtectedItems(class_1802.field_20399);
                this.setDebugState("Collecting building blocks to pillar to crystals");
                return this.collectBuildMaterialsTask;
            }
        } else {
            mod.getBehaviour().removeProtectedItems(class_1802.field_20399);
        }
        if (mod.getEntityTracker().entityFound(class_1511.class)) {
            this.setDebugState("Kamakazeeing crystals");
            return new DoToClosestEntityTask(toDestroy -> {
                if (toDestroy.method_24516((class_1297)mod.getPlayer(), 7.0)) {
                    mod.getControllerExtras().attack((class_1297)toDestroy);
                }
                return new GetToBlockTask(toDestroy.method_24515().method_10069(1, 0, 0), false);
            }, class_1511.class);
        }
        if (mod.getEntityTracker().entityFound(class_1510.class)) {
            this.setDebugState("Punking dragon");
            return this.punkTask;
        }
        this.setDebugState("Couldn't find ender dragon... This can be very good or bad news.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof KillEnderDragonTask;
    }

    @Override
    protected String toDebugString() {
        return "Killing Ender Dragon";
    }

    private boolean isRailingOnDragon() {
        return this.punkTask.getMode() == Mode.RAILING;
    }

    private class_2338 locateExitPortalTop(PlayerEngineController mod) {
        if (!mod.getChunkTracker().isChunkLoaded(new class_2338(0, 64, 0))) {
            return null;
        }
        int height = WorldHelper.getGroundHeight(mod, 0, 0, class_2246.field_9987);
        return height != -1 ? new class_2338(0, height, 0) : null;
    }

    private class PunkEnderDragonTask
    extends Task {
        private final HashMap<class_2338, Double> breathCostMap = new HashMap();
        private final TimerGame hitHoldTimer = new TimerGame(0.1);
        private final TimerGame hitResetTimer = new TimerGame(0.4);
        private final TimerGame randomWanderChangeTimeout = new TimerGame(20.0);
        private Mode mode = Mode.WAITING_FOR_PERCH;
        private class_2338 randomWanderPos;
        private boolean wasHitting;
        private boolean wasReleased;

        private PunkEnderDragonTask() {
        }

        public Mode getMode() {
            return this.mode;
        }

        private void hit(PlayerEngineController mod) {
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
            if (!this.wasHitting) {
                this.wasHitting = true;
                this.wasReleased = false;
                this.hitHoldTimer.reset();
                this.hitResetTimer.reset();
                Debug.logInternal("HIT");
                mod.getInputControls().tryPress(Input.CLICK_LEFT);
            }
            if (this.hitHoldTimer.elapsed() && !this.wasReleased) {
                Debug.logInternal("    up");
                this.wasReleased = true;
            }
            if (this.wasHitting && this.hitResetTimer.elapsed() && (double)this.getAttackCooldownProgress(mod.getPlayer(), 0.0f) > 0.99) {
                this.wasHitting = false;
                mod.getExtraBaritoneSettings().setInteractionPaused(false);
                this.hitResetTimer.reset();
            }
        }

        public float getAttackCooldownProgressPerTick(class_1309 entity) {
            return (float)(1.0 / entity.method_26825(class_5134.field_23723) * 20.0);
        }

        public float getAttackCooldownProgress(class_1309 entity, float baseTime) {
            return class_3532.method_15363((float)(((float)((LivingEntityMixin)entity).getLastAttackedTicks() + baseTime) / this.getAttackCooldownProgressPerTick(entity)), (float)0.0f, (float)1.0f);
        }

        private void stopHitting(PlayerEngineController mod) {
            if (this.wasHitting) {
                if (!this.wasReleased) {
                    mod.getExtraBaritoneSettings().setInteractionPaused(false);
                    this.wasReleased = true;
                }
                this.wasHitting = false;
            }
        }

        @Override
        protected void onStart() {
            this.controller.getBaritone().getCustomGoalProcess().onLostControl();
        }

        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (!mod.getEntityTracker().entityFound(class_1510.class)) {
                this.setDebugState("No dragon found.");
                return null;
            }
            List<class_1510> dragons = mod.getEntityTracker().getTrackedEntities(class_1510.class);
            if (!dragons.isEmpty()) {
                for (class_1510 dragon : dragons) {
                    class_1521 dragonPhase = dragon.method_6831().method_6864();
                    boolean perchingOrGettingReady = dragonPhase.method_6849() == class_1527.field_7067 || dragonPhase.method_6848();
                    switch (this.mode.ordinal()) {
                        case 1: {
                            if (!perchingOrGettingReady) {
                                Debug.logMessage("Dragon no longer perching.");
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                                this.mode = Mode.WAITING_FOR_PERCH;
                                break;
                            }
                            class_1508 head = dragon.field_7017;
                            if (head.method_24516((class_1297)mod.getPlayer(), 7.5) && dragon.field_7031 <= 1) {
                                AbstractKillEntityTask.equipWeapon(mod);
                                class_243 targetLookPos = head.method_19538().method_1031(0.0, 3.0, 0.0);
                                Rotation targetRotation = RotationUtils.calcRotationFromVec3d(mod.getBaritone().getEntityContext().headPos(), targetLookPos, mod.getBaritone().getEntityContext().entityRotations());
                                mod.getBaritone().getLookBehavior().updateTarget(targetRotation, true);
                                mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, true);
                                this.hit(mod);
                            } else {
                                this.stopHitting(mod);
                            }
                            if (!mod.getBaritone().getCustomGoalProcess().isActive() && KillEnderDragonTask.this.exitPortalTop != null) {
                                int bottomYDelta = -3;
                                class_2338 closest = null;
                                double closestDist = Double.POSITIVE_INFINITY;
                                for (int dx = -2; dx <= 2; ++dx) {
                                    for (int dz = -2; dz <= 2; ++dz) {
                                        class_2338 toCheck;
                                        double distSq;
                                        if (Math.abs(dx) == 2 && Math.abs(dz) == 2 || !((distSq = BlockPosVer.getSquaredDistance(toCheck = KillEnderDragonTask.this.exitPortalTop.method_10069(dx, bottomYDelta, dz), (class_2374)head.method_19538())) < closestDist)) continue;
                                        closest = toCheck;
                                        closestDist = distSq;
                                    }
                                }
                                if (closest != null) {
                                    mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalGetToBlock(closest));
                                }
                            }
                            this.setDebugState("Railing on dragon");
                            break;
                        }
                        case 0: {
                            this.stopHitting(mod);
                            if (perchingOrGettingReady) {
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                                Debug.logMessage("Dragon perching detected. Dabar duosiu \u012f snuki.");
                                this.mode = Mode.RAILING;
                                break;
                            }
                            if (this.randomWanderPos != null && WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.randomWanderPos, 2.0)) {
                                this.randomWanderPos = null;
                            }
                            if (this.randomWanderPos != null && this.randomWanderChangeTimeout.elapsed()) {
                                this.randomWanderPos = null;
                                Debug.logMessage("Reset wander pos after timeout, oof");
                            }
                            if (this.randomWanderPos == null) {
                                this.randomWanderPos = this.getRandomWanderPos(mod);
                                this.randomWanderChangeTimeout.reset();
                                mod.getBaritone().getCustomGoalProcess().onLostControl();
                            }
                            if (!mod.getBaritone().getCustomGoalProcess().isActive()) {
                                mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalGetToBlock(this.randomWanderPos));
                            }
                            this.setDebugState("Waiting for perch");
                        }
                    }
                }
            }
            return null;
        }

        @Override
        protected void onStop(Task interruptTask) {
            PlayerEngineController mod = this.controller;
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getInputOverrideHandler().setInputForceState(Input.MOVE_FORWARD, false);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }

        @Override
        protected boolean isEqual(Task other) {
            return other instanceof PunkEnderDragonTask;
        }

        @Override
        protected String toDebugString() {
            return "Punking the dragon";
        }

        private class_2338 getRandomWanderPos(PlayerEngineController mod) {
            double RADIUS_RANGE = 45.0;
            double MIN_RADIUS = 7.0;
            class_2338 pos = null;
            int allowed = 5000;
            while (pos == null) {
                int z;
                double angle;
                if (allowed-- < 0) {
                    Debug.logWarning("Failed to find random solid ground in end, this may lead to problems.");
                    return null;
                }
                double radius = MIN_RADIUS + (RADIUS_RANGE - MIN_RADIUS) * Math.random();
                int x = (int)(radius * Math.cos(angle = Math.PI * 2 * Math.random()));
                int y = WorldHelper.getGroundHeight(mod, x, z = (int)(radius * Math.sin(angle)));
                if (y == -1) continue;
                class_2338 check = new class_2338(x, y, z);
                if (mod.getWorld().method_8320(check).method_26204() != class_2246.field_10471) continue;
                pos = check.method_10084();
            }
            return pos;
        }
    }

    private static enum Mode {
        WAITING_FOR_PERCH,
        RAILING;

    }
}

