/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.recipemanager.RecipeManagerWrapper;
import com.player2.playerengine.multiversion.recipemanager.WrappedRecipeEntry;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.RecipeTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_3955;

public class CraftingRecipeTracker
extends Tracker {
    private final HashMap<class_1792, List<CraftingRecipe>> itemRecipeMap = new HashMap();
    private final HashMap<CraftingRecipe, class_1799> recipeResultMap = new HashMap();
    private boolean shouldRebuild = true;

    public CraftingRecipeTracker(TrackerManager manager) {
        super(manager);
    }

    public List<CraftingRecipe> getRecipeForItem(class_1792 item) {
        this.ensureUpdated();
        if (!this.hasRecipeForItem(item)) {
            this.mod.logWarning("trying to access recipe for unknown item: " + String.valueOf(item));
            return null;
        }
        return this.itemRecipeMap.get(item);
    }

    public CraftingRecipe getFirstRecipeForItem(class_1792 item) {
        this.ensureUpdated();
        if (!this.hasRecipeForItem(item)) {
            this.mod.logWarning("trying to access recipe for unknown item: " + String.valueOf(item));
            return null;
        }
        return this.itemRecipeMap.get(item).get(0);
    }

    public List<RecipeTarget> getRecipeTarget(class_1792 item, int targetCount) {
        this.ensureUpdated();
        ArrayList<RecipeTarget> targets = new ArrayList<RecipeTarget>();
        for (CraftingRecipe recipe : this.getRecipeForItem(item)) {
            targets.add(new RecipeTarget(item, targetCount, recipe));
        }
        return targets;
    }

    public RecipeTarget getFirstRecipeTarget(class_1792 item, int targetCount) {
        this.ensureUpdated();
        return new RecipeTarget(item, targetCount, this.getFirstRecipeForItem(item));
    }

    public boolean hasRecipeForItem(class_1792 item) {
        this.ensureUpdated();
        return this.itemRecipeMap.containsKey(item);
    }

    public class_1799 getRecipeResult(CraftingRecipe recipe) {
        this.ensureUpdated();
        if (!this.hasRecipe(recipe)) {
            this.mod.logWarning("Trying to get result for unknown recipe: " + String.valueOf(recipe));
            return null;
        }
        class_1799 result = this.recipeResultMap.get(recipe);
        return new class_1799((class_1935)result.method_7909(), result.method_7947());
    }

    public boolean hasRecipe(CraftingRecipe recipe) {
        this.ensureUpdated();
        return this.recipeResultMap.containsKey(recipe);
    }

    @Override
    protected void updateState() {
        if (this.shouldRebuild && PlayerEngineController.inGame()) {
            RecipeManagerWrapper recipeManager = RecipeManagerWrapper.of(this.mod.getWorld().method_8433());
            for (WrappedRecipeEntry recipe : recipeManager.values()) {
                class_3955 craftingRecipe;
                class_1860<?> recipe1 = recipe.value();
                if (!(recipe1 instanceof CraftingRecipe) || (craftingRecipe = (class_3955)recipe1) instanceof class_1852) continue;
                class_1799 result = new class_1799((class_1935)craftingRecipe.method_8110(null).method_7909(), craftingRecipe.method_8110(null).method_7947());
                class_1792[][] altoclefRecipeItems = CraftingRecipeTracker.getShapedCraftingRecipe((List<class_1856>)craftingRecipe.method_8117());
                CraftingRecipe altoclefRecipe = CraftingRecipe.newShapedRecipe(altoclefRecipeItems, result.method_7947());
                if (this.itemRecipeMap.containsKey(result.method_7909())) {
                    this.itemRecipeMap.get(result.method_7909()).add(altoclefRecipe);
                } else {
                    ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
                    recipes.add(altoclefRecipe);
                    this.itemRecipeMap.put(result.method_7909(), recipes);
                }
                this.recipeResultMap.put(altoclefRecipe, result);
            }
            this.itemRecipeMap.replaceAll((k, v) -> Collections.unmodifiableList(v));
            this.shouldRebuild = false;
        }
    }

    private static class_1792[][] getShapedCraftingRecipe(List<class_1856> ingredients) {
        class_1792[][] result = new class_1792[9][];
        int x = 0;
        for (class_1856 ingredient : ingredients) {
            class_1799[] stacks = ingredient.method_8105();
            class_1792[] items = new class_1792[stacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                class_1799 stack = stacks[i];
                if (stack.method_7947() > 1) {
                    throw new IllegalStateException("recipe needs more then one item on a slot... well... shit (ingredients: " + String.valueOf(ingredient) + ")");
                }
                items[i] = stack.method_7909();
            }
            if (stacks.length != 0) {
                class_1792[] var10000 = new class_1792[]{items[0]};
                result[x] = new class_1792[1];
            } else {
                result[x] = null;
            }
            ++x;
        }
        return result;
    }

    @Override
    protected void reset() {
        this.shouldRebuild = true;
        this.itemRecipeMap.clear();
        this.recipeResultMap.clear();
    }

    @Override
    protected boolean isDirty() {
        return this.shouldRebuild;
    }
}

