/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.events.PlayerCollidedWithEntityEvent;
import com.player2.playerengine.mixins.PersistentProjectileEntityAccessor;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.trackers.blacklisting.EntityLocateBlacklist;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.baritone.CachedProjectile;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.ProjectileHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1536;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1792;
import net.minecraft.class_243;

public class EntityTracker
extends Tracker {
    private final HashMap<class_1792, List<class_1542>> itemDropLocations = new HashMap();
    private final HashMap<Class, List<class_1297>> entityMap = new HashMap();
    private final List<class_1297> closeEntities = new ArrayList<class_1297>();
    private final List<class_1309> hostiles = new ArrayList<class_1309>();
    private final List<CachedProjectile> projectiles = new ArrayList<CachedProjectile>();
    private final HashMap<String, class_1657> playerMap = new HashMap();
    private final HashMap<String, class_243> playerLastCoordinates = new HashMap();
    private final EntityLocateBlacklist entityBlacklist = new EntityLocateBlacklist();
    private final HashMap<class_1309, List<class_1297>> entitiesCollidingWithPlayerAccumulator = new HashMap();
    private final HashMap<class_1309, HashSet<class_1297>> entitiesCollidingWithPlayer = new HashMap();

    public EntityTracker(TrackerManager manager) {
        super(manager);
        EventBus.subscribe(PlayerCollidedWithEntityEvent.class, evt -> this.registerPlayerCollision((class_1309)evt.player, evt.other));
    }

    private static Class squashType(Class<?> type) {
        return class_1657.class.isAssignableFrom(type) ? class_1657.class : type;
    }

    private void registerPlayerCollision(class_1309 player, class_1297 entity) {
        if (!this.entitiesCollidingWithPlayerAccumulator.containsKey(player)) {
            this.entitiesCollidingWithPlayerAccumulator.put(player, new ArrayList());
        }
        this.entitiesCollidingWithPlayerAccumulator.get(player).add(entity);
    }

    public boolean isCollidingWithPlayer(class_1309 player, class_1297 entity) {
        return this.entitiesCollidingWithPlayer.containsKey(player) && this.entitiesCollidingWithPlayer.get(player).contains(entity);
    }

    public boolean isCollidingWithPlayer(class_1297 entity) {
        return this.isCollidingWithPlayer(this.mod.getPlayer(), entity);
    }

    public Optional<class_1542> getClosestItemDrop(class_1792 ... items) {
        return this.getClosestItemDrop(this.mod.getPlayer().method_19538(), items);
    }

    public Optional<class_1542> getClosestItemDrop(class_243 position, class_1792 ... items) {
        return this.getClosestItemDrop(position, (class_1542 entity) -> true, items);
    }

    public Optional<class_1542> getClosestItemDrop(class_243 position, ItemTarget ... items) {
        return this.getClosestItemDrop(position, (class_1542 entity) -> true, items);
    }

    public Optional<class_1542> getClosestItemDrop(Predicate<class_1542> acceptPredicate, class_1792 ... items) {
        return this.getClosestItemDrop(this.mod.getPlayer().method_19538(), acceptPredicate, items);
    }

    public Optional<class_1542> getClosestItemDrop(class_243 position, Predicate<class_1542> acceptPredicate, class_1792 ... items) {
        this.ensureUpdated();
        ItemTarget[] tempTargetList = new ItemTarget[items.length];
        for (int i = 0; i < items.length; ++i) {
            tempTargetList[i] = new ItemTarget(items[i], 9999999);
        }
        return this.getClosestItemDrop(position, acceptPredicate, tempTargetList);
    }

    private Optional<class_1542> getClosestItemDropWithoutItemTarget(class_243 position, Predicate<class_1542> acceptPredicate) {
        ArrayList<class_1792> items = new ArrayList<class_1792>(this.itemDropLocations.keySet());
        class_1542 closestEntity = null;
        float minCost = Float.POSITIVE_INFINITY;
        for (class_1792 item : items) {
            Collection entities;
            if (!this.itemDropped(item) || (entities = (Collection)this.itemDropLocations.get(item)) == null) continue;
            for (class_1542 entity : entities) {
                float cost;
                if (this.entityBlacklist.unreachable(entity) || !entity.method_6983().method_7909().equals(item) || !acceptPredicate.test(entity) || !((cost = (float)BaritoneHelper.calculateGenericHeuristic(position, entity.method_19538())) < minCost)) continue;
                minCost = cost;
                closestEntity = entity;
            }
        }
        return Optional.ofNullable(closestEntity);
    }

    public Optional<class_1542> getClosestItemDrop(class_243 position, Predicate<class_1542> acceptPredicate, ItemTarget ... targets) {
        this.ensureUpdated();
        if (targets.length == 0) {
            return this.getClosestItemDropWithoutItemTarget(position, acceptPredicate);
        }
        if (!this.itemDropped(targets)) {
            return Optional.empty();
        }
        class_1542 closestEntity = null;
        float minCost = Float.POSITIVE_INFINITY;
        for (ItemTarget target : targets) {
            for (class_1792 item : target.getMatches()) {
                if (!this.itemDropped(item)) continue;
                for (class_1542 entity : this.itemDropLocations.get(item)) {
                    float cost;
                    if (this.entityBlacklist.unreachable(entity) || !entity.method_6983().method_7909().equals(item) || !acceptPredicate.test(entity) || !((cost = (float)BaritoneHelper.calculateGenericHeuristic(position, entity.method_19538())) < minCost)) continue;
                    minCost = cost;
                    closestEntity = entity;
                }
            }
        }
        return Optional.ofNullable(closestEntity);
    }

    private Class[] parsePossiblyNullEntityTypes(Class ... entityTypes) {
        return entityTypes == null ? (Class[])this.entityMap.keySet().toArray(Class[]::new) : entityTypes;
    }

    public Optional<class_1297> getClosestEntity(Class ... entityTypes) {
        return this.getClosestEntity(this.mod.getPlayer().method_19538(), entityTypes);
    }

    public Optional<class_1297> getClosestEntity(class_243 position, Class ... entityTypes) {
        return this.getClosestEntity(position, (class_1297 entity) -> true, entityTypes);
    }

    public Optional<class_1297> getClosestEntity(Predicate<class_1297> acceptPredicate, Class ... entityTypes) {
        return this.getClosestEntity(this.mod.getPlayer().method_19538(), acceptPredicate, entityTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<class_1297> getClosestEntity(class_243 position, Predicate<class_1297> acceptPredicate, Class ... entityTypes) {
        entityTypes = this.parsePossiblyNullEntityTypes(entityTypes);
        class_1297 closestEntity = null;
        double minCost = Double.POSITIVE_INFINITY;
        for (Class toFind : entityTypes) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                if (this.entityMap.containsKey(toFind)) {
                    for (class_1297 entity : this.entityMap.get(toFind)) {
                        double cost;
                        if (this.entityBlacklist.unreachable(entity) || !entity.method_5805() || !acceptPredicate.test(entity) || !((cost = entity.method_5707(position)) < minCost)) continue;
                        minCost = cost;
                        closestEntity = entity;
                    }
                }
            }
        }
        return Optional.ofNullable(closestEntity);
    }

    public boolean itemDropped(class_1792 ... items) {
        this.ensureUpdated();
        for (class_1792 item : items) {
            if (!this.itemDropLocations.containsKey(item)) continue;
            for (class_1542 entity : this.itemDropLocations.get(item)) {
                if (this.entityBlacklist.unreachable(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemDropped(ItemTarget ... targets) {
        this.ensureUpdated();
        for (ItemTarget target : targets) {
            if (!this.itemDropped(target.getMatches())) continue;
            return true;
        }
        return false;
    }

    public List<class_1542> getDroppedItems() {
        this.ensureUpdated();
        return this.itemDropLocations.values().stream().reduce(new ArrayList(), (result, drops) -> {
            result.addAll(drops);
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entityFound(Predicate<class_1297> shouldAccept, Class ... types) {
        this.ensureUpdated();
        for (Class type : types = this.parsePossiblyNullEntityTypes(types)) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                for (class_1297 entity : this.entityMap.getOrDefault(type, Collections.emptyList())) {
                    if (!shouldAccept.test(entity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean entityFound(Class ... types) {
        return this.entityFound((class_1297 check) -> true, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends class_1297> List<T> getTrackedEntities(Class<T> type) {
        this.ensureUpdated();
        if (!this.entityFound(type)) {
            return Collections.emptyList();
        }
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.entityMap.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_1297> getCloseEntities() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.closeEntities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CachedProjectile> getProjectiles() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.projectiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_1309> getHostiles() {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.hostiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlayerLoaded(String name) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.playerMap.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllLoadedPlayerUsernames() {
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return new ArrayList<String>(this.playerMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<class_243> getPlayerMostRecentPosition(String name) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return Optional.ofNullable(this.playerLastCoordinates.getOrDefault(name, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<class_1657> getPlayerEntity(String name) {
        if (this.isPlayerLoaded(name)) {
            Object object = BaritoneHelper.MINECRAFT_LOCK;
            synchronized (object) {
                return Optional.of(this.playerMap.get(name));
            }
        }
        return Optional.empty();
    }

    public void requestEntityUnreachable(class_1297 entity) {
        this.entityBlacklist.blackListItem(this.mod, entity, 3);
    }

    public boolean isEntityReachable(class_1297 entity) {
        return !this.entityBlacklist.unreachable(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void updateState() {
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            this.itemDropLocations.clear();
            this.entityMap.clear();
            this.closeEntities.clear();
            this.projectiles.clear();
            this.hostiles.clear();
            this.playerMap.clear();
            if (this.mod.getWorld() != null) {
                this.entitiesCollidingWithPlayer.clear();
                for (Map.Entry<class_1309, List<class_1297>> collisions : this.entitiesCollidingWithPlayerAccumulator.entrySet()) {
                    this.entitiesCollidingWithPlayer.put(collisions.getKey(), new HashSet());
                    this.entitiesCollidingWithPlayer.get(collisions.getKey()).addAll((Collection<class_1297>)collisions.getValue());
                }
                this.entitiesCollidingWithPlayerAccumulator.clear();
                for (class_1297 entity : this.mod.getWorld().method_27909()) {
                    Class type = entity.getClass();
                    type = EntityTracker.squashType(type);
                    if (entity == null || !entity.method_5805() || type == class_1309.class && entity.equals((Object)this.mod.getPlayer())) continue;
                    if (!this.entityMap.containsKey(type)) {
                        this.entityMap.put(type, new ArrayList());
                    }
                    this.entityMap.get(type).add(entity);
                    if (this.mod.getControllerExtras().inRange(entity)) {
                        this.closeEntities.add(entity);
                    }
                    if (entity instanceof class_1542) {
                        class_1542 ientity = (class_1542)entity;
                        class_1792 droppedItem = ientity.method_6983().method_7909();
                        if (ientity.method_24828() || ientity.method_5799() || WorldHelper.isSolidBlock(this.mod, ientity.method_24515().method_10087(2)) || WorldHelper.isSolidBlock(this.mod, ientity.method_24515().method_10087(3))) {
                            if (!this.itemDropLocations.containsKey(droppedItem)) {
                                this.itemDropLocations.put(droppedItem, new ArrayList());
                            }
                            this.itemDropLocations.get(droppedItem).add(ientity);
                        }
                    }
                    if (entity instanceof class_1308) {
                        boolean closeEnough;
                        if (!EntityHelper.isAngryAtPlayer(this.mod, entity) || !(closeEnough = entity.method_24516((class_1297)this.mod.getPlayer(), 26.0))) continue;
                        this.hostiles.add((class_1309)entity);
                        continue;
                    }
                    if (entity instanceof class_1676) {
                        class_1676 projEntity = (class_1676)entity;
                        if (this.mod.getBehaviour().shouldAvoidDodgingProjectile(entity)) continue;
                        CachedProjectile proj = new CachedProjectile();
                        boolean inGround = false;
                        if (entity instanceof class_1665) {
                            inGround = ((PersistentProjectileEntityAccessor)entity).isInGround();
                        }
                        if (projEntity instanceof class_1536 || projEntity instanceof class_1684 || projEntity instanceof class_1683 || inGround) continue;
                        proj.position = projEntity.method_19538();
                        proj.velocity = projEntity.method_18798();
                        proj.gravity = ProjectileHelper.hasGravity(projEntity) ? (double)0.05f : 0.0;
                        proj.projectileType = projEntity.getClass();
                        this.projectiles.add(proj);
                        continue;
                    }
                    if (!(entity instanceof class_1657)) continue;
                    class_1657 player = (class_1657)entity;
                    String name = player.method_5477().getString();
                    this.playerMap.put(name, player);
                    this.playerLastCoordinates.put(name, player.method_19538());
                }
            }
        }
    }

    @Override
    protected void reset() {
        this.entityBlacklist.clear();
    }
}

