/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.BlockTagVer;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.util.WoodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2609;
import net.minecraft.class_3620;

public class ItemHelper {
    public static final class_1792[] SAPLINGS = new class_1792[]{class_1802.field_17535, class_1802.field_17536, class_1802.field_17537, class_1802.field_17538, class_1802.field_17539, class_1802.field_17540, class_1802.field_37508, class_1802.field_42688};
    public static final class_2248[] SAPLING_SOURCES = new class_2248[]{class_2246.field_10503, class_2246.field_9988, class_2246.field_10539, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37544, class_2246.field_42731};
    public static final class_1792[] HOSTILE_MOB_DROPS = new class_1792[]{class_1802.field_8894, class_1802.field_8153, class_1802.field_8726, class_1802.field_8544, class_1802.field_8511, class_1802.field_8470, class_1802.field_8054, class_1802.field_8681, class_1802.field_8288, class_1802.field_8687, class_1802.field_8389, class_1802.field_8261, class_1802.field_8745, class_1802.field_8135, class_1802.field_8614, class_1802.field_8107, class_1802.field_8175, class_1802.field_8815, class_1802.field_8606, class_1802.field_8398, class_1802.field_8777, class_1802.field_8276, class_1802.field_8680, class_1802.field_37525, class_1802.field_8469, class_1802.field_8601, class_1802.field_8725, class_1802.field_8600, class_1802.field_8479, class_1802.field_8574, class_1802.field_8137, class_1802.field_8713, class_1802.field_8791, class_1802.field_8070, class_1802.field_8620, class_1802.field_8179, class_1802.field_8567, class_1802.field_8512, class_1802.field_27022};
    public static final class_1792[] DIRTS = new class_1792[]{class_1802.field_8831, class_1802.field_8519, class_1802.field_8460, class_1802.field_28655};
    public static final class_1792[] PLANKS = new class_1792[]{class_1802.field_8651, class_1802.field_8191, class_1802.field_22031, class_1802.field_8404, class_1802.field_8118, class_1802.field_8842, class_1802.field_8113, class_1802.field_22032, class_1802.field_37507, class_1802.field_42687, class_1802.field_40213};
    public static final class_1792[] LEAVES = new class_1792[]{class_1802.field_17507, class_1802.field_17505, class_1802.field_17508, class_1802.field_17503, class_1802.field_17506, class_1802.field_17504, class_1802.field_37511, class_1802.field_42694};
    public static final class_1792[] WOOD = new class_1792[]{class_1802.field_8587, class_1802.field_8201, class_1802.field_22489, class_1802.field_8458, class_1802.field_8888, class_1802.field_8439, class_1802.field_8210, class_1802.field_22490, class_1802.field_37510};
    public static final class_1792[] WOOD_BUTTON = new class_1792[]{class_1802.field_8605, class_1802.field_8174, class_1802.field_22004, class_1802.field_8531, class_1802.field_8780, class_1802.field_8887, class_1802.field_8048, class_1802.field_22005, class_1802.field_37530, class_1802.field_40223, class_1802.field_42701};
    public static final class_1792[] WOOD_SIGN = new class_1792[]{class_1802.field_8203, class_1802.field_8422, class_1802.field_22011, class_1802.field_8496, class_1802.field_8788, class_1802.field_8867, class_1802.field_8111, class_1802.field_22012, class_1802.field_37534, class_1802.field_40228, class_1802.field_42709};
    public static final class_1792[] WOOD_HANGING_SIGN = new class_1792[]{class_1802.field_40233, class_1802.field_40231, class_1802.field_40237, class_1802.field_40234, class_1802.field_40229, class_1802.field_40232, class_1802.field_40230, class_1802.field_40238, class_1802.field_40235, class_1802.field_40236, class_1802.field_42708};
    public static final class_1792[] WOOD_PRESSURE_PLATE = new class_1792[]{class_1802.field_8173, class_1802.field_8779, class_1802.field_21993, class_1802.field_8886, class_1802.field_8391, class_1802.field_8047, class_1802.field_8707, class_1802.field_21994, class_1802.field_37527, class_1802.field_40221, class_1802.field_42704};
    public static final class_1792[] WOOD_FENCE = new class_1792[]{class_1802.field_8646, class_1802.field_8457, class_1802.field_8454, class_1802.field_8792, class_1802.field_8823, class_1802.field_8701, class_1802.field_21995, class_1802.field_21996, class_1802.field_37520, class_1802.field_40218, class_1802.field_42698};
    public static final class_1792[] WOOD_FENCE_GATE = new class_1792[]{class_1802.field_8114, class_1802.field_8289, class_1802.field_8293, class_1802.field_8874, class_1802.field_8097, class_1802.field_8653, class_1802.field_21997, class_1802.field_21998, class_1802.field_37532, class_1802.field_40227, class_1802.field_42703};
    public static final class_1792[] WOOD_BOAT = new class_1792[]{class_1802.field_8094, class_1802.field_8442, class_1802.field_8138, class_1802.field_8533, class_1802.field_8730, class_1802.field_8486, class_1802.field_37531, class_1802.field_42706};
    public static final class_1792[] WOOD_DOOR = new class_1792[]{class_1802.field_8758, class_1802.field_8438, class_1802.field_22010, class_1802.field_8517, class_1802.field_8691, class_1802.field_8199, class_1802.field_8165, class_1802.field_22009, class_1802.field_37528, class_1802.field_40222, class_1802.field_42705};
    public static final class_1792[] WOOD_SLAB = new class_1792[]{class_1802.field_8400, class_1802.field_8843, class_1802.field_21985, class_1802.field_8540, class_1802.field_8320, class_1802.field_8224, class_1802.field_8189, class_1802.field_21986, class_1802.field_37516, class_1802.field_40216, class_1802.field_42697};
    public static final class_1792[] WOOD_STAIRS = new class_1792[]{class_1802.field_8445, class_1802.field_8130, class_1802.field_22006, class_1802.field_8658, class_1802.field_8212, class_1802.field_8311, class_1802.field_8122, class_1802.field_22007, class_1802.field_37526, class_1802.field_40219, class_1802.field_42700};
    public static final class_1792[] WOOD_TRAPDOOR = new class_1792[]{class_1802.field_8190, class_1802.field_8774, class_1802.field_22002, class_1802.field_8844, class_1802.field_8376, class_1802.field_8321, class_1802.field_8495, class_1802.field_22003, class_1802.field_37529, class_1802.field_40226, class_1802.field_42702};
    public static final class_1792[] LOG = new class_1792[]{class_1802.field_8820, class_1802.field_8170, class_1802.field_8652, class_1802.field_8583, class_1802.field_8125, class_1802.field_8684, class_1802.field_8587, class_1802.field_8201, class_1802.field_8458, class_1802.field_8888, class_1802.field_8439, class_1802.field_8210, class_1802.field_8072, class_1802.field_8767, class_1802.field_8808, class_1802.field_8415, class_1802.field_8334, class_1802.field_8624, class_1802.field_8284, class_1802.field_8472, class_1802.field_8219, class_1802.field_8248, class_1802.field_8785, class_1802.field_8362, class_1802.field_21981, class_1802.field_21982, class_1802.field_22489, class_1802.field_22490, class_1802.field_21983, class_1802.field_21984, class_1802.field_22487, class_1802.field_22488, class_1802.field_37512, class_1802.field_37510, class_1802.field_37515, class_1802.field_37509, class_1802.field_42692, class_1802.field_42691, class_1802.field_42693, class_1802.field_42690};
    public static final class_1792[] STRIPPED_LOGS = new class_1792[]{class_1802.field_8072, class_1802.field_8767, class_1802.field_8808, class_1802.field_8415, class_1802.field_8334, class_1802.field_8624, class_1802.field_21983, class_1802.field_21984, class_1802.field_37515, class_1802.field_42693};
    public static final class_1792[] STRIPPABLE_LOGS = new class_1792[]{class_1802.field_8820, class_1802.field_8170, class_1802.field_8652, class_1802.field_8583, class_1802.field_8125, class_1802.field_8684, class_1802.field_21981, class_1802.field_21982, class_1802.field_37512, class_1802.field_42692};
    public static final class_1792[] DYE = new class_1792[]{class_1802.field_8446, class_1802.field_8226, class_1802.field_8345, class_1802.field_8099, class_1802.field_8632, class_1802.field_8298, class_1802.field_8408, class_1802.field_8273, class_1802.field_8851, class_1802.field_8131, class_1802.field_8669, class_1802.field_8492, class_1802.field_8330, class_1802.field_8296, class_1802.field_8264, class_1802.field_8192};
    public static final class_1792[] WOOL = new class_1792[]{class_1802.field_19044, class_1802.field_19059, class_1802.field_19055, class_1802.field_19056, class_1802.field_19053, class_1802.field_19051, class_1802.field_19057, class_1802.field_19047, class_1802.field_19052, class_1802.field_19049, class_1802.field_19046, class_1802.field_19045, class_1802.field_19050, class_1802.field_19054, class_1802.field_19058, class_1802.field_19048};
    public static final class_1792[] BED = new class_1792[]{class_1802.field_8258, class_1802.field_8112, class_1802.field_8893, class_1802.field_8464, class_1802.field_8390, class_1802.field_8754, class_1802.field_8368, class_1802.field_8286, class_1802.field_8146, class_1802.field_8679, class_1802.field_8349, class_1802.field_8059, class_1802.field_8417, class_1802.field_8262, class_1802.field_8789, class_1802.field_8863};
    public static final class_1792[] CARPET = new class_1792[]{class_1802.field_8850, class_1802.field_8611, class_1802.field_8115, class_1802.field_8294, class_1802.field_8290, class_1802.field_8875, class_1802.field_8664, class_1802.field_8078, class_1802.field_8654, class_1802.field_8253, class_1802.field_8384, class_1802.field_8683, class_1802.field_8580, class_1802.field_8098, class_1802.field_8482, class_1802.field_8142};
    public static final class_1792[] SHULKER_BOXES = new class_1792[]{class_1802.field_8722, class_1802.field_8268, class_1802.field_8350, class_1802.field_8584, class_1802.field_8213, class_1802.field_8627, class_1802.field_8461, class_1802.field_8829, class_1802.field_8451, class_1802.field_8548, class_1802.field_8050, class_1802.field_8380, class_1802.field_8520, class_1802.field_8816, class_1802.field_8676, class_1802.field_8271};
    public static final class_1792[] FLOWER = new class_1792[]{class_1802.field_17500, class_1802.field_17501, class_1802.field_17499, class_1802.field_17513, class_1802.field_8491, class_1802.field_17526, class_1802.field_17514, class_1802.field_17509, class_1802.field_17512, class_1802.field_17511, class_1802.field_8880, class_1802.field_17529, class_1802.field_17502, class_1802.field_17527, class_1802.field_17525, class_1802.field_17510};
    public static final class_1792[] LEATHER_ARMORS = new class_1792[]{class_1802.field_8577, class_1802.field_8570, class_1802.field_8267, class_1802.field_8370};
    public static final class_1792[] GOLDEN_ARMORS = new class_1792[]{class_1802.field_8678, class_1802.field_8416, class_1802.field_8862, class_1802.field_8753};
    public static final class_1792[] IRON_ARMORS = new class_1792[]{class_1802.field_8523, class_1802.field_8396, class_1802.field_8743, class_1802.field_8660};
    public static final class_1792[] DIAMOND_ARMORS = new class_1792[]{class_1802.field_8058, class_1802.field_8348, class_1802.field_8805, class_1802.field_8285};
    public static final class_1792[] NETHERITE_ARMORS = new class_1792[]{class_1802.field_22028, class_1802.field_22029, class_1802.field_22027, class_1802.field_22030};
    public static final class_1792[] CHAINMAIL_ARMORS = new class_1792[]{class_1802.field_8873, class_1802.field_8218, class_1802.field_8283, class_1802.field_8313};
    public static final class_1792[] WOODEN_TOOLS = new class_1792[]{class_1802.field_8647, class_1802.field_8876, class_1802.field_8091, class_1802.field_8406, class_1802.field_8167};
    public static final class_1792[] STONE_TOOLS = new class_1792[]{class_1802.field_8387, class_1802.field_8776, class_1802.field_8528, class_1802.field_8062, class_1802.field_8431};
    public static final class_1792[] IRON_TOOLS = new class_1792[]{class_1802.field_8403, class_1802.field_8699, class_1802.field_8371, class_1802.field_8475, class_1802.field_8609};
    public static final class_1792[] GOLDEN_TOOLS = new class_1792[]{class_1802.field_8335, class_1802.field_8322, class_1802.field_8845, class_1802.field_8825, class_1802.field_8303};
    public static final class_1792[] DIAMOND_TOOLS = new class_1792[]{class_1802.field_8377, class_1802.field_8250, class_1802.field_8802, class_1802.field_8556, class_1802.field_8527};
    public static final class_1792[] NETHERITE_TOOLS = new class_1792[]{class_1802.field_22024, class_1802.field_22023, class_1802.field_22022, class_1802.field_22025, class_1802.field_22026};
    public static final class_2248[] WOOD_SIGNS_ALL = new class_2248[]{class_2246.field_10284, class_2246.field_10231, class_2246.field_10330, class_2246.field_10121, class_2246.field_10544, class_2246.field_10411, class_2246.field_10401, class_2246.field_10391, class_2246.field_10265, class_2246.field_10187, class_2246.field_10587, class_2246.field_10088, class_2246.field_37554, class_2246.field_37552, class_2246.field_40277, class_2246.field_40261, class_2246.field_42735, class_2246.field_42736};
    private static final Map<class_1792, class_1792> logToPlanks = new HashMap<class_1792, class_1792>(){
        {
            this.put(class_1802.field_42692, class_1802.field_42687);
            this.put(class_1802.field_42691, class_1802.field_42687);
            this.put(class_1802.field_42693, class_1802.field_42687);
            this.put(class_1802.field_42690, class_1802.field_42687);
            this.put(class_1802.field_37512, class_1802.field_37507);
            this.put(class_1802.field_37510, class_1802.field_37507);
            this.put(class_1802.field_37515, class_1802.field_37507);
            this.put(class_1802.field_37509, class_1802.field_37507);
            this.put(class_1802.field_8820, class_1802.field_8651);
            this.put(class_1802.field_8170, class_1802.field_8191);
            this.put(class_1802.field_21981, class_1802.field_22031);
            this.put(class_1802.field_8652, class_1802.field_8404);
            this.put(class_1802.field_8583, class_1802.field_8118);
            this.put(class_1802.field_8125, class_1802.field_8842);
            this.put(class_1802.field_8684, class_1802.field_8113);
            this.put(class_1802.field_21982, class_1802.field_22032);
            this.put(class_1802.field_8072, class_1802.field_8651);
            this.put(class_1802.field_8767, class_1802.field_8191);
            this.put(class_1802.field_21983, class_1802.field_22031);
            this.put(class_1802.field_8808, class_1802.field_8404);
            this.put(class_1802.field_8415, class_1802.field_8118);
            this.put(class_1802.field_8334, class_1802.field_8842);
            this.put(class_1802.field_8624, class_1802.field_8113);
            this.put(class_1802.field_21984, class_1802.field_22032);
            this.put(class_1802.field_8587, class_1802.field_8651);
            this.put(class_1802.field_8201, class_1802.field_8191);
            this.put(class_1802.field_22489, class_1802.field_22031);
            this.put(class_1802.field_8458, class_1802.field_8404);
            this.put(class_1802.field_8888, class_1802.field_8118);
            this.put(class_1802.field_8439, class_1802.field_8842);
            this.put(class_1802.field_8210, class_1802.field_8113);
            this.put(class_1802.field_22490, class_1802.field_22032);
            this.put(class_1802.field_8284, class_1802.field_8651);
            this.put(class_1802.field_8472, class_1802.field_8191);
            this.put(class_1802.field_22487, class_1802.field_22031);
            this.put(class_1802.field_8219, class_1802.field_8404);
            this.put(class_1802.field_8248, class_1802.field_8118);
            this.put(class_1802.field_8785, class_1802.field_8842);
            this.put(class_1802.field_8362, class_1802.field_8113);
            this.put(class_1802.field_22488, class_1802.field_22032);
        }
    };
    private static final Map<class_1792, class_1792> planksToLogs = new HashMap<class_1792, class_1792>(){
        {
            this.put(class_1802.field_42687, class_1802.field_42692);
            this.put(class_1802.field_37507, class_1802.field_37512);
            this.put(class_1802.field_8651, class_1802.field_8820);
            this.put(class_1802.field_8191, class_1802.field_8170);
            this.put(class_1802.field_22031, class_1802.field_21981);
            this.put(class_1802.field_8404, class_1802.field_8652);
            this.put(class_1802.field_8118, class_1802.field_8583);
            this.put(class_1802.field_8842, class_1802.field_8125);
            this.put(class_1802.field_8113, class_1802.field_8684);
            this.put(class_1802.field_22032, class_1802.field_21982);
        }
    };
    private static final Map<class_1792, class_1792> strippedToLogs = new HashMap<class_1792, class_1792>(){
        {
            this.put(class_1802.field_42693, class_1802.field_42692);
            this.put(class_1802.field_37515, class_1802.field_37512);
            this.put(class_1802.field_8072, class_1802.field_8820);
            this.put(class_1802.field_8767, class_1802.field_8170);
            this.put(class_1802.field_21983, class_1802.field_21981);
            this.put(class_1802.field_8808, class_1802.field_8652);
            this.put(class_1802.field_8415, class_1802.field_8583);
            this.put(class_1802.field_8334, class_1802.field_8125);
            this.put(class_1802.field_8624, class_1802.field_8684);
            this.put(class_1802.field_21984, class_1802.field_21982);
        }
    };
    private static final Map<class_3620, ColorfulItems> colorMap = new HashMap<class_3620, ColorfulItems>(){
        {
            this.p(class_1767.field_7964, "red", class_1802.field_8264, class_1802.field_19058, class_1802.field_8789, class_1802.field_8482, class_1802.field_8636, class_1802.field_8879, class_1802.field_8353, class_1802.field_8870, class_1802.field_8197, class_1802.field_8757, class_1802.field_8586, class_1802.field_8676, class_2246.field_10279);
            this.p(class_1767.field_7952, "white", class_1802.field_8446, class_1802.field_19044, class_1802.field_8258, class_1802.field_8850, class_1802.field_8483, class_1802.field_8736, class_1802.field_8156, class_1802.field_8177, class_1802.field_8341, class_1802.field_8582, class_1802.field_8539, class_1802.field_8722, class_2246.field_10202);
            this.p(class_1767.field_7963, "black", class_1802.field_8226, class_1802.field_19059, class_1802.field_8112, class_1802.field_8611, class_1802.field_8410, class_1802.field_8157, class_1802.field_8181, class_1802.field_8096, class_1802.field_8704, class_1802.field_8516, class_1802.field_8572, class_1802.field_8268, class_2246.field_10537);
            this.p(class_1767.field_7966, "blue", class_1802.field_8345, class_1802.field_19055, class_1802.field_8893, class_1802.field_8115, class_1802.field_8126, class_1802.field_8747, class_1802.field_8455, class_1802.field_8484, class_1802.field_8737, class_1802.field_8164, class_1802.field_8128, class_1802.field_8350, class_2246.field_10067);
            this.p(class_1767.field_7957, "brown", class_1802.field_8099, class_1802.field_19056, class_1802.field_8464, class_1802.field_8294, class_1802.field_8332, class_1802.field_8501, class_1802.field_8467, class_1802.field_8394, class_1802.field_8762, class_1802.field_8437, class_1802.field_8124, class_1802.field_8584, class_2246.field_10370);
            this.p(class_1767.field_7955, "cyan", class_1802.field_8632, class_1802.field_19053, class_1802.field_8390, class_1802.field_8290, class_1802.field_8685, class_1802.field_8085, class_1802.field_8821, class_1802.field_8257, class_1802.field_8637, class_1802.field_8593, class_1802.field_8629, class_1802.field_8213, class_2246.field_10372);
            this.p(class_1767.field_7944, "gray", class_1802.field_8298, class_1802.field_19051, class_1802.field_8754, class_1802.field_8875, class_1802.field_8507, class_1802.field_8871, class_1802.field_8304, class_1802.field_8885, class_1802.field_8333, class_1802.field_8818, class_1802.field_8617, class_1802.field_8627, class_2246.field_10267);
            this.p(class_1767.field_7942, "green", class_1802.field_8408, class_1802.field_19057, class_1802.field_8368, class_1802.field_8664, class_1802.field_8734, class_1802.field_8656, class_1802.field_8798, class_1802.field_8244, class_1802.field_8120, class_1802.field_8198, class_1802.field_8295, class_1802.field_8461, class_2246.field_10594);
            this.p(class_1767.field_7951, "light_blue", class_1802.field_8273, class_1802.field_19047, class_1802.field_8286, class_1802.field_8078, class_1802.field_8869, class_1802.field_8196, class_1802.field_8717, class_1802.field_8640, class_1802.field_8364, class_1802.field_8764, class_1802.field_8379, class_1802.field_8829, class_2246.field_10050);
            this.p(class_1767.field_7967, "light_gray", class_1802.field_8851, class_1802.field_19052, class_1802.field_8146, class_1802.field_8654, class_1802.field_8363, class_1802.field_8240, class_1802.field_8133, class_1802.field_8172, class_1802.field_8735, class_1802.field_8558, class_1802.field_8855, class_1802.field_8451, class_2246.field_10604);
            this.p(class_1767.field_7961, "lime", class_1802.field_8131, class_1802.field_19049, class_1802.field_8679, class_1802.field_8253, class_1802.field_8340, class_1802.field_8581, class_1802.field_8672, class_1802.field_8649, class_1802.field_8839, class_1802.field_8418, class_1802.field_8778, class_1802.field_8548, class_2246.field_10318);
            this.p(class_1767.field_7958, "magenta", class_1802.field_8669, class_1802.field_19046, class_1802.field_8349, class_1802.field_8384, class_1802.field_8243, class_1802.field_8119, class_1802.field_8783, class_1802.field_8318, class_1802.field_8508, class_1802.field_8336, class_1802.field_8671, class_1802.field_8050, class_2246.field_10274);
            this.p(class_1767.field_7946, "orange", class_1802.field_8492, class_1802.field_19045, class_1802.field_8059, class_1802.field_8683, class_1802.field_8393, class_1802.field_8761, class_1802.field_8043, class_1802.field_8139, class_1802.field_8771, class_1802.field_8487, class_1802.field_8824, class_1802.field_8380, class_2246.field_10599);
            this.p(class_1767.field_7954, "pink", class_1802.field_8330, class_1802.field_19050, class_1802.field_8417, class_1802.field_8580, class_1802.field_8770, class_1802.field_8500, class_1802.field_8853, class_1802.field_8277, class_1802.field_8127, class_1802.field_8222, class_1802.field_8329, class_1802.field_8520, class_2246.field_10531);
            this.p(class_1767.field_7945, "purple", class_1802.field_8296, class_1802.field_19054, class_1802.field_8262, class_1802.field_8098, class_1802.field_8838, class_1802.field_8739, class_1802.field_8715, class_1802.field_8562, class_1802.field_8411, class_1802.field_8690, class_1802.field_8405, class_1802.field_8816, class_2246.field_10054);
            this.p(class_1767.field_7964, "red", class_1802.field_8264, class_1802.field_19058, class_1802.field_8789, class_1802.field_8482, class_1802.field_8636, class_1802.field_8879, class_1802.field_8353, class_1802.field_8870, class_1802.field_8197, class_1802.field_8757, class_1802.field_8586, class_1802.field_8676, class_2246.field_10279);
            this.p(class_1767.field_7947, "yellow", class_1802.field_8192, class_1802.field_19048, class_1802.field_8863, class_1802.field_8142, class_1802.field_8095, class_1802.field_8703, class_1802.field_8385, class_1802.field_8889, class_1802.field_8686, class_1802.field_8205, class_1802.field_8049, class_1802.field_8271, class_2246.field_10139);
        }

        void p(class_1767 color, String colorName, class_1792 dye, class_1792 wool, class_1792 bed, class_1792 carpet, class_1792 stainedGlass, class_1792 stainedGlassPane, class_1792 terracotta, class_1792 glazedTerracotta, class_1792 concrete, class_1792 concretePowder, class_1792 banner, class_1792 shulker, class_2248 wallBanner) {
            this.put(color.method_7794(), new ColorfulItems(color, colorName, dye, wool, bed, carpet, stainedGlass, stainedGlassPane, terracotta, glazedTerracotta, concrete, concretePowder, banner, shulker, wallBanner));
        }
    };
    private static final Map<WoodType, WoodItems> woodMap = new HashMap<WoodType, WoodItems>(){
        {
            this.p(WoodType.CHERRY, "cherry", class_1802.field_42687, class_1802.field_42692, class_1802.field_42693, class_1802.field_42690, class_1802.field_42691, class_1802.field_42709, class_1802.field_42708, class_1802.field_42705, class_1802.field_42701, class_1802.field_42700, class_1802.field_42697, class_1802.field_42698, class_1802.field_42703, class_1802.field_42706, class_1802.field_42688, class_1802.field_42694, class_1802.field_42704, class_1802.field_42702);
            this.p(WoodType.BAMBOO, "bamboo", null, null, class_1802.field_41065, null, null, class_1802.field_40228, class_1802.field_40236, class_1802.field_40222, class_1802.field_40223, class_1802.field_40219, class_1802.field_40216, class_1802.field_40218, class_1802.field_40227, class_1802.field_40224, class_1802.field_8648, null, class_1802.field_40221, class_1802.field_40226);
            this.p(WoodType.MANGROVE, "mangrove", class_1802.field_37507, class_1802.field_37512, class_1802.field_37515, class_1802.field_37509, class_1802.field_37510, class_1802.field_37534, class_1802.field_40235, class_1802.field_37528, class_1802.field_37530, class_1802.field_37526, class_1802.field_37516, class_1802.field_37520, class_1802.field_37532, class_1802.field_37531, class_1802.field_37508, class_1802.field_37511, class_1802.field_37527, class_1802.field_37529);
            this.p(WoodType.ACACIA, "acacia", class_1802.field_8651, class_1802.field_8820, class_1802.field_8072, class_1802.field_8284, class_1802.field_8587, class_1802.field_8203, class_1802.field_40233, class_1802.field_8758, class_1802.field_8605, class_1802.field_8445, class_1802.field_8400, class_1802.field_8646, class_1802.field_8114, class_1802.field_8094, class_1802.field_17539, class_1802.field_17507, class_1802.field_8173, class_1802.field_8190);
            this.p(WoodType.BIRCH, "birch", class_1802.field_8191, class_1802.field_8170, class_1802.field_8767, class_1802.field_8472, class_1802.field_8201, class_1802.field_8422, class_1802.field_40231, class_1802.field_8438, class_1802.field_8174, class_1802.field_8130, class_1802.field_8843, class_1802.field_8457, class_1802.field_8289, class_1802.field_8442, class_1802.field_17537, class_1802.field_17505, class_1802.field_8779, class_1802.field_8774);
            this.p(WoodType.CRIMSON, "crimson", class_1802.field_22031, class_1802.field_21981, class_1802.field_21983, class_1802.field_22487, class_1802.field_22489, class_1802.field_22011, class_1802.field_40237, class_1802.field_22010, class_1802.field_22004, class_1802.field_22006, class_1802.field_21985, class_1802.field_21995, class_1802.field_21997, null, class_1802.field_21987, null, class_1802.field_21993, class_1802.field_22002);
            this.p(WoodType.DARK_OAK, "dark_oak", class_1802.field_8404, class_1802.field_8652, class_1802.field_8808, class_1802.field_8219, class_1802.field_8458, class_1802.field_8496, class_1802.field_40234, class_1802.field_8517, class_1802.field_8531, class_1802.field_8658, class_1802.field_8540, class_1802.field_8454, class_1802.field_8293, class_1802.field_8138, class_1802.field_17540, class_1802.field_17508, class_1802.field_8886, class_1802.field_8844);
            this.p(WoodType.OAK, "oak", class_1802.field_8118, class_1802.field_8583, class_1802.field_8415, class_1802.field_8248, class_1802.field_8888, class_1802.field_8788, class_1802.field_40229, class_1802.field_8691, class_1802.field_8780, class_1802.field_8212, class_1802.field_8320, class_1802.field_8792, class_1802.field_8874, class_1802.field_8533, class_1802.field_17535, class_1802.field_17503, class_1802.field_8391, class_1802.field_8376);
            this.p(WoodType.JUNGLE, "jungle", class_1802.field_8842, class_1802.field_8125, class_1802.field_8334, class_1802.field_8785, class_1802.field_8439, class_1802.field_8867, class_1802.field_40232, class_1802.field_8199, class_1802.field_8887, class_1802.field_8311, class_1802.field_8224, class_1802.field_8823, class_1802.field_8097, class_1802.field_8730, class_1802.field_17538, class_1802.field_17506, class_1802.field_8047, class_1802.field_8321);
            this.p(WoodType.SPRUCE, "spruce", class_1802.field_8113, class_1802.field_8684, class_1802.field_8624, class_1802.field_8362, class_1802.field_8210, class_1802.field_8111, class_1802.field_40230, class_1802.field_8165, class_1802.field_8048, class_1802.field_8122, class_1802.field_8189, class_1802.field_8701, class_1802.field_8653, class_1802.field_8486, class_1802.field_17536, class_1802.field_17504, class_1802.field_8707, class_1802.field_8495);
            this.p(WoodType.WARPED, "warped", class_1802.field_22032, class_1802.field_21982, class_1802.field_21984, class_1802.field_22488, class_1802.field_22490, class_1802.field_22012, class_1802.field_40238, class_1802.field_22009, class_1802.field_22005, class_1802.field_22007, class_1802.field_21986, class_1802.field_21996, class_1802.field_21998, null, class_1802.field_21988, null, class_1802.field_21994, class_1802.field_22003);
        }

        void p(WoodType type, String prefix, class_1792 planks, class_1792 log, class_1792 strippedLog, class_1792 strippedWood, class_1792 wood, class_1792 sign, class_1792 hangingSign, class_1792 door, class_1792 button, class_1792 stairs, class_1792 slab, class_1792 fence, class_1792 fenceGate, class_1792 boat, class_1792 sapling, class_1792 leaves, class_1792 pressurePlate, class_1792 trapdoor) {
            this.put(type, new WoodItems(prefix, planks, log, strippedLog, strippedWood, wood, sign, hangingSign, door, button, stairs, slab, fence, fenceGate, boat, sapling, leaves, pressurePlate, trapdoor));
        }
    };
    public static final HashMap<class_1792, class_1792> cookableFoodMap = new HashMap<class_1792, class_1792>(){
        {
            this.put(class_1802.field_8389, class_1802.field_8261);
            this.put(class_1802.field_8046, class_1802.field_8176);
            this.put(class_1802.field_8726, class_1802.field_8544);
            this.put(class_1802.field_8748, class_1802.field_8347);
            this.put(class_1802.field_8504, class_1802.field_8752);
            this.put(class_1802.field_8209, class_1802.field_8509);
            this.put(class_1802.field_8429, class_1802.field_8373);
            this.put(class_1802.field_8567, class_1802.field_8512);
        }
    };
    public static final class_1792[] RAW_FOODS = (class_1792[])cookableFoodMap.keySet().toArray(class_1792[]::new);
    public static final class_1792[] COOKED_FOODS = (class_1792[])cookableFoodMap.values().toArray(class_1792[]::new);
    public static final class_1792[] OTHER_FOODS = new class_1792[]{class_1802.field_8186, class_1802.field_8515, class_1802.field_8179, class_1802.field_8367, class_1802.field_8229, class_1802.field_8279, class_1802.field_8423, class_1802.field_8551, class_1802.field_8463, class_1802.field_8071, class_1802.field_8497, class_1802.field_8208, class_1802.field_8741, class_1802.field_8308};
    public static final class_1792[] FOODS = (class_1792[])Stream.of(RAW_FOODS, COOKED_FOODS, OTHER_FOODS).flatMap(Arrays::stream).toArray(class_1792[]::new);
    private static Map<class_1792, Integer> fuelTimeMap = null;

    public static String stripItemName(class_1792 item) {
        String[] possibilities;
        for (String possible : possibilities = new String[]{"item.minecraft.", "block.minecraft."}) {
            if (!item.method_7876().startsWith(possible)) continue;
            return item.method_7876().substring(possible.length());
        }
        return item.method_7876();
    }

    public static class_1792[] blocksToItems(class_2248[] blocks) {
        class_1792[] result = new class_1792[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            result[i] = blocks[i].method_8389();
        }
        return result;
    }

    public static class_2248[] itemsToBlocks(class_1792[] items) {
        ArrayList<class_2248> result = new ArrayList<class_2248>();
        for (class_1792 item : items) {
            class_2248 b;
            if (!(item instanceof class_1747) || (b = class_2248.method_9503((class_1792)item)) == null || b == class_2246.field_10124) continue;
            result.add(b);
        }
        return (class_2248[])result.toArray(class_2248[]::new);
    }

    public static class_1792 logToPlanks(class_1792 logItem) {
        return logToPlanks.getOrDefault(logItem, null);
    }

    public static class_1792 planksToLog(class_1792 plankItem) {
        return planksToLogs.getOrDefault(plankItem, null);
    }

    public static class_1792 strippedToLogs(class_1792 logItem) {
        return strippedToLogs.getOrDefault(logItem, null);
    }

    public static ColorfulItems getColorfulItems(class_3620 color) {
        return colorMap.get(color);
    }

    public static ColorfulItems getColorfulItems(class_1767 color) {
        return ItemHelper.getColorfulItems(color.method_7794());
    }

    public static Collection<ColorfulItems> getColorfulItems() {
        return colorMap.values();
    }

    public static WoodItems getWoodItems(WoodType type) {
        return woodMap.get((Object)type);
    }

    public static Collection<WoodItems> getWoodItems() {
        return woodMap.values();
    }

    public static Optional<class_1792> getCookedFood(class_1792 rawFood) {
        return Optional.ofNullable(cookableFoodMap.getOrDefault(rawFood, null));
    }

    public static String trimItemName(String name) {
        if (name.startsWith("block.minecraft.")) {
            name = name.substring("block.minecraft.".length());
        } else if (name.startsWith("item.minecraft.")) {
            name = name.substring("item.minecraft.".length());
        }
        return name;
    }

    public static boolean areShearsEffective(class_2248 b) {
        return b instanceof class_2397 || b == class_2246.field_10343 || b == class_2246.field_10479 || b == class_2246.field_10214 || b == class_2246.field_10588 || b == class_2246.field_10112 || b == class_2246.field_10428 || b == class_2246.field_10597 || b == class_2246.field_10589 || BlockTagVer.isWool(b) || b == class_2246.field_22117;
    }

    private static boolean isStackProtected(PlayerEngineController mod, class_1799 stack) {
        if (stack.method_7942() && mod.getModSettings().getDontThrowAwayEnchantedItems()) {
            return true;
        }
        return ItemVer.hasCustomName(stack) && mod.getModSettings().getDontThrowAwayCustomNameItems() ? true : mod.getBehaviour().isProtected(stack.method_7909()) || mod.getModSettings().isImportant(stack.method_7909());
    }

    public static boolean canThrowAwayStack(PlayerEngineController mod, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return ItemHelper.isStackProtected(mod, stack) ? false : mod.getModSettings().isThrowaway(stack.method_7909()) || mod.getModSettings().shouldThrowawayUnusedItems();
    }

    public static boolean canStackTogether(class_1799 from, class_1799 to) {
        return to.method_7960() && from.method_7947() <= from.method_7914() ? true : to.method_7909().equals(from.method_7909()) && from.method_7947() + to.method_7947() < to.method_7914();
    }

    private static Map<class_1792, Integer> getFuelTimeMap() {
        if (fuelTimeMap == null) {
            fuelTimeMap = class_2609.method_11196();
        }
        return fuelTimeMap;
    }

    public static double getFuelAmount(class_1792 ... items) {
        double total = 0.0;
        for (class_1792 item : items) {
            if (!ItemHelper.getFuelTimeMap().containsKey(item)) continue;
            int timeTicks = ItemHelper.getFuelTimeMap().get(item);
            total += (double)timeTicks / 200.0;
        }
        return total;
    }

    public static double getFuelAmount(class_1799 stack) {
        return ItemHelper.getFuelAmount(stack.method_7909()) * (double)stack.method_7947();
    }

    public static boolean isFuel(class_1792 item) {
        return ItemHelper.getFuelTimeMap().containsKey(item);
    }

    public boolean isRawFood(class_1792 item) {
        return cookableFoodMap.containsKey(item);
    }

    public static Optional<class_1792> getItemFromString(String query, class_1792[] itemsToPickFrom) {
        for (class_1792 item : itemsToPickFrom) {
            if (!ItemHelper.stripItemName(item).equalsIgnoreCase(query)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static class ColorfulItems {
        public class_1767 color;
        public String colorName;
        public class_1792 dye;
        public class_1792 wool;
        public class_1792 bed;
        public class_1792 carpet;
        public class_1792 stainedGlass;
        public class_1792 stainedGlassPane;
        public class_1792 terracotta;
        public class_1792 glazedTerracotta;
        public class_1792 concrete;
        public class_1792 concretePowder;
        public class_1792 banner;
        public class_1792 shulker;
        public class_2248 wallBanner;

        public ColorfulItems(class_1767 color, String colorName, class_1792 dye, class_1792 wool, class_1792 bed, class_1792 carpet, class_1792 stainedGlass, class_1792 stainedGlassPane, class_1792 terracotta, class_1792 glazedTerracotta, class_1792 concrete, class_1792 concretePowder, class_1792 banner, class_1792 shulker, class_2248 wallBanner) {
            this.color = color;
            this.colorName = colorName;
            this.dye = dye;
            this.wool = wool;
            this.bed = bed;
            this.carpet = carpet;
            this.stainedGlass = stainedGlass;
            this.stainedGlassPane = stainedGlassPane;
            this.terracotta = terracotta;
            this.glazedTerracotta = glazedTerracotta;
            this.concrete = concrete;
            this.concretePowder = concretePowder;
            this.banner = banner;
            this.shulker = shulker;
            this.wallBanner = wallBanner;
        }
    }

    public static class WoodItems {
        public String prefix;
        public class_1792 planks;
        public class_1792 log;
        public class_1792 strippedLog;
        public class_1792 strippedWood;
        public class_1792 wood;
        public class_1792 sign;
        public class_1792 hangingSign;
        public class_1792 door;
        public class_1792 button;
        public class_1792 stairs;
        public class_1792 slab;
        public class_1792 fence;
        public class_1792 fenceGate;
        public class_1792 boat;
        public class_1792 sapling;
        public class_1792 leaves;
        public class_1792 pressurePlate;
        public class_1792 trapdoor;

        public WoodItems(String prefix, class_1792 planks, class_1792 log, class_1792 strippedLog, class_1792 strippedWood, class_1792 wood, class_1792 sign, class_1792 hangingSign, class_1792 door, class_1792 button, class_1792 stairs, class_1792 slab, class_1792 fence, class_1792 fenceGate, class_1792 boat, class_1792 sapling, class_1792 leaves, class_1792 pressurePlate, class_1792 trapdoor) {
            this.prefix = prefix;
            this.planks = planks;
            this.log = log;
            this.strippedLog = strippedLog;
            this.strippedWood = strippedWood;
            this.wood = wood;
            this.sign = sign;
            this.hangingSign = hangingSign;
            this.door = door;
            this.button = button;
            this.stairs = stairs;
            this.slab = slab;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.boat = boat;
            this.sapling = sapling;
            this.leaves = leaves;
            this.pressurePlate = pressurePlate;
            this.trapdoor = trapdoor;
        }

        public boolean isNetherWood() {
            return this.planks == class_1802.field_22031 || this.planks == class_1802.field_22032;
        }
    }
}

