/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.progresscheck;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.DistanceProgressChecker;
import com.player2.playerengine.util.progresscheck.IProgressChecker;
import com.player2.playerengine.util.progresscheck.LinearProgressChecker;
import com.player2.playerengine.util.progresscheck.ProgressCheckerRetry;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class MovementProgressChecker {
    private final IProgressChecker<class_243> distanceChecker;
    private final IProgressChecker<Double> mineChecker;
    public class_2338 lastBreakingBlock = null;

    public MovementProgressChecker(double distanceTimeout, double minDistance, double mineTimeout, double minMineProgress, int attempts) {
        this.distanceChecker = new ProgressCheckerRetry<class_243>(new DistanceProgressChecker(distanceTimeout, minDistance), attempts);
        this.mineChecker = new LinearProgressChecker(mineTimeout, minMineProgress);
    }

    public MovementProgressChecker(double distanceTimeout, double minDistance, double mineTimeout, double minMineProgress) {
        this(distanceTimeout, minDistance, mineTimeout, minMineProgress, 1);
    }

    public MovementProgressChecker(int attempts) {
        this(6.0, 0.1, 10.0, 0.001, attempts);
    }

    public MovementProgressChecker() {
        this(1);
    }

    public boolean check(PlayerEngineController mod) {
        if (mod.getFoodChain().needsToEat()) {
            this.distanceChecker.reset();
            this.mineChecker.reset();
        }
        if (mod.getControllerExtras().isBreakingBlock()) {
            class_2338 breakBlock = mod.getControllerExtras().getBreakingBlockPos();
            if (this.lastBreakingBlock != null && WorldHelper.isAir(mod.getWorld().method_8320(this.lastBreakingBlock).method_26204())) {
                this.distanceChecker.reset();
                this.mineChecker.reset();
            }
            this.lastBreakingBlock = breakBlock;
            this.mineChecker.setProgress(0.0);
            return !this.mineChecker.failed();
        }
        this.mineChecker.reset();
        this.distanceChecker.setProgress(mod.getPlayer().method_19538());
        return !this.distanceChecker.failed();
    }

    public void reset() {
        this.distanceChecker.reset();
        this.mineChecker.reset();
    }
}

