/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.MCCommands;
import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.command.defaults.DefaultCommands;
import com.player2.playerengine.automaton.entity.CustomFishingBobberEntity;
import com.player2.playerengine.player2api.AgentSideEffects;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.auth.TokenStorage;
import com.player2.playerengine.player2api.manager.ConversationManager;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@KeepName
public final class PlayerEngine {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");
    public static final String MOD_ID = "playerengine";
    public static final String MOD_NAME = "PlayerEngine";
    public static final class_6862<class_1792> EMPTY_BUCKETS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)PlayerEngine.id("empty_buckets"));
    public static final class_6862<class_1792> WATER_BUCKETS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)PlayerEngine.id("water_buckets"));
    private static final ThreadPoolExecutor threadPool;
    public static final DeferredRegister<class_1299<?>> ENTITY_TYPES;
    public static RegistrySupplier<class_1299<CustomFishingBobberEntity>> FISHING_BOBBER;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static ThreadPoolExecutor getExecutor() {
        return threadPool;
    }

    public static void onInitialize() {
        DefaultCommands.registerAll();
        ENTITY_TYPES.register();
        MCCommands.onInit();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"user_message"), (buf, context) -> {
            LOGGER.info("Server: Recieved user_message packet");
            String username = context.getPlayer().method_5477().getString();
            String message = buf.method_19772();
            ConversationManager.onUserChatMessage(new Event.UserMessage(message, username));
            AgentSideEffects.broadcastChatToAllPlayers(context.getPlayer().method_5682(), String.format("<%s> %s", context.getPlayer().method_5477().getString(), message));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"request_stt"), (buf, context) -> {
            LOGGER.info("Server: Recieved request_stt packet");
            String clientId = buf.method_19772();
            String username = context.getPlayer().method_5477().getString();
            String storedToken = TokenStorage.getToken(username, clientId);
            class_9129 buf2 = new class_9129(Unpooled.buffer(), context.getPlayer().method_56673());
            buf2.method_10814(storedToken);
            LOGGER.info("Server: Sending response_stt packet w/ token {}", (Object)storedToken);
            ((class_3222)context.getPlayer()).field_13987.method_14364(NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"response_stt"), (class_9129)buf2));
        });
    }

    static {
        ENTITY_TYPES = DeferredRegister.create((String)MOD_ID, (class_5321)class_7924.field_41266);
        FISHING_BOBBER = ENTITY_TYPES.register("custom_fishing_bobber", () -> class_1299.class_1300.method_5903(CustomFishingBobberEntity::new, (class_1311)class_1311.field_6294).method_17687(class_1299.field_6103.method_17685(), class_1299.field_6103.method_17686()).method_27299(64).method_27300(1).method_5905("custom_fishing_bobber"));
        AtomicInteger threadCounter = new AtomicInteger(0);
        threadPool = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "PlayerEngine Worker " + threadCounter.incrementAndGet()));
    }
}

