/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.google.common.collect.Streams;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.control.KillAura;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.util.BlockRange;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.serialization.IFailableConfigFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;

public class PlayerEngineSettings
implements IFailableConfigFile {
    private transient boolean failedToLoad = false;
    private boolean showDebugTickMs = false;
    private boolean showTaskChains = true;
    private boolean hideAllWarningLogs = false;
    private String commandPrefix = "@";
    private String logLevel = "NORMAL";
    private String chatLogPrefix = "[Alto Clef] ";
    private boolean showTimer = true;
    private float containerItemMoveDelay = 0.2f;
    private boolean useCraftingBookToCraft = true;
    private float resourcePickupDropRange = 16.0f;
    private int minimumFoodAllowed = 0;
    private int foodUnitsToCollect = 0;
    private float resourceChestLocateRange = 500.0f;
    private float resourceMineRange = 100.0f;
    private boolean avoidSearchingDungeonChests = true;
    private boolean avoidOceanBlocks = false;
    private float entityReachRange = 4.0f;
    private boolean collectPickaxeFirst = true;
    private boolean replantCrops = true;
    private boolean mobDefense = true;
    private KillAura.Strategy forceFieldStrategy = KillAura.Strategy.SMART;
    private boolean dodgeProjectiles = true;
    private boolean killOrAvoidAnnoyingHostiles = true;
    private boolean avoidDrowning = true;
    private boolean autoCloseScreenWhenLookingOrMining = true;
    private boolean extinguishSelfWithWater = true;
    private boolean autoEat = true;
    private boolean autoMLGBucket = true;
    private boolean autoReconnect = true;
    private boolean autoRespawn = true;
    private DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR overworldToNetherBehaviour = DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR.BUILD_PORTAL_VANILLA;
    private int netherFastTravelWalkingRange = 600;
    private String idleCommand = "idle";
    private String deathCommand = "";
    private List<class_1792> throwawayItems = Arrays.asList(class_1802.field_28043, class_1802.field_28655, class_1802.field_8110, class_1802.field_8858, class_1802.field_20401, class_1802.field_20407, class_1802.field_20394, class_1802.field_27021, class_1802.field_20412, class_1802.field_8831, class_1802.field_29025, class_1802.field_17507, class_1802.field_17505, class_1802.field_17508, class_1802.field_17503, class_1802.field_17506, class_1802.field_17504, class_1802.field_8328, class_1802.field_8354, class_1802.field_21999, class_1802.field_8067, class_1802.field_20398, class_1802.field_8729, class_1802.field_22000, class_1802.field_23843, class_1802.field_20399, class_1802.field_20384, class_1802.field_20395);
    private int reservedBuildingBlockCount = 64;
    private boolean dontThrowAwayCustomNameItems = true;
    private boolean dontThrowAwayEnchantedItems = true;
    private boolean throwAwayUnusedItems = true;
    private List<class_1792> importantItems = Streams.concat((Stream[])new Stream[]{Stream.of(class_1802.field_8288, class_1802.field_8367, class_1802.field_8449, class_1802.field_8547, class_1802.field_8477, class_1802.field_8603, class_1802.field_22021, class_1802.field_22020, class_1802.field_22018), Stream.of(ItemHelper.DIAMOND_ARMORS), Stream.of(ItemHelper.NETHERITE_ARMORS), Stream.of(ItemHelper.DIAMOND_TOOLS), Stream.of(ItemHelper.NETHERITE_TOOLS), Stream.of(ItemHelper.SHULKER_BOXES)}).toList();
    private boolean limitFuelsToSupportedFuels = true;
    private List<class_1792> supportedFuels = Streams.concat((Stream[])new Stream[]{Stream.of(class_1802.field_8713, class_1802.field_8665)}).toList();
    private class_2338 homeBasePosition = new class_2338(0, 64, 0);
    private List<BlockRange> areasToProtect = Collections.emptyList();

    public static void load(Consumer<PlayerEngineSettings> onReload) {
        ConfigHelper.loadConfig("playerengine_settings.json", PlayerEngineSettings::new, PlayerEngineSettings.class, onReload);
    }

    public boolean shouldShowTaskChain() {
        return this.showTaskChains;
    }

    public boolean shouldShowDebugTickMs() {
        return this.showDebugTickMs;
    }

    public boolean shouldHideAllWarningLogs() {
        return this.hideAllWarningLogs;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public String getChatLogPrefix() {
        return this.chatLogPrefix;
    }

    public boolean shouldShowTimer() {
        return this.showTimer;
    }

    public float getResourcePickupRange() {
        return this.resourcePickupDropRange;
    }

    public float getResourceChestLocateRange() {
        return this.resourceChestLocateRange;
    }

    public float getResourceMineRange() {
        return this.resourceMineRange;
    }

    public float getContainerItemMoveDelay() {
        return this.containerItemMoveDelay;
    }

    public boolean shouldUseCraftingBookToCraft() {
        return this.useCraftingBookToCraft;
    }

    public int getFoodUnitsToCollect() {
        return this.foodUnitsToCollect;
    }

    public int getMinimumFoodAllowed() {
        return this.minimumFoodAllowed;
    }

    public boolean isMobDefense() {
        return this.mobDefense;
    }

    public boolean isDodgeProjectiles() {
        return this.dodgeProjectiles;
    }

    public boolean isAutoEat() {
        return this.autoEat;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isAutoRespawn() {
        return this.autoRespawn;
    }

    public boolean shouldReplantCrops() {
        return this.replantCrops;
    }

    public boolean shouldDealWithAnnoyingHostiles() {
        return this.killOrAvoidAnnoyingHostiles;
    }

    public KillAura.Strategy getForceFieldStrategy() {
        return this.forceFieldStrategy;
    }

    public String getIdleCommand() {
        return this.idleCommand == "" ? "idle" : this.idleCommand;
    }

    public String getDeathCommand() {
        return this.deathCommand;
    }

    public boolean shouldRunIdleCommandWhenNotActive() {
        String command = this.getIdleCommand();
        return command != null && !command.isBlank();
    }

    public boolean shouldAutoMLGBucket() {
        return this.autoMLGBucket;
    }

    public boolean shouldCollectPickaxeFirst() {
        return this.collectPickaxeFirst;
    }

    public boolean shouldAvoidDrowning() {
        return this.avoidDrowning;
    }

    public boolean shouldCloseScreenWhenLookingOrMining() {
        return this.autoCloseScreenWhenLookingOrMining;
    }

    public boolean shouldExtinguishSelfWithWater() {
        return this.extinguishSelfWithWater;
    }

    public boolean shouldAvoidSearchingForDungeonChests() {
        return this.avoidSearchingDungeonChests;
    }

    public boolean shouldAvoidOcean() {
        return this.avoidOceanBlocks;
    }

    public boolean isThrowaway(class_1792 item) {
        return this.throwawayItems.contains(item);
    }

    public boolean isImportant(class_1792 item) {
        return this.importantItems.contains(item);
    }

    public boolean shouldThrowawayUnusedItems() {
        return this.throwAwayUnusedItems;
    }

    public int getReservedBuildingBlockCount() {
        return this.reservedBuildingBlockCount;
    }

    public boolean getDontThrowAwayCustomNameItems() {
        return this.dontThrowAwayCustomNameItems;
    }

    public boolean getDontThrowAwayEnchantedItems() {
        return this.dontThrowAwayEnchantedItems;
    }

    public float getEntityReachRange() {
        return this.entityReachRange;
    }

    public class_1792[] getThrowawayItems(PlayerEngineController mod, boolean includeProtected) {
        return (class_1792[])this.throwawayItems.stream().filter(item -> includeProtected || !mod.getBehaviour().isProtected((class_1792)item)).toArray(class_1792[]::new);
    }

    public class_1792[] getThrowawayItems(PlayerEngineController mod) {
        return this.getThrowawayItems(mod, false);
    }

    public boolean shouldLimitFuelsToSupportedFuels() {
        return this.limitFuelsToSupportedFuels;
    }

    public boolean isSupportedFuel(class_1792 item) {
        return !this.limitFuelsToSupportedFuels || this.supportedFuels.contains(item);
    }

    public class_1792[] getSupportedFuelItems() {
        return (class_1792[])this.supportedFuels.toArray(class_1792[]::new);
    }

    public DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR getOverworldToNetherBehaviour() {
        return this.overworldToNetherBehaviour;
    }

    public int getNetherFastTravelWalkingRange() {
        return this.netherFastTravelWalkingRange;
    }

    public class_2338 getHomeBasePosition() {
        return this.homeBasePosition;
    }

    @Override
    public void onFailLoad() {
        this.failedToLoad = true;
    }

    @Override
    public boolean failedToLoad() {
        return this.failedToLoad;
    }
}

