/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.UpgradeInSmithingTableTask;
import com.player2.playerengine.tasks.resources.CarveThenCollectTask;
import com.player2.playerengine.tasks.resources.CollectAmethystBlockTask;
import com.player2.playerengine.tasks.resources.CollectBedTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectBlockByOneTask;
import com.player2.playerengine.tasks.resources.CollectBucketLiquidTask;
import com.player2.playerengine.tasks.resources.CollectCoarseDirtTask;
import com.player2.playerengine.tasks.resources.CollectCocoaBeansTask;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.CollectDripstoneBlockTask;
import com.player2.playerengine.tasks.resources.CollectEggsTask;
import com.player2.playerengine.tasks.resources.CollectFlintTask;
import com.player2.playerengine.tasks.resources.CollectFlowerTask;
import com.player2.playerengine.tasks.resources.CollectGoldIngotTask;
import com.player2.playerengine.tasks.resources.CollectGoldNuggetsTask;
import com.player2.playerengine.tasks.resources.CollectHayBlockTask;
import com.player2.playerengine.tasks.resources.CollectHoneycombTask;
import com.player2.playerengine.tasks.resources.CollectIronIngotTask;
import com.player2.playerengine.tasks.resources.CollectMagmaCreamTask;
import com.player2.playerengine.tasks.resources.CollectMilkTask;
import com.player2.playerengine.tasks.resources.CollectNetherBricksTask;
import com.player2.playerengine.tasks.resources.CollectObsidianTask;
import com.player2.playerengine.tasks.resources.CollectPlanksTask;
import com.player2.playerengine.tasks.resources.CollectRedSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSaplingsTask;
import com.player2.playerengine.tasks.resources.CollectSticksTask;
import com.player2.playerengine.tasks.resources.CollectStrippedLogTask;
import com.player2.playerengine.tasks.resources.CollectWheatSeedsTask;
import com.player2.playerengine.tasks.resources.CollectWheatTask;
import com.player2.playerengine.tasks.resources.CollectWoolTask;
import com.player2.playerengine.tasks.resources.GetSmithingTemplateTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.KillEndermanTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.ShearAndCollectBlockTask;
import com.player2.playerengine.tasks.resources.wood.CollectBoatTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceGateTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceTask;
import com.player2.playerengine.tasks.resources.wood.CollectHangingSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenButtonTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenDoorTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenPressurePlateTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenSlabTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenStairsTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenTrapDoorTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.WoodType;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1431;
import net.minecraft.class_1452;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1477;
import net.minecraft.class_1548;
import net.minecraft.class_1613;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3620;
import net.minecraft.class_5776;

public class TaskCatalogue {
    private static final HashMap<String, class_1792[]> nameToItemMatches = new HashMap();
    private static final HashMap<String, CataloguedResource> nameToResourceTask = new HashMap();
    private static final HashMap<class_1792, CataloguedResource> itemToResourceTask = new HashMap();
    private static final HashSet<class_1792> resourcesObtainable = new HashSet();

    private static CataloguedResource put(String name, class_1792[] matches, Function<Integer, ResourceTask> getTask) {
        ArrayList<class_1792> supportedMatches = new ArrayList<class_1792>();
        for (class_1792 item : matches) {
            supportedMatches.add(item);
        }
        matches = supportedMatches.toArray(new class_1792[0]);
        CataloguedResource result = new CataloguedResource(matches, getTask);
        class_2248[] blocks = ItemHelper.itemsToBlocks(matches);
        if (blocks.length != 0) {
            result.mineIfPresent();
        }
        result.forceDimension(Dimension.OVERWORLD);
        if (nameToResourceTask.containsKey(name)) {
            return result;
        }
        nameToResourceTask.put(name, result);
        nameToItemMatches.put(name, matches);
        resourcesObtainable.addAll(Arrays.asList(matches));
        if (matches.length == 1) {
            if (itemToResourceTask.containsKey(matches[0])) {
                throw new IllegalStateException("Tried cataloguing " + matches[0].method_7876() + " twice!");
            }
            itemToResourceTask.put(matches[0], result);
        }
        return result;
    }

    public static class_1792[] getItemMatches(String name) {
        return !nameToItemMatches.containsKey(name) ? new class_1792[]{} : nameToItemMatches.get(name);
    }

    public static boolean isObtainable(class_1792 item) {
        return resourcesObtainable.contains(item);
    }

    public static ItemTarget getItemTarget(String name, int count) {
        return new ItemTarget(name, count);
    }

    public static CataloguedResourceTask getSquashedItemTask(ItemTarget ... targets) {
        return new CataloguedResourceTask(true, targets);
    }

    public static ResourceTask getItemTask(String name, int count) {
        if (!TaskCatalogue.taskExists(name)) {
            Debug.logWarning("Task " + name + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return nameToResourceTask.get(name).getResource(count);
    }

    public static ResourceTask getItemTask(class_1792 item, int count) {
        if (!TaskCatalogue.taskExists(item)) {
            Debug.logWarning("Task " + String.valueOf(item) + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return itemToResourceTask.get(item).getResource(count);
    }

    public static ResourceTask getItemTask(ItemTarget target) {
        if (target.isCatalogueItem()) {
            return TaskCatalogue.getItemTask(target.getCatalogueName(), target.getTargetCount());
        }
        return target.getMatches().length == 1 ? TaskCatalogue.getItemTask(target.getMatches()[0], target.getTargetCount()) : TaskCatalogue.getSquashedItemTask(target);
    }

    public static boolean taskExists(String name) {
        return nameToResourceTask.containsKey(name);
    }

    public static boolean taskExists(class_1792 item) {
        return itemToResourceTask.containsKey(item);
    }

    public static Collection<String> resourceNames() {
        return nameToResourceTask.keySet();
    }

    private static CataloguedResource simple(String name, class_1792[] matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.put(name, matches, getTask);
    }

    private static CataloguedResource simple(String name, class_1792 matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.simple(name, new class_1792[]{matches}, getTask);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, class_1792[] toMine, class_1792 ... targets) {
        class_2248[] toMineBlocks = new class_2248[toMine.length];
        for (int i = 0; i < toMine.length; ++i) {
            toMineBlocks[i] = class_2248.method_9503((class_1792)toMine[i]);
        }
        return TaskCatalogue.mine(name, requirement, toMineBlocks, targets);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, class_2248[] toMine, class_1792 ... targets) {
        return TaskCatalogue.put(name, targets, count -> new MineAndCollectTask(new ItemTarget(targets, (int)count), toMine, requirement)).dontMineIfPresent();
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, class_2248 toMine, class_1792 target) {
        return TaskCatalogue.mine(name, requirement, new class_2248[]{toMine}, target);
    }

    private static CataloguedResource mine(String name, class_2248 toMine, class_1792 target) {
        return TaskCatalogue.mine(name, MiningRequirement.HAND, toMine, target);
    }

    private static CataloguedResource mine(String name, class_1792 target) {
        return TaskCatalogue.mine(name, class_2248.method_9503((class_1792)target), target);
    }

    private static CataloguedResource shear(String name, class_2248[] toShear, class_1792 ... targets) {
        return TaskCatalogue.put(name, targets, count -> new ShearAndCollectBlockTask(new ItemTarget[]{new ItemTarget(targets, (int)count)}, toShear)).dontMineIfPresent();
    }

    private static CataloguedResource shear(String name, class_2248 toShear, class_1792 ... targets) {
        return TaskCatalogue.shear(name, new class_2248[]{toShear}, targets);
    }

    private static CataloguedResource shapedRecipe2x2(String name, class_1792 match, int outputCount, String s0, String s1, String s2, String s3) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3)}, outputCount);
        return TaskCatalogue.put(name, new class_1792[]{match}, count -> new CraftInInventoryTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe3x3(String name, class_1792 match, int outputCount, String s0, String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3), TaskCatalogue.t(s4), TaskCatalogue.t(s5), TaskCatalogue.t(s6), TaskCatalogue.t(s7), TaskCatalogue.t(s8)}, outputCount);
        return TaskCatalogue.put(name, new class_1792[]{match}, count -> new CraftInTableTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, class_1792 match, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, 1, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, class_1792 match, int outputCount, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, outputCount, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe3x3Block(String name, class_1792 match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 1, material, material, material, material, material, material, material, material, material);
    }

    private static CataloguedResource shapedRecipeSlab(String name, class_1792 match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, null, null, null, null, null, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeStairs(String name, class_1792 match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 4, material, null, null, material, material, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeWall(String name, class_1792 match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, material, material, material, material, material, material, null, null, null);
    }

    private static CataloguedResource smelt(String name, class_1792[] matches, String materials, class_1792 ... optionalMaterials) {
        return TaskCatalogue.put(name, matches, count -> new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(matches, (int)count), new ItemTarget(materials, (int)count), optionalMaterials)));
    }

    private static CataloguedResource smelt(String name, class_1792 match, String materials, class_1792 ... optionalMaterials) {
        return TaskCatalogue.smelt(name, new class_1792[]{match}, materials, optionalMaterials);
    }

    private static CataloguedResource smith(String name, class_1792[] matches, String materials, String tool) {
        return TaskCatalogue.put(name, matches, count -> new UpgradeInSmithingTableTask(new ItemTarget(tool, (int)count), new ItemTarget(materials, (int)count), new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource smith(String name, class_1792 match, String materials, String tool) {
        return TaskCatalogue.smith(name, new class_1792[]{match}, materials, tool);
    }

    private static CataloguedResource mob(String name, class_1792[] matches, Class mobClass) {
        return TaskCatalogue.put(name, matches, count -> new KillAndLootTask(mobClass, new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource mob(String name, class_1792 match, Class mobClass) {
        return TaskCatalogue.mob(name, new class_1792[]{match}, mobClass);
    }

    private static void mobCook(String uncookedName, String cookedName, class_1792 uncooked, class_1792 cooked, Class mobClass) {
        TaskCatalogue.mob(uncookedName, uncooked, mobClass);
        TaskCatalogue.smelt(cookedName, cooked, uncookedName, new class_1792[0]);
    }

    private static void mobCook(String uncookedName, class_1792 uncooked, class_1792 cooked, Class mobClass) {
        TaskCatalogue.mobCook(uncookedName, "cooked_" + uncookedName, uncooked, cooked, mobClass);
    }

    private static CataloguedResource crop(String name, class_1792[] matches, class_2248[] cropBlocks, class_1792[] cropSeeds) {
        return TaskCatalogue.put(name, matches, count -> new CollectCropTask(new ItemTarget(matches, (int)count), cropBlocks, cropSeeds));
    }

    public static CataloguedResource crop(String name, class_1792 match, class_2248 cropBlock, class_1792 cropSeed) {
        return TaskCatalogue.crop(name, new class_1792[]{match}, new class_2248[]{cropBlock}, new class_1792[]{cropSeed});
    }

    private static void colorfulTasks(String baseName, Function<ItemHelper.ColorfulItems, class_1792> getMatch, BiFunction<ItemHelper.ColorfulItems, Integer, ResourceTask> getTask) {
        for (class_1767 dCol : class_1767.values()) {
            class_3620 mCol = dCol.method_7794();
            ItemHelper.ColorfulItems color = ItemHelper.getColorfulItems(mCol);
            String prefix = color.colorName;
            TaskCatalogue.put(prefix + "_" + prefix, new class_1792[]{getMatch.apply(color)}, count -> (ResourceTask)getTask.apply(color, (Integer)count));
        }
    }

    private static CataloguedResource[] woodTasks(Function<ItemHelper.WoodItems, String> getCatalogueName, Function<ItemHelper.WoodItems, class_1792> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        ArrayList<CataloguedResource> result = new ArrayList<CataloguedResource>();
        for (WoodType woodType : WoodType.values()) {
            ItemHelper.WoodItems woodItems = ItemHelper.getWoodItems(woodType);
            class_1792 match = getMatch.apply(woodItems);
            String cataloguedName = getCatalogueName.apply(woodItems);
            if (match == null) continue;
            boolean isNether = woodItems.isNetherWood();
            CataloguedResource t = TaskCatalogue.put(cataloguedName, new class_1792[]{match}, count -> (ResourceTask)getTask.apply(woodItems, (Integer)count));
            if (requireNetherForNetherStuff && isNether) {
                t.forceDimension(Dimension.NETHER);
            }
            result.add(t);
        }
        return (CataloguedResource[])result.toArray(CataloguedResource[]::new);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, class_1792> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        return TaskCatalogue.woodTasks((ItemHelper.WoodItems woodItem) -> woodItem.prefix + "_" + baseName, getMatch, getTask, requireNetherForNetherStuff);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, class_1792> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask) {
        return TaskCatalogue.woodTasks(baseName, getMatch, getTask, false);
    }

    private static void tools(String toolMaterialName, String material, class_1792 pickaxeItem, class_1792 shovelItem, class_1792 swordItem, class_1792 axeItem, class_1792 hoeItem) {
        String s = "stick";
        String o = null;
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_pickaxe", pickaxeItem, 1, material, material, material, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_shovel", shovelItem, 1, o, material, o, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_sword", swordItem, 1, o, material, o, o, material, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_axe", axeItem, 1, material, material, o, material, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_hoe", hoeItem, 1, material, material, o, o, s, o, o, s, o);
    }

    private static void armor(String armorMaterialName, String material, class_1792 helmetItem, class_1792 chestplateItem, class_1792 leggingsItem, class_1792 bootsItem) {
        String o = null;
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_helmet", helmetItem, 1, material, material, material, material, o, material, o, o, o);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_chestplate", chestplateItem, 1, material, o, material, material, material, material, material, material, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_leggings", leggingsItem, 1, material, material, material, material, o, material, material, o, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_boots", bootsItem, 1, o, o, o, material, o, material, material, o, material);
    }

    private static void alias(String newName, String original) {
        if (nameToResourceTask.containsKey(original) && nameToItemMatches.containsKey(original)) {
            nameToResourceTask.put(newName, nameToResourceTask.get(original));
            nameToItemMatches.put(newName, nameToItemMatches.get(original));
        } else {
            Debug.logWarning("Invalid resource: " + original + ". Will not create alias.");
        }
    }

    private static ItemTarget t(String cataloguedName) {
        return new ItemTarget(cataloguedName);
    }

    static {
        String p = "planks";
        String s = "stick";
        String o = null;
        TaskCatalogue.mine("log", MiningRequirement.HAND, ItemHelper.LOG, ItemHelper.LOG).anyDimension();
        TaskCatalogue.woodTasks("log", (ItemHelper.WoodItems wood) -> wood.log, (ItemHelper.WoodItems wood, Integer count) -> new MineAndCollectTask(wood.log, (int)count, new class_2248[]{class_2248.method_9503((class_1792)wood.log)}, MiningRequirement.HAND), true);
        TaskCatalogue.mine("dirt", MiningRequirement.HAND, new class_2248[]{class_2246.field_10566, class_2246.field_10219, class_2246.field_10194}, class_1802.field_8831);
        TaskCatalogue.simple("cobblestone", class_1802.field_20412, CollectBlockByOneTask.CollectCobblestoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("cobbled_deepslate", class_1802.field_29025, CollectBlockByOneTask.CollectCobbledDeepslateTask::new).dontMineIfPresent();
        TaskCatalogue.mine("andesite", MiningRequirement.WOOD, class_2246.field_10115, class_1802.field_20407);
        TaskCatalogue.mine("granite", MiningRequirement.WOOD, class_2246.field_10474, class_1802.field_20394);
        TaskCatalogue.mine("diorite", MiningRequirement.WOOD, class_2246.field_10508, class_1802.field_20401);
        TaskCatalogue.mine("calcite", MiningRequirement.WOOD, class_2246.field_27114, class_1802.field_27020);
        TaskCatalogue.mine("tuff", MiningRequirement.WOOD, class_2246.field_27165, class_1802.field_27021);
        TaskCatalogue.mine("netherrack", MiningRequirement.WOOD, class_2246.field_10515, class_1802.field_8328).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("magma_block", MiningRequirement.WOOD, class_2246.field_10092, class_1802.field_8354).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("blackstone", MiningRequirement.WOOD, class_2246.field_23869, class_1802.field_23843).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("basalt", MiningRequirement.WOOD, class_2246.field_22091, class_1802.field_22000).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_sand", class_1802.field_8067).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_soil", class_1802.field_21999).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("glowstone_dust", class_2246.field_10171, class_1802.field_8601).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("coal", MiningRequirement.WOOD, new class_2248[]{class_2246.field_10418, class_2246.field_29219}, class_1802.field_8713);
        TaskCatalogue.mine("raw_iron", MiningRequirement.STONE, new class_2248[]{class_2246.field_10212, class_2246.field_29027}, class_1802.field_33400);
        TaskCatalogue.mine("raw_gold", MiningRequirement.IRON, new class_2248[]{class_2246.field_10571, class_2246.field_29026}, class_1802.field_33402);
        TaskCatalogue.mine("raw_copper", MiningRequirement.STONE, new class_2248[]{class_2246.field_27120, class_2246.field_29221}, class_1802.field_33401);
        TaskCatalogue.mine("diamond", MiningRequirement.IRON, new class_2248[]{class_2246.field_10442, class_2246.field_29029}, class_1802.field_8477);
        TaskCatalogue.mine("emerald", MiningRequirement.IRON, new class_2248[]{class_2246.field_10013, class_2246.field_29220}, class_1802.field_8687);
        TaskCatalogue.mine("redstone", MiningRequirement.IRON, new class_2248[]{class_2246.field_10080, class_2246.field_29030}, class_1802.field_8725);
        TaskCatalogue.mine("lapis_lazuli", MiningRequirement.STONE, new class_2248[]{class_2246.field_10090, class_2246.field_29028}, class_1802.field_8759);
        TaskCatalogue.alias("lapis", "lapis_lazuli");
        TaskCatalogue.mine("amethyst_shard", MiningRequirement.WOOD, class_2246.field_27161, class_1802.field_27063);
        TaskCatalogue.mine("pointed_dripstone", MiningRequirement.WOOD, class_2246.field_28048, class_1802.field_28042);
        TaskCatalogue.mine("sand", class_2246.field_10102, class_1802.field_8858);
        TaskCatalogue.mine("red_sand", class_2246.field_10534, class_1802.field_8200);
        TaskCatalogue.mine("gravel", class_2246.field_10255, class_1802.field_8110);
        TaskCatalogue.mine("clay_ball", class_2246.field_10460, class_1802.field_8696);
        TaskCatalogue.mine("ancient_debris", MiningRequirement.DIAMOND, class_2246.field_22109, class_1802.field_22019).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("gilded_blackstone", MiningRequirement.STONE, class_2246.field_23880, class_1802.field_23847).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("oak_sapling", class_2246.field_10503, class_1802.field_17535);
        TaskCatalogue.mine("spruce_sapling", class_2246.field_9988, class_1802.field_17536);
        TaskCatalogue.mine("birch_sapling", class_2246.field_10539, class_1802.field_17537);
        TaskCatalogue.mine("jungle_sapling", class_2246.field_10335, class_1802.field_17538);
        TaskCatalogue.mine("acacia_sapling", class_2246.field_10098, class_1802.field_17539);
        TaskCatalogue.mine("dark_oak_sapling", class_2246.field_10035, class_1802.field_17540);
        TaskCatalogue.mine("mangrove_propagule", class_2246.field_37544, class_1802.field_37508);
        TaskCatalogue.mine("cherry_sapling", class_2246.field_42731, class_1802.field_42688);
        TaskCatalogue.simple("sapling", ItemHelper.SAPLINGS, CollectSaplingsTask::new);
        TaskCatalogue.simple("sandstone", class_1802.field_20384, CollectSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("red_sandstone", class_1802.field_20408, CollectRedSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("coarse_dirt", class_1802.field_8460, CollectCoarseDirtTask::new).dontMineIfPresent();
        TaskCatalogue.simple("amethyst_block", class_1802.field_27064, CollectAmethystBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("dripstone_block", class_1802.field_28043, CollectDripstoneBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("flint", class_1802.field_8145, CollectFlintTask::new);
        TaskCatalogue.simple("obsidian", class_1802.field_8281, CollectObsidianTask::new).dontMineIfPresent();
        TaskCatalogue.simple("wool", ItemHelper.WOOL, CollectWoolTask::new);
        TaskCatalogue.simple("egg", class_1802.field_8803, CollectEggsTask::new);
        TaskCatalogue.mob("bone", class_1802.field_8606, class_1613.class);
        TaskCatalogue.mob("gunpowder", class_1802.field_8054, class_1548.class);
        TaskCatalogue.simple("ender_pearl", class_1802.field_8634, KillEndermanTask::new);
        TaskCatalogue.mob("spider_eye", class_1802.field_8680, class_1628.class);
        TaskCatalogue.mob("leather", class_1802.field_8745, class_1430.class);
        TaskCatalogue.mob("feather", class_1802.field_8153, class_1428.class);
        TaskCatalogue.mob("rotten_flesh", class_1802.field_8511, class_1642.class);
        TaskCatalogue.mob("rabbit_foot", class_1802.field_8073, class_1463.class);
        TaskCatalogue.mob("rabbit_hide", class_1802.field_8245, class_1463.class);
        TaskCatalogue.mob("slime_ball", class_1802.field_8777, class_1621.class);
        TaskCatalogue.mob("wither_skeleton_skull", class_1802.field_8791, class_1639.class).forceDimension(Dimension.NETHER);
        TaskCatalogue.mob("ink_sac", class_1802.field_8794, class_1477.class);
        TaskCatalogue.mob("glow_ink_sac", class_1802.field_28410, class_5776.class);
        TaskCatalogue.mob("string", class_1802.field_8276, class_1628.class);
        TaskCatalogue.mine("sugar_cane", class_1802.field_17531);
        TaskCatalogue.mine("brown_mushroom", MiningRequirement.HAND, new class_2248[]{class_2246.field_10251, class_2246.field_10580}, class_1802.field_17516);
        TaskCatalogue.mine("red_mushroom", MiningRequirement.HAND, new class_2248[]{class_2246.field_10559, class_2246.field_10240}, class_1802.field_17517);
        TaskCatalogue.mine("mushroom", MiningRequirement.HAND, new class_2248[]{class_2246.field_10251, class_2246.field_10580, class_2246.field_10559, class_2246.field_10240}, class_1802.field_17516, class_1802.field_17517);
        TaskCatalogue.mine("melon_slice", MiningRequirement.HAND, class_2246.field_46283, class_1802.field_8497);
        TaskCatalogue.mine("pumpkin", MiningRequirement.HAND, class_2246.field_46282, class_1802.field_17518);
        TaskCatalogue.mine("bell", MiningRequirement.WOOD, class_2246.field_16332, class_1802.field_16315);
        TaskCatalogue.mine("nether_wart", MiningRequirement.HAND, class_2246.field_9974, class_1802.field_8790).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_fungus", MiningRequirement.HAND, class_2246.field_22121, class_1802.field_21987).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_fungus", MiningRequirement.HAND, class_2246.field_22114, class_1802.field_21988).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_roots", MiningRequirement.HAND, class_2246.field_22125, class_1802.field_21989).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_roots", MiningRequirement.HAND, class_2246.field_22116, class_1802.field_21990).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("weeping_vines", MiningRequirement.HAND, class_2246.field_22123, class_1802.field_21992).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("twisting_vines", MiningRequirement.HAND, class_2246.field_23078, class_1802.field_23070).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("nether_wart_block", MiningRequirement.HAND, class_2246.field_10541, class_1802.field_8182).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_wart_block", MiningRequirement.HAND, class_2246.field_22115, class_1802.field_22008).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("shroomlight", MiningRequirement.HAND, class_2246.field_22122, class_1802.field_22017).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("blaze_rod", class_1802.field_8894, CollectBlazeRodsTask::new).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("quartz", MiningRequirement.WOOD, class_2246.field_10213, class_1802.field_8155).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("cocoa_beans", class_1802.field_8116, CollectCocoaBeansTask::new);
        TaskCatalogue.shear("cobweb", class_2246.field_10343, class_1802.field_8786).dontMineIfPresent();
        TaskCatalogue.colorfulTasks("wool", color -> color.wool, (color, count) -> new CollectWoolTask(color.color, (int)count));
        TaskCatalogue.shear("leaves", ItemHelper.itemsToBlocks(ItemHelper.LEAVES), ItemHelper.LEAVES).dontMineIfPresent();
        for (CataloguedResource resource : TaskCatalogue.woodTasks("leaves", woodItems -> woodItems.leaves, (woodItems, count) -> woodItems.isNetherWood() ? new MineAndCollectTask(woodItems.leaves, (int)count, new class_2248[]{class_2248.method_9503((class_1792)woodItems.leaves)}, MiningRequirement.HAND).forceDimension(Dimension.NETHER) : new ShearAndCollectBlockTask(woodItems.leaves, (int)count, class_2248.method_9503((class_1792)woodItems.leaves)))) {
            resource.dontMineIfPresent();
        }
        TaskCatalogue.mine("bamboo", class_2246.field_10211, class_1802.field_8648);
        TaskCatalogue.shear("vine", class_2246.field_10597, class_1802.field_17523).dontMineIfPresent();
        TaskCatalogue.shear("grass", class_2246.field_10219, class_1802.field_8270).dontMineIfPresent();
        TaskCatalogue.shear("lily_pad", class_2246.field_10588, class_1802.field_17524).dontMineIfPresent();
        TaskCatalogue.shear("tall_grass", class_2246.field_10214, class_1802.field_8256).dontMineIfPresent();
        TaskCatalogue.shear("fern", class_2246.field_10112, class_1802.field_8471).dontMineIfPresent();
        TaskCatalogue.shear("large_fern", class_2246.field_10313, class_1802.field_8561).dontMineIfPresent();
        TaskCatalogue.shear("dead_bush", class_2246.field_10428, class_1802.field_8689).dontMineIfPresent();
        TaskCatalogue.shear("glow_lichen", class_2246.field_28411, class_1802.field_28409).dontMineIfPresent();
        TaskCatalogue.simple("flower", ItemHelper.FLOWER, CollectFlowerTask::new);
        TaskCatalogue.mine("allium", class_1802.field_17500);
        TaskCatalogue.mine("azure_bluet", class_1802.field_17501);
        TaskCatalogue.mine("blue_orchid", class_1802.field_17499);
        TaskCatalogue.mine("cactus", class_1802.field_17520);
        TaskCatalogue.mine("cornflower", class_1802.field_17513);
        TaskCatalogue.mine("dandelion", class_1802.field_8491);
        TaskCatalogue.mine("lilac", class_1802.field_17526);
        TaskCatalogue.mine("lily_of_the_valley", class_1802.field_17514);
        TaskCatalogue.mine("orange_tulip", class_1802.field_17509);
        TaskCatalogue.mine("oxeye_daisy", class_1802.field_17512);
        TaskCatalogue.mine("pink_tulip", class_1802.field_17511);
        TaskCatalogue.mine("poppy", class_1802.field_8880);
        TaskCatalogue.mine("peony", class_1802.field_17529);
        TaskCatalogue.mine("red_tulip", class_1802.field_17502);
        TaskCatalogue.mine("rose_bush", class_1802.field_17527);
        TaskCatalogue.mine("sunflower", class_1802.field_17525);
        TaskCatalogue.mine("white_tulip", class_1802.field_17510);
        TaskCatalogue.simple("wheat", class_1802.field_8861, CollectWheatTask::new);
        TaskCatalogue.crop("carrot", class_1802.field_8179, class_2246.field_10609, class_1802.field_8179);
        TaskCatalogue.crop("potato", class_1802.field_8567, class_2246.field_10247, class_1802.field_8567);
        TaskCatalogue.crop("poisonous_potato", class_1802.field_8635, class_2246.field_10247, class_1802.field_8567);
        TaskCatalogue.crop("beetroot", class_1802.field_8186, class_2246.field_10341, class_1802.field_8309);
        TaskCatalogue.simple("wheat_seeds", class_1802.field_8317, CollectWheatSeedsTask::new);
        TaskCatalogue.crop("beetroot_seeds", class_1802.field_8309, class_2246.field_10341, class_1802.field_8309);
        TaskCatalogue.simple("netherite_upgrade_smithing_template", class_1802.field_41946, GetSmithingTemplateTask::new);
        TaskCatalogue.alias("netherite_upgrade", "netherite_upgrade_smithing_template");
        TaskCatalogue.simple("planks", ItemHelper.PLANKS, CollectPlanksTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("planks", (ItemHelper.WoodItems wood) -> wood.planks, (ItemHelper.WoodItems wood, Integer count) -> {
            CollectPlanksTask result = new CollectPlanksTask(wood.planks, (int)count);
            if (wood.isNetherWood()) {
                result.logsInNether();
            }
            return result;
        }, true)) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stripped_logs", ItemHelper.STRIPPED_LOGS, CollectStrippedLogTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("stripped_logs", wood -> wood.strippedLog, (wood, count) -> new CollectStrippedLogTask(wood.strippedLog, (int)count))) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stick", class_1802.field_8600, CollectSticksTask::new);
        TaskCatalogue.smelt("stone", class_1802.field_20391, "cobblestone", new class_1792[0]).dontMineIfPresent();
        TaskCatalogue.smelt("deepslate", class_1802.field_28866, "cobbled_deepslate", new class_1792[0]).dontMineIfPresent();
        TaskCatalogue.smelt("smooth_stone", class_1802.field_20389, "stone", new class_1792[0]);
        TaskCatalogue.smelt("smooth_quartz", class_1802.field_20386, "quartz_block", new class_1792[0]);
        TaskCatalogue.smelt("smooth_basalt", class_1802.field_29024, "basalt", new class_1792[0]);
        TaskCatalogue.smelt("glass", class_1802.field_8280, "sand", new class_1792[0]).dontMineIfPresent();
        TaskCatalogue.simple("iron_ingot", class_1802.field_8620, CollectIronIngotTask::new).forceDimension(Dimension.OVERWORLD);
        TaskCatalogue.smelt("copper_ingot", class_1802.field_27022, "raw_copper", class_1802.field_27018);
        TaskCatalogue.smelt("charcoal", class_1802.field_8665, "log", new class_1792[0]);
        TaskCatalogue.smelt("brick", class_1802.field_8621, "clay_ball", new class_1792[0]);
        TaskCatalogue.smelt("nether_brick", class_1802.field_8729, "netherrack", new class_1792[0]);
        TaskCatalogue.smelt("green_dye", class_1802.field_8408, "cactus", new class_1792[0]);
        TaskCatalogue.simple("gold_ingot", class_1802.field_8695, CollectGoldIngotTask::new).anyDimension();
        TaskCatalogue.shapedRecipe3x3Block("iron_block", class_1802.field_8773, "iron_ingot");
        TaskCatalogue.shapedRecipe3x3Block("gold_block", class_1802.field_8494, "gold_ingot");
        TaskCatalogue.shapedRecipe3x3Block("copper_block", class_1802.field_27071, "copper_ingot");
        TaskCatalogue.shapedRecipe3x3Block("raw_iron_block", class_1802.field_33505, "raw_iron");
        TaskCatalogue.shapedRecipe3x3Block("raw_gold_block", class_1802.field_33507, "raw_gold");
        TaskCatalogue.shapedRecipe3x3Block("raw_copper_block", class_1802.field_33506, "raw_copper");
        TaskCatalogue.shapedRecipe3x3Block("diamond_block", class_1802.field_8603, "diamond");
        TaskCatalogue.shapedRecipe3x3Block("redstone_block", class_1802.field_8793, "redstone");
        TaskCatalogue.shapedRecipe3x3Block("coal_block", class_1802.field_8797, "coal");
        TaskCatalogue.shapedRecipe3x3Block("emerald_block", class_1802.field_8733, "emerald");
        TaskCatalogue.shapedRecipe3x3Block("lapis_block", class_1802.field_8055, "lapis_lazuli");
        TaskCatalogue.shapedRecipe3x3Block("slime_block", class_1802.field_8828, "slime_ball");
        TaskCatalogue.shapedRecipe3x3Block("melon", class_1802.field_17522, "melon_slice").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("glowstone", class_1802.field_8801, "glowstone_dust").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("clay", class_1802.field_19060, "clay_ball").dontMineIfPresent();
        TaskCatalogue.smelt("netherite_scrap", class_1802.field_22021, "ancient_debris", new class_1792[0]);
        TaskCatalogue.shapedRecipe3x3("netherite_ingot", class_1802.field_22020, 1, "netherite_scrap", "netherite_scrap", "netherite_scrap", "netherite_scrap", "gold_ingot", "gold_ingot", "gold_ingot", "gold_ingot", o);
        TaskCatalogue.simple("gold_nugget", class_1802.field_8397, CollectGoldNuggetsTask::new);
        String str8 = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("glistering_melon_slice", class_1802.field_8597, 1, str8, str8, str8, str8, "melon_slice", str8, str8, str8, str8);
        TaskCatalogue.shapedRecipe2x2("sugar", class_1802.field_8479, 1, "sugar_cane", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bone_meal", class_1802.field_8324, 3, "bone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("melon_seeds", class_1802.field_46250, 1, "melon_slice", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bamboo_planks", class_1802.field_40213, 2, "bamboo_block", o, o, o);
        TaskCatalogue.shapedRecipe3x3Block("bamboo_block", class_1802.field_41066, "bamboo");
        TaskCatalogue.simple("hay_block", class_1802.field_17528, CollectHayBlockTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("polished_andesite", class_1802.field_20411, 4, "andesite");
        TaskCatalogue.shapedRecipe2x2Block("polished_diorite", class_1802.field_20403, 4, "diorite");
        TaskCatalogue.shapedRecipe2x2Block("polished_granite", class_1802.field_20397, 4, "granite");
        TaskCatalogue.shapedRecipe2x2Block("quartz_block", class_1802.field_20402, "quartz");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone", class_1802.field_23848, 4, "blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone_bricks", class_1802.field_23837, 4, "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_basalt", class_1802.field_23069, 4, "basalt");
        TaskCatalogue.shapedRecipe2x2Block("polished_deepslate", class_1802.field_28871, 4, "cobbled_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_bricks", class_1802.field_28859, 4, "polished_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_tiles", class_1802.field_28860, 4, "deepslate_bricks");
        TaskCatalogue.shapedRecipe2x2Block("cut_copper", class_1802.field_27075, 4, "copper_block");
        TaskCatalogue.shapedRecipe2x2Block("cut_sandstone", class_1802.field_20385, 4, "sandstone");
        TaskCatalogue.shapedRecipe2x2Block("cut_red_sandstone", class_1802.field_20409, 4, "red_sandstone");
        TaskCatalogue.shapedRecipe2x2Block("quartz_bricks", class_1802.field_23830, 4, "quartz_block");
        TaskCatalogue.shapedRecipe2x2("quartz_pillar", class_1802.field_8746, 4, "quartz_block", o, "quartz_block", o);
        TaskCatalogue.shapedRecipe2x2Block("stone_bricks", class_1802.field_20395, 4, "stone");
        TaskCatalogue.shapedRecipe2x2("mossy_stone_bricks", class_1802.field_20396, 1, "stone_bricks", "vine", o, o);
        TaskCatalogue.shapedRecipe2x2("mossy_cobblestone", class_1802.field_20392, 1, "cobblestone", "vine", o, o);
        TaskCatalogue.simple("nether_bricks", class_1802.field_20398, CollectNetherBricksTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("red_nether_bricks", class_1802.field_20410, 4, "nether_wart");
        TaskCatalogue.smelt("cracked_stone_bricks", class_1802.field_8343, "stone_bricks", new class_1792[0]);
        TaskCatalogue.smelt("cracked_nether_bricks", class_1802.field_23828, "nether_bricks", new class_1792[0]);
        TaskCatalogue.smelt("cracked_polished_blackstone_bricks", class_1802.field_23841, "polished_blackstone_bricks", new class_1792[0]);
        TaskCatalogue.smelt("cracked_deepslate_bricks", class_1802.field_29214, "deepslate_bricks", new class_1792[0]);
        TaskCatalogue.smelt("cracked_deepslate_tiles", class_1802.field_29215, "deepslate_tiles", new class_1792[0]);
        TaskCatalogue.smelt("smooth_sandstone", class_1802.field_20388, "sandstone", new class_1792[0]);
        TaskCatalogue.smelt("smooth_red_sandstone", class_1802.field_20387, "red_sandstone", new class_1792[0]);
        String B = "nether_bricks";
        String str13 = "nether_brick";
        TaskCatalogue.shapedRecipe3x3("nether_brick_fence", class_1802.field_8080, 6, o, o, o, B, str13, B, B, str13, B);
        TaskCatalogue.shapedRecipe3x3("brush", class_1802.field_42716, 1, o, "feather", o, o, "copper_ingot", o, o, s, o);
        TaskCatalogue.shapedRecipe3x3("paper", class_1802.field_8407, 3, "sugar_cane", "sugar_cane", "sugar_cane", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("book", class_1802.field_8529, 1, "paper", "paper", "paper", "leather");
        TaskCatalogue.shapedRecipe2x2("writable_book", class_1802.field_8674, 1, "book", "ink_sac", o, "feather");
        TaskCatalogue.alias("book_and_quill", "writable_book");
        TaskCatalogue.shapedRecipe3x3("bowl", class_1802.field_8428, 4, p, o, p, o, p, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("blaze_powder", class_1802.field_8183, 2, "blaze_rod", o, o, o);
        TaskCatalogue.shapedRecipe2x2("ender_eye", class_1802.field_8449, 1, "blaze_powder", "ender_pearl", o, o);
        TaskCatalogue.alias("eye_of_ender", "ender_eye");
        TaskCatalogue.shapedRecipe2x2("fermented_spider_eye", class_1802.field_8711, 1, "brown_mushroom", "sugar", o, "spider_eye");
        TaskCatalogue.shapedRecipe3x3("fire_charge", class_1802.field_8814, 3, o, "blaze_powder", o, o, "coal", o, o, "gunpowder", o);
        TaskCatalogue.shapedRecipe2x2("flower_banner_pattern", class_1802.field_8498, 1, "paper", "oxeye_daisy", o, o);
        TaskCatalogue.simple("magma_cream", class_1802.field_8135, CollectMagmaCreamTask::new);
        TaskCatalogue.shapedRecipeSlab("cobblestone_slab", class_1802.field_8194, "cobblestone");
        TaskCatalogue.shapedRecipeStairs("cobblestone_stairs", class_1802.field_8310, "cobblestone");
        TaskCatalogue.shapedRecipeWall("cobblestone_wall", class_1802.field_8392, "cobblestone");
        TaskCatalogue.shapedRecipeSlab("stone_slab", class_1802.field_8595, "stone");
        TaskCatalogue.shapedRecipeStairs("stone_stairs", class_1802.field_8053, "stone");
        TaskCatalogue.shapedRecipeSlab("smooth_stone_slab", class_1802.field_8291, "smooth_stone");
        TaskCatalogue.shapedRecipeSlab("stone_brick_slab", class_1802.field_8524, "stone_bricks");
        TaskCatalogue.shapedRecipeStairs("stone_brick_stairs", class_1802.field_8481, "stone_bricks");
        TaskCatalogue.shapedRecipeWall("stone_brick_wall", class_1802.field_8337, "stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_stone_brick_slab", class_1802.field_8576, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeStairs("mossy_stone_brick_stairs", class_1802.field_8890, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeWall("mossy_stone_brick_wall", class_1802.field_8811, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_cobblestone_slab", class_1802.field_8369, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeStairs("mossy_cobblestone_stairs", class_1802.field_8275, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeWall("mossy_cobblestone_wall", class_1802.field_8708, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeSlab("andesite_slab", class_1802.field_8742, "andesite");
        TaskCatalogue.shapedRecipeStairs("andesite_stairs", class_1802.field_8526, "andesite");
        TaskCatalogue.shapedRecipeWall("andesite_wall", class_1802.field_8206, "andesite");
        TaskCatalogue.shapedRecipeSlab("granite_slab", class_1802.field_8312, "granite");
        TaskCatalogue.shapedRecipeStairs("granite_stairs", class_1802.field_8608, "granite");
        TaskCatalogue.shapedRecipeWall("granite_wall", class_1802.field_8488, "granite");
        TaskCatalogue.shapedRecipeSlab("diorite_slab", class_1802.field_8659, "diorite");
        TaskCatalogue.shapedRecipeStairs("diorite_stairs", class_1802.field_8860, "diorite");
        TaskCatalogue.shapedRecipeWall("diorite_wall", class_1802.field_8559, "diorite");
        TaskCatalogue.shapedRecipeSlab("polished_andesite_slab", class_1802.field_8395, "polished_andesite");
        TaskCatalogue.shapedRecipeStairs("polished_andesite_stairs", class_1802.field_8316, "polished_andesite");
        TaskCatalogue.shapedRecipeSlab("polished_granite_slab", class_1802.field_8228, "polished_granite");
        TaskCatalogue.shapedRecipeStairs("polished_granite_stairs", class_1802.field_8319, "polished_granite");
        TaskCatalogue.shapedRecipeSlab("polished_diorite_slab", class_1802.field_8569, "polished_diorite");
        TaskCatalogue.shapedRecipeStairs("polished_diorite_stairs", class_1802.field_8650, "polished_diorite");
        TaskCatalogue.shapedRecipeSlab("sandstone_slab", class_1802.field_18888, "sandstone");
        TaskCatalogue.shapedRecipeStairs("sandstone_stairs", class_1802.field_8443, "sandstone");
        TaskCatalogue.shapedRecipeWall("sandstone_wall", class_1802.field_8223, "sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_sandstone_slab", class_1802.field_18889, "cut_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_sandstone_slab", class_1802.field_8872, "smooth_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_sandstone_stairs", class_1802.field_8166, "smooth_sandstone");
        TaskCatalogue.shapedRecipeSlab("red_sandstone_slab", class_1802.field_18886, "red_sandstone");
        TaskCatalogue.shapedRecipeStairs("red_sandstone_stairs", class_1802.field_8456, "red_sandstone");
        TaskCatalogue.shapedRecipeWall("red_sandstone_wall", class_1802.field_8359, "red_sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_red_sandstone_slab", class_1802.field_18887, "cut_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_red_sandstone_slab", class_1802.field_8266, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_red_sandstone_stairs", class_1802.field_8641, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("nether_brick_slab", class_1802.field_8505, "nether_bricks");
        TaskCatalogue.shapedRecipeStairs("nether_brick_stairs", class_1802.field_8444, "nether_bricks");
        TaskCatalogue.shapedRecipeWall("nether_brick_wall", class_1802.field_8765, "nether_bricks");
        TaskCatalogue.shapedRecipeSlab("red_nether_brick_slab", class_1802.field_8522, "red_nether_bricks");
        TaskCatalogue.shapedRecipeStairs("red_nether_brick_stairs", class_1802.field_8302, "red_nether_bricks");
        TaskCatalogue.shapedRecipeWall("red_nether_brick_wall", class_1802.field_8419, "red_nether_bricks");
        TaskCatalogue.shapedRecipeSlab("quartz_slab", class_1802.field_8412, "quartz_block");
        TaskCatalogue.shapedRecipeStairs("quartz_stairs", class_1802.field_8499, "quartz_block");
        TaskCatalogue.shapedRecipeSlab("smooth_quartz_slab", class_1802.field_8217, "smooth_quartz");
        TaskCatalogue.shapedRecipeStairs("smooth_quartz_stairs", class_1802.field_8430, "smooth_quartz");
        TaskCatalogue.shapedRecipeSlab("blackstone_slab", class_1802.field_23844, "blackstone");
        TaskCatalogue.shapedRecipeStairs("blackstone_stairs", class_1802.field_23845, "blackstone");
        TaskCatalogue.shapedRecipeWall("blackstone_wall", class_1802.field_23846, "blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_slab", class_1802.field_23849, "polished_blackstone");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_stairs", class_1802.field_23832, "polished_blackstone");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_wall", class_1802.field_23833, "polished_blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_brick_slab", class_1802.field_23838, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_brick_stairs", class_1802.field_23839, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_brick_wall", class_1802.field_23840, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeSlab("cut_copper_slab", class_1802.field_27035, "cut_copper");
        TaskCatalogue.shapedRecipeStairs("cut_copper_stairs", class_1802.field_27031, "cut_copper");
        TaskCatalogue.shapedRecipeSlab("cobbled_deepslate_slab", class_1802.field_28873, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeStairs("cobbled_deepslate_stairs", class_1802.field_28867, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeWall("cobbled_deepslate_wall", class_1802.field_28862, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeSlab("polished_deepslate_slab", class_1802.field_28872, "polished_deepslate");
        TaskCatalogue.shapedRecipeStairs("polished_deepslate_stairs", class_1802.field_28868, "polished_deepslate");
        TaskCatalogue.shapedRecipeWall("polished_deepslate_wall", class_1802.field_28863, "polished_deepslate");
        TaskCatalogue.shapedRecipeSlab("deepslate_brick_slab", class_1802.field_28875, "deepslate_bricks");
        TaskCatalogue.shapedRecipeStairs("deepslate_brick_stairs", class_1802.field_28870, "deepslate_bricks");
        TaskCatalogue.shapedRecipeWall("deepslate_brick_wall", class_1802.field_28865, "deepslate_bricks");
        TaskCatalogue.shapedRecipeSlab("deepslate_tile_slab", class_1802.field_28874, "deepslate_tiles");
        TaskCatalogue.shapedRecipeStairs("deepslate_tile_stairs", class_1802.field_28869, "deepslate_tiles");
        TaskCatalogue.shapedRecipeWall("deepslate_tile_wall", class_1802.field_28864, "deepslate_tiles");
        TaskCatalogue.shapedRecipe2x2("chiseled_sandstone", class_1802.field_8552, 1, "sandstone_slab", o, "sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_red_sandstone", class_1802.field_8822, 1, "red_sandstone_slab", o, "red_sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_stone_bricks", class_1802.field_8525, 1, "stone_brick_slab", o, "stone_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_nether_bricks", class_1802.field_23829, 1, "nether_brick_slab", o, "nether_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_quartz_block", class_1802.field_8084, 1, "quartz_slab", o, "quartz_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_deepslate", class_1802.field_28861, 1, "cobbled_deepslate_slab", o, "cobbled_deepslate_slab", o);
        TaskCatalogue.tools("wooden", "planks", class_1802.field_8647, class_1802.field_8876, class_1802.field_8091, class_1802.field_8406, class_1802.field_8167);
        TaskCatalogue.tools("stone", "cobblestone", class_1802.field_8387, class_1802.field_8776, class_1802.field_8528, class_1802.field_8062, class_1802.field_8431);
        TaskCatalogue.tools("iron", "iron_ingot", class_1802.field_8403, class_1802.field_8699, class_1802.field_8371, class_1802.field_8475, class_1802.field_8609);
        TaskCatalogue.tools("golden", "gold_ingot", class_1802.field_8335, class_1802.field_8322, class_1802.field_8845, class_1802.field_8825, class_1802.field_8303);
        TaskCatalogue.tools("diamond", "diamond", class_1802.field_8377, class_1802.field_8250, class_1802.field_8802, class_1802.field_8556, class_1802.field_8527);
        TaskCatalogue.armor("leather", "leather", class_1802.field_8267, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370);
        TaskCatalogue.armor("iron", "iron_ingot", class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660);
        TaskCatalogue.armor("golden", "gold_ingot", class_1802.field_8862, class_1802.field_8678, class_1802.field_8416, class_1802.field_8753);
        TaskCatalogue.armor("diamond", "diamond", class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285);
        TaskCatalogue.smith("netherite_helmet", class_1802.field_22027, "netherite_ingot", "diamond_helmet");
        TaskCatalogue.smith("netherite_chestplate", class_1802.field_22028, "netherite_ingot", "diamond_chestplate");
        TaskCatalogue.smith("netherite_leggings", class_1802.field_22029, "netherite_ingot", "diamond_leggings");
        TaskCatalogue.smith("netherite_boots", class_1802.field_22030, "netherite_ingot", "diamond_boots");
        TaskCatalogue.smith("netherite_pickaxe", class_1802.field_22024, "netherite_ingot", "diamond_pickaxe");
        TaskCatalogue.smith("netherite_axe", class_1802.field_22025, "netherite_ingot", "diamond_axe");
        TaskCatalogue.smith("netherite_shovel", class_1802.field_22023, "netherite_ingot", "diamond_shovel");
        TaskCatalogue.smith("netherite_sword", class_1802.field_22022, "netherite_ingot", "diamond_sword");
        TaskCatalogue.smith("netherite_hoe", class_1802.field_22026, "netherite_ingot", "diamond_hoe");
        TaskCatalogue.shapedRecipe3x3("bow", class_1802.field_8102, 1, "string", s, o, "string", o, s, "string", s, o);
        TaskCatalogue.shapedRecipe3x3("arrow", class_1802.field_8107, 4, "flint", o, o, s, o, o, "feather", o, o);
        String str7 = "iron_ingot";
        TaskCatalogue.shapedRecipe3x3("bucket", class_1802.field_8550, 1, str7, o, str7, o, str7, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("flint_and_steel", class_1802.field_8884, 1, str7, o, o, "flint");
        TaskCatalogue.shapedRecipe2x2("shears", class_1802.field_8868, 1, str7, o, o, str7);
        TaskCatalogue.shapedRecipe2x2("iron_nugget", class_1802.field_8675, 9, str7, o, o, o);
        TaskCatalogue.shapedRecipe3x3("compass", class_1802.field_8251, 1, o, str7, o, str7, "redstone", str7, o, str7, o);
        TaskCatalogue.shapedRecipe3x3("shield", class_1802.field_8255, 1, p, str7, p, p, p, p, o, p, o);
        String str12 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("clock", class_1802.field_8557, 1, o, str12, o, str12, "redstone", str12, o, str12, o);
        TaskCatalogue.simple("water_bucket", class_1802.field_8705, CollectBucketLiquidTask.CollectWaterBucketTask::new);
        TaskCatalogue.simple("lava_bucket", class_1802.field_8187, CollectBucketLiquidTask.CollectLavaBucketTask::new);
        String a = "paper";
        TaskCatalogue.shapedRecipe3x3("map", class_1802.field_8895, 1, a, a, a, a, "compass", a, a, a, a);
        TaskCatalogue.shapedRecipe3x3("fishing_rod", class_1802.field_8378, 1, o, o, s, o, s, "string", s, o, "string");
        TaskCatalogue.shapedRecipe2x2("carrot_on_a_stick", class_1802.field_8184, 1, "fishing_rod", "carrot", o, o);
        TaskCatalogue.shapedRecipe2x2("warped_fungus_on_a_stick", class_1802.field_23254, 1, "fishing_rod", "warped_fungus", o, o);
        TaskCatalogue.shapedRecipe3x3("spyglass", class_1802.field_27070, 1, o, "amethyst_shard", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("glass_bottle", class_1802.field_8469, 3, "glass", o, "glass", o, "glass", o, o, o, o);
        String str6 = "leather";
        TaskCatalogue.shapedRecipe3x3("leather_horse_armor", class_1802.field_18138, 1, str6, o, str6, str6, str6, str6, str6, o, str6);
        TaskCatalogue.alias("wooden_pick", "wooden_pickaxe");
        TaskCatalogue.alias("stone_pick", "stone_pickaxe");
        TaskCatalogue.alias("iron_pick", "iron_pickaxe");
        TaskCatalogue.alias("gold_pick", "golden_pickaxe");
        TaskCatalogue.alias("diamond_pick", "diamond_pickaxe");
        TaskCatalogue.alias("netherite_pick", "netherite_pickaxe");
        TaskCatalogue.simple("boat", ItemHelper.WOOD_BOAT, CollectBoatTask::new);
        TaskCatalogue.woodTasks("boat", woodItems -> woodItems.boat, (woodItems, count) -> new CollectBoatTask(woodItems.boat, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.shapedRecipe3x3("lead", class_1802.field_8719, 1, "string", "string", o, "string", "slime_ball", o, o, o, "string");
        TaskCatalogue.simple("honeycomb", class_1802.field_20414, CollectHoneycombTask::new);
        String h = "honeycomb";
        TaskCatalogue.shapedRecipe2x2Block("honeycomb_block", class_1802.field_21087, h);
        TaskCatalogue.shapedRecipe2x2("candle", class_1802.field_27024, 1, "string", o, h, o);
        TaskCatalogue.shapedRecipe3x3("beehive", class_1802.field_20416, 1, p, p, p, h, h, h, p, p, p);
        TaskCatalogue.shapedRecipe2x2("crafting_table", class_1802.field_8465, 1, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("smithing_table", class_1802.field_16308, 1, "iron_ingot", "iron_ingot", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("grindstone", class_1802.field_16311, 1, s, "stone_slab", s, p, o, p, o, o, o);
        TaskCatalogue.simple("wooden_pressure_plate", ItemHelper.WOOD_PRESSURE_PLATE, CollectWoodenPressurePlateTask::new);
        TaskCatalogue.woodTasks("pressure_plate", woodItems -> woodItems.pressurePlate, (woodItems, count) -> new CollectWoodenPressurePlateTask(woodItems.pressurePlate, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_button", ItemHelper.WOOD_BUTTON, CollectWoodenButtonTask::new);
        TaskCatalogue.woodTasks("button", woodItems -> woodItems.button, (woodItems, count) -> new CraftInInventoryTask(new RecipeTarget(woodItems.button, 1, CraftingRecipe.newShapedRecipe(woodItems.prefix + "_button", new ItemTarget[]{new ItemTarget(woodItems.planks, 1), null, null, null}, 1))));
        TaskCatalogue.shapedRecipe2x2("stone_pressure_plate", class_1802.field_8667, 1, o, o, "stone", "stone");
        TaskCatalogue.shapedRecipe2x2("stone_button", class_1802.field_8781, 1, "stone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_pressure_plate", class_1802.field_23835, 1, o, o, "polished_blackstone", "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_button", class_1802.field_23834, 1, "polished_blackstone", o, o, o);
        TaskCatalogue.simple("sign", ItemHelper.WOOD_SIGN, CollectSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("sign", woodItems -> woodItems.sign, (woodItems, count) -> new CollectSignTask(woodItems.sign, woodItems.prefix + "_planks", (int)count));
        String str5 = "cobblestone";
        TaskCatalogue.shapedRecipe3x3("furnace", class_1802.field_8732, 1, str5, str5, str5, str5, o, str5, str5, str5, str5).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("dropper", class_1802.field_8878, 1, str5, str5, str5, str5, o, str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("dispenser", class_1802.field_8357, 1, str5, str5, str5, str5, "bow", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("brewing_stand", class_1802.field_8740, 1, o, o, o, o, "blaze_rod", o, str5, str5, str5);
        TaskCatalogue.shapedRecipe3x3("piston", class_1802.field_8249, 1, p, p, p, str5, "iron_ingot", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("observer", class_1802.field_8537, 1, str5, str5, str5, "redstone", "redstone", "quartz", str5, str5, str5);
        TaskCatalogue.shapedRecipe2x2("lever", class_1802.field_8865, 1, s, o, str5, o);
        TaskCatalogue.simple("hanging_sign", ItemHelper.WOOD_HANGING_SIGN, CollectHangingSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("hanging_sign", woodItems -> woodItems.hangingSign, (woodItems, count) -> new CollectHangingSignTask(woodItems.hangingSign, woodItems.prefix + "_stripped_logs", (int)count));
        TaskCatalogue.shapedRecipe3x3("chest", class_1802.field_8106, 1, p, p, p, p, o, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2("torch", class_1802.field_8810, 4, "coal", o, s, o);
        TaskCatalogue.simple("bed", ItemHelper.BED, CollectBedTask::new);
        TaskCatalogue.colorfulTasks("bed", colors -> colors.bed, (colors, count) -> new CollectBedTask(colors.bed, colors.colorName + "_wool", (int)count));
        String str4 = "iron_ingot";
        String str11 = "iron_block";
        String m = "smooth_stone";
        TaskCatalogue.shapedRecipe3x3("anvil", class_1802.field_8782, 1, str11, str11, str11, o, str4, o, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("cauldron", class_1802.field_8638, 1, str4, o, str4, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("minecart", class_1802.field_8045, 1, o, o, o, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("iron_door", class_1802.field_8594, 3, str4, str4, o, str4, str4, o, str4, str4, o);
        TaskCatalogue.shapedRecipe3x3("iron_bars", class_1802.field_8076, 16, str4, str4, str4, str4, str4, str4, o, o, o);
        TaskCatalogue.shapedRecipe3x3("blast_furnace", class_1802.field_16306, 1, str4, str4, str4, str4, "furnace", str4, m, m, m);
        TaskCatalogue.shapedRecipe2x2Block("iron_trapdoor", class_1802.field_8241, str4);
        TaskCatalogue.shapedRecipe3x3("armor_stand", class_1802.field_8694, 1, s, s, s, o, s, o, s, "smooth_stone_slab", s);
        String str3 = "obsidian";
        TaskCatalogue.shapedRecipe3x3("enchanting_table", class_1802.field_8657, 1, o, "book", o, "diamond", str3, "diamond", str3, str3, str3);
        TaskCatalogue.shapedRecipe3x3("ender_chest", class_1802.field_8466, 1, str3, str3, str3, str3, "ender_eye", str3, str3, str3, str3).dontMineIfPresent();
        str3 = "brick";
        TaskCatalogue.shapedRecipe3x3("decorated_pot", class_1802.field_42699, 1, o, str3, o, str3, o, str3, o, str3, o);
        TaskCatalogue.shapedRecipe3x3("flower_pot", class_1802.field_8074, 1, str3, o, str3, o, str3, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2Block("bricks", class_1802.field_20390, str3);
        TaskCatalogue.shapedRecipeSlab("brick_slab", class_1802.field_8342, str3);
        TaskCatalogue.shapedRecipeStairs("brick_stairs", class_1802.field_8663, str3);
        TaskCatalogue.shapedRecipeStairs("brick_wall", class_1802.field_8804, "brick");
        TaskCatalogue.shapedRecipe3x3("ladder", class_1802.field_8121, 3, s, o, s, s, s, s, s, o, s);
        TaskCatalogue.shapedRecipe3x3("jukebox", class_1802.field_8565, 1, p, p, p, p, "diamond", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("note_block", class_1802.field_8643, 1, p, p, p, p, "redstone", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("redstone_lamp", class_1802.field_8230, 1, o, "redstone", o, "redstone", "glowstone", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("bookshelf", class_1802.field_8536, 1, p, p, p, "book", "book", "book", p, p, p);
        TaskCatalogue.shapedRecipe2x2("loom", class_1802.field_8772, 1, "string", "string", p, p);
        String str2 = "glass";
        TaskCatalogue.shapedRecipe3x3("glass_pane", class_1802.field_8141, 16, str2, str2, str2, str2, str2, str2, o, o, o).dontMineIfPresent();
        TaskCatalogue.simple("carved_pumpkin", class_1802.field_17519, (Integer count) -> new CarveThenCollectTask(class_1802.field_17519, (int)count, class_2246.field_10147, class_1802.field_17518, class_2246.field_46282, class_1802.field_8868));
        TaskCatalogue.shapedRecipe2x2("jack_o_lantern", class_1802.field_8693, 1, "carved_pumpkin", o, "torch", o);
        TaskCatalogue.shapedRecipe3x3("target", class_1802.field_22420, 1, o, "redstone", o, "redstone", "hay_block", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("campfire", class_1802.field_17346, 1, o, s, o, s, "coal", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_campfire", class_1802.field_23842, 1, o, s, o, s, "soul_soil", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_torch", class_1802.field_22001, 4, o, "coal", o, o, s, o, o, "soul_soil", o);
        String l = "log";
        TaskCatalogue.shapedRecipe3x3("smoker", class_1802.field_16309, 1, o, l, o, l, "furnace", l, o, l, o);
        String str1 = "iron_nugget";
        TaskCatalogue.shapedRecipe3x3("lantern", class_1802.field_16539, 1, str1, str1, str1, str1, "torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("soul_lantern", class_1802.field_22016, 1, str1, str1, str1, str1, "soul_torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("chain", class_1802.field_23983, 1, o, str1, o, o, "iron_ingot", o, o, str1, o);
        String c = "chiseled_stone_bricks";
        TaskCatalogue.shapedRecipe3x3("lodestone", class_1802.field_23256, 1, c, c, c, c, "netherite_ingot", c, c, c, c);
        TaskCatalogue.shapedRecipe3x3("lightning_rod", class_1802.field_27051, 1, o, "copper_ingot", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("tinted_glass", class_1802.field_27019, 2, o, "amethyst_shard", o, "amethyst_shard", "glass", "amethyst_shard", o, "amethyst_shard", o);
        TaskCatalogue.simple("wooden_stairs", ItemHelper.WOOD_STAIRS, CollectWoodenStairsTask::new);
        TaskCatalogue.woodTasks("stairs", woodItems -> woodItems.stairs, (woodItems, count) -> new CollectWoodenStairsTask(woodItems.stairs, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_slab", ItemHelper.WOOD_SLAB, CollectWoodenSlabTask::new);
        TaskCatalogue.woodTasks("slab", woodItems -> woodItems.slab, (woodItems, count) -> new CollectWoodenSlabTask(woodItems.slab, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_door", ItemHelper.WOOD_DOOR, CollectWoodenDoorTask::new);
        TaskCatalogue.woodTasks("door", woodItems -> woodItems.door, (woodItems, count) -> new CollectWoodenDoorTask(woodItems.door, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_trapdoor", ItemHelper.WOOD_TRAPDOOR, CollectWoodenTrapDoorTask::new);
        TaskCatalogue.woodTasks("trapdoor", woodItems -> woodItems.trapdoor, (woodItems, count) -> new CollectWoodenTrapDoorTask(woodItems.trapdoor, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence", ItemHelper.WOOD_FENCE, CollectFenceTask::new);
        TaskCatalogue.woodTasks("fence", woodItems -> woodItems.fence, (woodItems, count) -> new CollectFenceTask(woodItems.fence, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence_gate", ItemHelper.WOOD_FENCE_GATE, CollectFenceGateTask::new);
        TaskCatalogue.woodTasks("fence_gate", woodItems -> woodItems.fenceGate, (woodItems, count) -> new CollectFenceGateTask(woodItems.fenceGate, woodItems.prefix + "_planks", (int)count));
        String r = "wooden_slab";
        TaskCatalogue.shapedRecipe3x3("chiseled_bookshelf", class_1802.field_40215, 1, p, p, p, r, r, r, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("barrel", class_1802.field_16307, 1, p, r, p, p, o, p, p, r, p);
        TaskCatalogue.shapedRecipe3x3("cartography_table", class_1802.field_16313, 1, "paper", "paper", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("composter", class_1802.field_17530, 1, r, o, r, r, o, r, r, r, r);
        TaskCatalogue.shapedRecipe3x3("fletching_table", class_1802.field_16310, 1, "flint", "flint", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("lectern", class_1802.field_16312, 1, r, r, r, o, "bookshelf", o, o, r, o);
        TaskCatalogue.alias("door", "wooden_door");
        TaskCatalogue.alias("trapdoor", "wooden_trapdoor");
        TaskCatalogue.alias("fence", "wooden_fence");
        TaskCatalogue.alias("fence_gate", "wooden_fence_gate");
        TaskCatalogue.shapedRecipe2x2("heavy_weighted_pressure_plate", class_1802.field_8592, 1, "iron_ingot", "iron_ingot", o, o);
        TaskCatalogue.shapedRecipe2x2("light_weighted_pressure_plate", class_1802.field_8721, 1, "gold_ingot", "gold_ingot", o, o);
        TaskCatalogue.shapedRecipe3x3("daylight_detector", class_1802.field_8566, 1, "glass", "glass", "glass", "quartz", "quartz", "quartz", "wooden_slab", "wooden_slab", "wooden_slab");
        TaskCatalogue.shapedRecipe3x3("tripwire_hook", class_1802.field_8366, 2, "iron_ingot", o, o, "stick", o, o, "planks", o, o);
        TaskCatalogue.shapedRecipe2x2("trapped_chest", class_1802.field_8247, 1, "chest", "tripwire_hook", o, o);
        TaskCatalogue.shapedRecipe3x3("crossbow", class_1802.field_8399, 1, s, "iron_ingot", s, "string", "tripwire_hook", "string", o, s, o);
        String t = "gunpowder";
        String n = "sand";
        TaskCatalogue.shapedRecipe3x3("tnt", class_1802.field_8626, 1, t, n, t, n, t, n, t, n, t);
        TaskCatalogue.shapedRecipe2x2("sticky_piston", class_1802.field_8105, 1, "slime_ball", o, "piston", o);
        TaskCatalogue.shapedRecipe2x2("redstone_torch", class_1802.field_8530, 1, "redstone", o, s, o);
        TaskCatalogue.shapedRecipe3x3("repeater", class_1802.field_8619, 1, "redstone_torch", "redstone", "redstone_torch", "stone", "stone", "stone", o, o, o);
        TaskCatalogue.shapedRecipe3x3("comparator", class_1802.field_8857, 1, o, "redstone_torch", o, "redstone_torch", "quartz", "redstone_torch", "stone", "stone", "stone");
        String i = "iron_ingot";
        String str10 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("rail", class_1802.field_8129, 16, i, o, i, i, s, i, i, o, i);
        TaskCatalogue.shapedRecipe3x3("powered_rail", class_1802.field_8848, 6, str10, o, str10, str10, s, str10, str10, "redstone", str10);
        TaskCatalogue.shapedRecipe3x3("detector_rail", class_1802.field_8211, 6, i, o, i, i, "stone_pressure_plate", i, i, "redstone", i);
        TaskCatalogue.shapedRecipe3x3("activator_rail", class_1802.field_8655, 6, i, s, i, i, "redstone_torch", i, i, s, i);
        TaskCatalogue.shapedRecipe3x3("hopper", class_1802.field_8239, 1, i, o, i, i, "chest", i, o, i, o);
        TaskCatalogue.shapedRecipe3x3("painting", class_1802.field_8892, 1, s, s, s, s, "wool", s, s, s, s);
        TaskCatalogue.shapedRecipe3x3("item_frame", class_1802.field_8143, 1, s, s, s, s, "leather", s, s, s, s);
        TaskCatalogue.shapedRecipe2x2("glow_item_frame", class_1802.field_28408, 1, "item_frame", "glow_ink_sac", o, o);
        TaskCatalogue.shapedRecipe2x2("chest_minecart", class_1802.field_8388, 1, "chest", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("furnace_minecart", class_1802.field_8063, 1, "furnace", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("hopper_minecart", class_1802.field_8836, 1, "hopper", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("tnt_minecart", class_1802.field_8069, 1, "tnt", o, "minecart", o);
        TaskCatalogue.alias("minecart_with_chest", "chest_minecart");
        TaskCatalogue.alias("minecart_with_furnace", "furnace_minecart");
        TaskCatalogue.alias("minecart_with_hopper", "hopper_minecart");
        TaskCatalogue.alias("minecart_with_tnt", "tnt_minecart");
        TaskCatalogue.mobCook("porkchop", class_1802.field_8389, class_1802.field_8261, class_1452.class);
        TaskCatalogue.mobCook("beef", class_1802.field_8046, class_1802.field_8176, class_1430.class);
        TaskCatalogue.mobCook("chicken", class_1802.field_8726, class_1802.field_8544, class_1428.class);
        TaskCatalogue.mobCook("mutton", class_1802.field_8748, class_1802.field_8347, class_1472.class);
        TaskCatalogue.mobCook("rabbit", class_1802.field_8504, class_1802.field_8752, class_1463.class);
        TaskCatalogue.mobCook("salmon", class_1802.field_8209, class_1802.field_8509, class_1462.class);
        TaskCatalogue.mobCook("cod", class_1802.field_8429, class_1802.field_8373, class_1431.class);
        TaskCatalogue.simple("milk", class_1802.field_8103, CollectMilkTask::new);
        TaskCatalogue.mine("apple", class_2246.field_10503, class_1802.field_8279);
        TaskCatalogue.smelt("baked_potato", class_1802.field_8512, "potato", new class_1792[0]);
        TaskCatalogue.shapedRecipe2x2("mushroom_stew", class_1802.field_8208, 1, "red_mushroom", "brown_mushroom", "bowl", o);
        TaskCatalogue.shapedRecipe2x2("suspicious_stew", class_1802.field_8766, 1, "red_mushroom", "brown_mushroom", "bowl", "flower");
        TaskCatalogue.shapedRecipe3x3("bread", class_1802.field_8229, 1, "wheat", "wheat", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe3x3("cookie", class_1802.field_8423, 8, "wheat", "cocoa_beans", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("pumpkin_pie", class_1802.field_8741, 1, "pumpkin", "sugar", o, "egg");
        TaskCatalogue.shapedRecipe3x3("cake", class_1802.field_17534, 1, "milk", "milk", "milk", "sugar", "egg", "sugar", "wheat", "wheat", "wheat").dontMineIfPresent();
        String g = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("golden_carrot", class_1802.field_8071, 1, g, g, g, g, "carrot", g, g, g, g);
        String str9 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("golden_apple", class_1802.field_8463, 1, str9, str9, str9, str9, "apple", str9, str9, str9, str9);
        TaskCatalogue.shapedRecipe3x3("rabbit_stew", class_1802.field_8308, 1, o, "cooked_rabbit", o, "carrot", "baked_potato", "mushroom", o, "bowl", o);
        String b = "beetroot";
        TaskCatalogue.shapedRecipe3x3("beetroot_soup", class_1802.field_8515, 1, b, b, b, b, b, b, o, "bowl", o);
    }

    private static class CataloguedResource {
        private final class_1792[] targets;
        private final Function<Integer, ResourceTask> getResource;
        private boolean mineIfPresent;
        private boolean forceDimension = false;
        private Dimension targetDimension;

        public CataloguedResource(class_1792[] targets, Function<Integer, ResourceTask> getResource) {
            this.targets = targets;
            this.getResource = getResource;
        }

        public CataloguedResource mineIfPresent() {
            this.mineIfPresent = true;
            return this;
        }

        public CataloguedResource dontMineIfPresent() {
            this.mineIfPresent = false;
            return this;
        }

        public CataloguedResource forceDimension(Dimension dimension) {
            this.forceDimension = true;
            this.targetDimension = dimension;
            return this;
        }

        public CataloguedResource anyDimension() {
            this.forceDimension = false;
            return this;
        }

        public ResourceTask getResource(int count) {
            ResourceTask result = this.getResource.apply(count);
            if (this.mineIfPresent) {
                result = result.mineIfPresent(ItemHelper.itemsToBlocks(this.targets));
            }
            if (this.forceDimension) {
                result = result.forceDimension(this.targetDimension);
            }
            return result;
        }
    }
}

