/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementPillar;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3621;
import net.minecraft.class_4048;
import net.minecraft.class_4050;

public class MovementTraverse
extends Movement {
    private boolean wasTheBridgeBlockAlwaysThere = true;

    public MovementTraverse(IBaritone baritone, BetterBlockPos from, BetterBlockPos to) {
        super(baritone, from, to, MovementTraverse.buildPositionsToBreak((class_1297)baritone.getEntityContext().entity(), from, to), to.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.wasTheBridgeBlockAlwaysThere = true;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementTraverse.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static BetterBlockPos[] buildPositionsToBreak(class_1297 e, BetterBlockPos from, BetterBlockPos to) {
        int x = from.x;
        int y = from.y;
        int z = from.z;
        int destX = to.x;
        int destZ = to.z;
        int diffX = destX - x;
        int diffZ = destZ - z;
        class_4048 dimensions = e.method_18377(class_4050.field_18076);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dimensions);
        int checkedXShift = diffX * requiredSideSpace;
        int checkedZShift = diffZ * requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        int height = class_3532.method_15386((float)dimensions.comp_2186());
        int requiredForwardSpace = requiredSideSpace == 0 ? 1 : 2;
        int volume = requiredForwardSpace * (requiredSideSpace * 2 + 1) * height;
        int i = 0;
        BetterBlockPos[] ret = new BetterBlockPos[volume];
        for (int df = 0; df < requiredForwardSpace; ++df) {
            for (int ds = -requiredSideSpace; ds <= requiredSideSpace; ++ds) {
                for (int dy = 0; dy < height; ++dy) {
                    ret[i++] = new BetterBlockPos(checkedX + diffZ * ds - diffX * df, y + dy, checkedZ + diffX * ds - diffZ * df);
                }
            }
        }
        return ret;
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult result) {
        class_2680 destOn = context.get(destX, y - 1, destZ);
        class_2680 srcOn = context.get(x, y - 1, z);
        class_2248 srcOnBlock = srcOn.method_26204();
        int movX = destX - x;
        int movZ = destZ - z;
        int checkedXShift = movX * context.requiredSideSpace;
        int checkedZShift = movZ * context.requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        if (MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destOn, context.baritone.settings())) {
            double WC = 0.0;
            boolean water = false;
            class_2680 destHeadState = context.get(destX, y + context.height - 1, destZ);
            if (MovementHelper.isWater(destHeadState)) {
                WC = context.waterWalkSpeed;
                water = true;
            } else {
                for (int dy = 0; dy < context.height - 1; ++dy) {
                    if (!MovementHelper.isWater(context.get(destX, y + dy, destZ))) continue;
                    WC = context.waterWalkSpeed;
                    water = true;
                    break;
                }
            }
            if (!water) {
                WC = destOn.method_26204() == class_2246.field_10382 ? context.walkOnWaterOnePenalty : 4.63284688441047 / (double)destOn.method_26204().method_23349() / 2.0;
                WC += 4.63284688441047 / (double)srcOnBlock.method_23349() / 2.0;
            }
            double hardness = 0.0;
            class_2680 srcHeadState = context.get(x, y + context.height - 1, z);
            int hardnessModifier = !MovementHelper.isWater(srcHeadState) && srcOnBlock != class_2246.field_9983 && srcOnBlock != class_2246.field_10597 ? 1 : 5;
            for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                for (int dyx = 0; dyx < context.height; ++dyx) {
                    if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dyx, checkedZ + dxz * movX, dyx == context.height - 1) * (double)hardnessModifier) >= 1000000.0)) continue;
                    return;
                }
            }
            if (hardness == 0.0 && !water && context.canSprint) {
                WC *= 0.7692444761225944;
            }
            result.cost = WC + hardness;
            result.oxygenCost = context.oxygenCost(WC / 2.0 + hardness, srcHeadState) + context.oxygenCost(WC / 2.0, destHeadState);
        } else {
            if (srcOnBlock == class_2246.field_9983 || srcOnBlock == class_2246.field_10597) {
                return;
            }
            if (MovementHelper.isReplaceable(destX, y - 1, destZ, destOn, context.bsi)) {
                double placeCost;
                boolean throughWater = false;
                for (int dyxx = 0; dyxx < context.height; ++dyxx) {
                    if (!MovementHelper.isWater(context.get(destX, y + dyxx, destZ))) continue;
                    throughWater = true;
                    if (!MovementHelper.isWater(destOn)) break;
                    return;
                }
                if ((placeCost = context.costOfPlacingAt(destX, y - 1, destZ, destOn)) >= 1000000.0) {
                    return;
                }
                double hardness = 0.0;
                for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                    for (int dyxxx = 0; dyxxx < context.height; ++dyxxx) {
                        if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dyxxx, checkedZ + dxz * movX, dyxxx == context.height - 1)) >= 1000000.0)) continue;
                        return;
                    }
                }
                double WCx = throughWater ? context.waterWalkSpeed : 4.63284688441047;
                for (int i = 0; i < 5; ++i) {
                    int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10148();
                    int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10164();
                    int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10165();
                    if (againstX == x && againstZ == z || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                    result.cost = WCx + placeCost + hardness;
                    return;
                }
                if (!srcOn.method_45474() && !srcOn.method_26234((class_1922)context.world, class_2338.field_10980)) {
                    return;
                }
                if (srcOn.method_26227().method_15772() instanceof class_3621) {
                    return;
                }
                result.cost = (WCx *= 3.3207692307692307) + placeCost + hardness;
                result.oxygenCost = context.oxygenCost(result.cost, class_2246.field_10124.method_9564());
            }
        }
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        class_2680[] bss = new class_2680[this.positionsToBreak.length];
        for (int i = 0; i < this.positionsToBreak.length; ++i) {
            bss[i] = BlockStateInterface.get(this.ctx, this.positionsToBreak[i]);
        }
        if (state.getStatus() != MovementStatus.RUNNING) {
            if (!this.baritone.settings().walkWhileBreaking.get().booleanValue()) {
                return state;
            }
            if (state.getStatus() != MovementStatus.PREPPING) {
                return state;
            }
            for (class_2680 pb : bss) {
                if (!MovementHelper.avoidWalkingInto(pb)) continue;
                return state;
            }
            double dist = Math.max(Math.abs(this.ctx.entity().method_23317() - ((double)this.dest.method_10263() + 0.5)), Math.abs(this.ctx.entity().method_23321() - ((double)this.dest.method_10260() + 0.5)));
            if (dist < 0.83) {
                return state;
            }
            if (state.getTarget().getRotation().isEmpty()) {
                return state;
            }
            class_4048 dims = this.ctx.entity().method_18377(this.ctx.entity().method_18376());
            if (!(dims.comp_2185() > 1.0f || dims.comp_2186() < 1.0f || dims.comp_2186() > 2.0f)) {
                float yawToDest = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.calculateBlockCenter((class_1937)this.ctx.world(), this.dest), this.ctx.entityRotations()).getYaw();
                float pitchToBreak = state.getTarget().getRotation().get().getPitch();
                if (MovementHelper.isBlockNormalCube(bss[0]) || bss[0].method_26204() instanceof class_2189 && (MovementHelper.isBlockNormalCube(bss[1]) || bss[1].method_26204() instanceof class_2189)) {
                    pitchToBreak = 26.0f;
                }
                return state.setTarget(new MovementState.MovementTarget(new Rotation(yawToDest, pitchToBreak), true)).setInput(Input.MOVE_FORWARD, true).setInput(Input.SPRINT, true);
            }
            return state;
        }
        state.setInput(Input.SNEAK, false);
        class_2680 fd = BlockStateInterface.get(this.ctx, this.src.down());
        boolean ladder = fd.method_26164(class_3481.field_22414);
        for (class_2680 bs : bss) {
            if (!this.tryOpenDoors(state, bs, this.dest, this.src)) continue;
            return state;
        }
        if (this.tryOpenDoors(state, BlockStateInterface.get(this.ctx, this.src), this.src, this.dest)) {
            return state;
        }
        boolean isTheBridgeBlockThere = MovementHelper.canWalkOn(this.ctx, this.positionToPlace) || ladder;
        BetterBlockPos feet = this.ctx.feetPos();
        class_2338 standingOnPos = feet.method_10074();
        class_2680 standingOn = BlockStateInterface.get(this.ctx, standingOnPos);
        if (MovementHelper.isWater(standingOn) && this.ctx.entity().method_23318() < (double)this.src.method_10264() + Math.random() * 0.2) {
            state.setInput(Input.JUMP, true);
        } else if (feet.method_10264() != this.dest.method_10264() && !ladder) {
            this.baritone.logDebug("Wrong Y coordinate");
            if (feet.method_10264() < this.dest.method_10264()) {
                MovementHelper.moveTowards(this.ctx, state, this.dest);
                return state.setInput(Input.MOVE_FORWARD, false).setInput(Input.JUMP, true);
            }
            return state;
        }
        if (isTheBridgeBlockThere) {
            if (feet.equals((Object)this.dest)) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (this.baritone.settings().overshootTraverse.get().booleanValue() && (feet.equals(this.dest.method_10081((class_2382)this.getDirection())) || feet.equals(this.dest.method_10081((class_2382)this.getDirection()).method_10081((class_2382)this.getDirection())))) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            class_2680 lowBs = BlockStateInterface.get(this.ctx, this.src);
            class_2248 low = lowBs.method_26204();
            class_2248 high = BlockStateInterface.get(this.ctx, this.src.up()).method_26204();
            if (!(!(this.ctx.entity().method_23318() > (double)this.src.y + 0.1) || this.ctx.entity().method_24828() || low != class_2246.field_10597 && low != class_2246.field_9983 && high != class_2246.field_10597 && high != class_2246.field_9983 || MovementHelper.isLiquid(lowBs))) {
                return state;
            }
            class_2338 into = this.dest.method_10059((class_2382)this.src).method_10081((class_2382)this.dest);
            class_2680 intoBelow = BlockStateInterface.get(this.ctx, into);
            class_2680 intoAbove = BlockStateInterface.get(this.ctx, into.method_10084());
            if (!(!this.wasTheBridgeBlockAlwaysThere || MovementHelper.isLiquid(this.ctx, feet) && !this.baritone.settings().sprintInWater.get().booleanValue() || MovementHelper.avoidWalkingInto(intoBelow) && !MovementHelper.isWater(intoBelow) || MovementHelper.avoidWalkingInto(intoAbove))) {
                state.setInput(Input.SPRINT, true);
            }
            class_2680 destDown = BlockStateInterface.get(this.ctx, this.dest.down());
            if (feet.method_10264() != this.dest.method_10264() && ladder && destDown.method_26164(class_3481.field_22414)) {
                class_2338 against = MovementPillar.getSupportingBlock(this.baritone, this.ctx, this.src, destDown);
                if (against != null) {
                    MovementHelper.moveTowards(this.ctx, state, against);
                } else {
                    MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.25);
                }
                state.setInput(Input.JUMP, true);
            } else {
                MovementHelper.moveTowards(this.ctx, state, this.dest.up());
            }
        } else {
            double dist;
            this.wasTheBridgeBlockAlwaysThere = false;
            class_265 collisionShape = standingOn.method_26220((class_1922)this.ctx.world(), standingOnPos);
            if (!collisionShape.method_1110() && collisionShape.method_1107().field_1325 < 1.0 && (dist = Math.max(Math.abs((double)this.dest.method_10263() + 0.5 - this.ctx.entity().method_23317()), Math.abs((double)this.dest.method_10260() + 0.5 - this.ctx.entity().method_23321()))) < 0.85) {
                MovementHelper.moveTowards(this.ctx, state, this.dest);
                return state.setInput(Input.MOVE_FORWARD, false).setInput(Input.MOVE_BACK, true);
            }
            double dist1 = Math.max(Math.abs(this.ctx.entity().method_23317() - ((double)this.dest.method_10263() + 0.5)), Math.abs(this.ctx.entity().method_23321() - ((double)this.dest.method_10260() + 0.5)));
            MovementHelper.PlaceResult p = MovementHelper.attemptToPlaceABlock(state, this.baritone, this.dest.down(), false, true);
            if ((p == MovementHelper.PlaceResult.READY_TO_PLACE || dist1 < 0.6) && !this.baritone.settings().assumeSafeWalk.get().booleanValue()) {
                state.setInput(Input.SNEAK, true);
            }
            switch (p) {
                case READY_TO_PLACE: {
                    if (this.ctx.entity().method_5715() || this.baritone.settings().assumeSafeWalk.get().booleanValue()) {
                        state.setInput(Input.CLICK_RIGHT, true);
                    }
                    return state;
                }
                case ATTEMPTING: {
                    if (dist1 > 0.83) {
                        float yaw = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.dest), this.ctx.entityRotations()).getYaw();
                        if ((double)Math.abs(state.getTarget().rotation.getYaw() - yaw) < 0.1) {
                            return state.setInput(Input.MOVE_FORWARD, true);
                        }
                    } else if (this.ctx.entityRotations().isReallyCloseTo(state.getTarget().rotation)) {
                        return state.setInput(Input.CLICK_LEFT, true);
                    }
                    return state;
                }
            }
            if (feet.equals((Object)this.dest)) {
                double faceX = ((double)(this.dest.method_10263() + this.src.method_10263()) + 1.0) * 0.5;
                double faceY = ((double)(this.dest.method_10264() + this.src.method_10264()) - 1.0) * 0.5;
                double faceZ = ((double)(this.dest.method_10260() + this.src.method_10260()) + 1.0) * 0.5;
                BetterBlockPos goalLook = this.src.down();
                Rotation backToFace = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), new class_243(faceX, faceY, faceZ), this.ctx.entityRotations());
                float pitch = backToFace.getPitch();
                double dist2 = Math.max(Math.abs(this.ctx.entity().method_23317() - faceX), Math.abs(this.ctx.entity().method_23321() - faceZ));
                if (dist2 < 0.29) {
                    float yaw = RotationUtils.calcRotationFromVec3d(VecUtils.getBlockPosCenter(this.dest), this.ctx.headPos(), this.ctx.entityRotations()).getYaw();
                    state.setTarget(new MovementState.MovementTarget(new Rotation(yaw, pitch), true));
                    state.setInput(Input.MOVE_BACK, true);
                } else {
                    state.setTarget(new MovementState.MovementTarget(backToFace, true));
                }
                if (this.ctx.isLookingAt(goalLook)) {
                    return state.setInput(Input.CLICK_RIGHT, true);
                }
                if (this.ctx.entityRotations().isReallyCloseTo(state.getTarget().rotation)) {
                    state.setInput(Input.CLICK_LEFT, true);
                }
                return state;
            }
            MovementHelper.moveTowards(this.ctx, state, this.dest.up());
        }
        return state;
    }

    private boolean tryOpenDoors(MovementState state, class_2680 bs, BetterBlockPos dest, BetterBlockPos src) {
        if (bs.method_26204() instanceof class_2323) {
            boolean notPassable = bs.method_26204() instanceof class_2323 && !MovementHelper.isDoorPassable(this.ctx, dest, src);
            boolean canOpen = class_2323.method_24796((class_2680)bs);
            if (notPassable && canOpen) {
                state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.calculateBlockCenter((class_1937)this.ctx.world(), dest.up()), this.ctx.entityRotations()), true)).setInput(Input.CLICK_RIGHT, true);
                ((class_2323)bs.method_26204()).method_10033(null, (class_1937)this.ctx.world(), bs, (class_2338)dest, true);
                return true;
            }
        } else if (bs.method_26204() instanceof class_2349) {
            Optional<Rotation> rotation;
            BetterBlockPos blocked;
            BetterBlockPos betterBlockPos = !MovementHelper.isGatePassable(this.ctx, dest.up(), src.up()) ? dest.up() : (blocked = !MovementHelper.isGatePassable(this.ctx, dest, src) ? dest : null);
            if (blocked != null && (rotation = RotationUtils.reachable(this.ctx, blocked)).isPresent()) {
                state.setTarget(new MovementState.MovementTarget(rotation.get(), true)).setInput(Input.CLICK_RIGHT, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || MovementHelper.canWalkOn(this.ctx, this.dest.down());
    }

    @Override
    protected boolean prepared(MovementState state) {
        class_2248 block;
        if ((this.ctx.feetPos().equals((Object)this.src) || this.ctx.feetPos().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == class_2246.field_9983 || block == class_2246.field_10597)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

