/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.Subscription;
import com.player2.playerengine.eventbus.events.EntityDeathEvent;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public class AttackPlayerOrMobCommand
extends Command {
    public AttackPlayerOrMobCommand() throws CommandException {
        super("attack", "Attacks a specified player or mob. Example usages: @attack zombie 5 to attack and kill 5 zombies, @attack Player to attack a player with username=Player", new Arg<String>(String.class, "name"), new Arg<Integer>(Integer.class, "count", 1, 1));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        String nameToAttack = parser.get(String.class);
        int countToAttack = parser.get(Integer.class);
        mod.runUserTask(new AttackAndGetDropsTask(nameToAttack, countToAttack), () -> this.finish());
    }

    private static class AttackAndGetDropsTask
    extends ResourceTask {
        private final String toKill;
        private final Task killTask;
        private int mobsKilledCount;
        private int mobKillTargetCount;
        private TimerGame forceCollectTimer = new TimerGame(2.0);
        private Subscription<EntityDeathEvent> onMobDied;
        private Predicate<class_1297> shouldAttackPredicate;
        private Set<class_1297> trackedDeadEntities = new HashSet<class_1297>();
        private static ItemTarget[] drops = new ItemTarget[]{new ItemTarget("rotten_flesh", 9999), new ItemTarget("bone", 9999), new ItemTarget("string", 9999), new ItemTarget("spider_eye", 9999), new ItemTarget("gunpowder", 9999), new ItemTarget("slime_ball", 9999), new ItemTarget("ender_pearl", 9999), new ItemTarget("blaze_powder", 9999), new ItemTarget("ghast_tear", 9999), new ItemTarget("magma_cream", 9999), new ItemTarget("ender_eye", 9999), new ItemTarget("speckled_melon", 9999), new ItemTarget("gold_nugget", 9999), new ItemTarget("iron_nugget", 9999), new ItemTarget("porkchop", 9999), new ItemTarget("beef", 9999), new ItemTarget("chicken", 9999), new ItemTarget("mutton", 9999), new ItemTarget("rabbit", 9999)};

        public AttackAndGetDropsTask(String toKill, int killCount) {
            super(drops);
            this.toKill = toKill;
            this.mobKillTargetCount = killCount;
            this.shouldAttackPredicate = entity -> {
                String playerName;
                if (this.mobsKilledCount >= this.mobKillTargetCount) {
                    return false;
                }
                if (entity instanceof class_1657 && (playerName = entity.method_5477().getString()) != null && playerName.equalsIgnoreCase(toKill)) {
                    return true;
                }
                String name = entity.method_5864().method_35050();
                return name != null && name.equals(toKill);
            };
            this.killTask = new KillEntitiesTask(this.shouldAttackPredicate);
        }

        @Override
        protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
            return false;
        }

        @Override
        protected void onResourceStart(PlayerEngineController mod) {
            this.forceCollectTimer.reset();
            this.onMobDied = EventBus.subscribe(EntityDeathEvent.class, evt -> {
                class_1297 diedEntity = evt.entity;
                if (!this.trackedDeadEntities.contains(diedEntity) && this.shouldAttackPredicate.test(diedEntity)) {
                    this.markEntityDead(diedEntity);
                }
            });
        }

        private void markEntityDead(class_1297 entity) {
            this.trackedDeadEntities.add(entity);
            ++this.mobsKilledCount;
        }

        @Override
        public boolean isFinished() {
            return this.mobsKilledCount >= this.mobKillTargetCount && this.forceCollectTimer.elapsed();
        }

        @Override
        protected Task onResourceTick(PlayerEngineController mod) {
            for (class_1297 entity : mod.getWorld().method_27909()) {
                if (this.trackedDeadEntities.contains(entity) || !this.shouldAttackPredicate.test(entity) || entity.method_5805()) continue;
                this.markEntityDead(entity);
            }
            this.trackedDeadEntities.removeIf(entityx -> entityx.method_5805());
            if (this.mobsKilledCount < this.mobKillTargetCount) {
                this.forceCollectTimer.reset();
            }
            return this.killTask;
        }

        @Override
        protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
            EventBus.unsubscribe(this.onMobDied);
            this.trackedDeadEntities.clear();
        }

        @Override
        protected boolean isEqualResource(ResourceTask other) {
            boolean bl;
            if (!(other instanceof AttackAndGetDropsTask)) {
                bl = false;
            } else {
                AttackAndGetDropsTask task = (AttackAndGetDropsTask)other;
                bl = task.toKill.equals(this.toKill) && task.mobKillTargetCount == this.mobKillTargetCount;
            }
            return bl;
        }

        @Override
        protected String toDebugStringName() {
            return "Attacking and collect items from " + this.toKill + " x " + this.mobKillTargetCount;
        }
    }
}

