/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.control;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.PathingBehavior;
import com.player2.playerengine.chains.MobDefenseChain;
import com.player2.playerengine.mixins.LivingEntityMixin;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1674;
import net.minecraft.class_1686;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4760;
import net.minecraft.class_5136;
import net.minecraft.class_7260;

public class KillAura {
    private final List<class_1297> targets = new ArrayList<class_1297>();
    boolean shielding = false;
    private double forceFieldRange = Double.POSITIVE_INFINITY;
    private class_1297 forceHit = null;
    public boolean attackedLastTick = false;

    public static void equipWeapon(PlayerEngineController mod) {
        class_1831 toolItem = MobDefenseChain.getBestWeapon(mod);
        if (toolItem != null) {
            mod.getSlotHandler().forceEquipItem((class_1792)toolItem);
        }
    }

    public void tickStart() {
        this.targets.clear();
        this.forceHit = null;
        this.attackedLastTick = false;
    }

    public void applyAura(class_1297 entity) {
        this.targets.add(entity);
        if (entity instanceof class_1674) {
            this.forceHit = entity;
        }
    }

    public void setRange(double range) {
        this.forceFieldRange = range;
    }

    public void tickEnd(PlayerEngineController mod) {
        Optional<class_1297> entities = this.targets.stream().min(StlHelper.compareValues(entity -> entity.method_5858((class_1297)mod.getPlayer())));
        if (entities.isPresent() && !mod.getEntityTracker().entityFound(class_1686.class) && (Double.isInfinite(this.forceFieldRange) || entities.get().method_5858((class_1297)mod.getPlayer()) < this.forceFieldRange * this.forceFieldRange || entities.get().method_5858((class_1297)mod.getPlayer()) < 40.0) && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting()) {
            Slot offhandSlot = PlayerSlot.getOffhandSlot(mod.getInventory());
            class_1792 offhandItem = StorageHelper.getItemStackInSlot(offhandSlot).method_7909();
            if (entities.get().getClass() != class_1548.class && entities.get().getClass() != class_4760.class && entities.get().getClass() != class_5136.class && entities.get().getClass() != class_7260.class && entities.get().getClass() != class_1528.class && (mod.getItemStorage().hasItem(class_1802.field_8255) || mod.getItemStorage().hasItemInOffhand(mod, class_1802.field_8255)) && mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
                LookHelper.lookAt(mod, entities.get().method_33571());
                class_1799 shieldSlot = StorageHelper.getItemStackInSlot(PlayerSlot.getOffhandSlot(mod.getInventory()));
                if (shieldSlot.method_7909() != class_1802.field_8255) {
                    mod.getSlotHandler().forceEquipItemToOffhand(class_1802.field_8255);
                } else if (!WorldHelper.isSurroundedByHostiles(mod)) {
                    this.startShielding(mod);
                }
            }
            this.performDelayedAttack(mod);
        } else {
            this.stopShielding(mod);
        }
        switch (mod.getModSettings().getForceFieldStrategy().ordinal()) {
            case 1: {
                this.performFastestAttack(mod);
                break;
            }
            case 2: {
                this.performDelayedAttack(mod);
                break;
            }
            case 3: {
                if (this.forceHit != null) {
                    this.attack(mod, this.forceHit, true);
                    break;
                }
                if (mod.getFoodChain().needsToEat() || mod.getMLGBucketChain().isFalling(mod) || !mod.getMLGBucketChain().doneMLG() || mod.getMLGBucketChain().isChorusFruiting()) break;
                this.performDelayedAttack(mod);
            }
        }
    }

    private void performDelayedAttack(PlayerEngineController mod) {
        if (!mod.getFoodChain().needsToEat() && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting()) {
            if (this.forceHit != null) {
                this.attack(mod, this.forceHit, true);
            }
            if (this.targets.isEmpty()) {
                return;
            }
            Optional<class_1297> toHit = this.targets.stream().min(StlHelper.compareValues(entity -> entity.method_5858((class_1297)mod.getPlayer())));
            if (mod.getPlayer() == null || this.getAttackCooldownProgress(mod.getPlayer(), 0.0f) < 1.0f) {
                return;
            }
            toHit.ifPresent(entity -> this.attack(mod, (class_1297)entity, true));
        }
    }

    public float getAttackCooldownProgressPerTick(class_1309 entity) {
        return 5.0f;
    }

    public float getAttackCooldownProgress(class_1309 entity, float baseTime) {
        return class_3532.method_15363((float)(((float)((LivingEntityMixin)entity).getLastAttackedTicks() + baseTime) / this.getAttackCooldownProgressPerTick(entity)), (float)0.0f, (float)1.0f);
    }

    private void performFastestAttack(PlayerEngineController mod) {
        if (!mod.getFoodChain().needsToEat() && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting()) {
            for (class_1297 entity : this.targets) {
                this.attack(mod, entity);
            }
        }
    }

    private void attack(PlayerEngineController mod, class_1297 entity) {
        this.attack(mod, entity, false);
    }

    private void attack(PlayerEngineController mod, class_1297 entity, boolean equipWeapon) {
        if (entity != null) {
            if (!(entity instanceof class_1674)) {
                double xAim = entity.method_23317();
                double yAim = entity.method_23318() + (double)entity.method_17682() / 1.4;
                double zAim = entity.method_23321();
                LookHelper.lookAt(mod, new class_243(xAim, yAim, zAim));
            }
            if (Double.isInfinite(this.forceFieldRange) || entity.method_5858((class_1297)mod.getPlayer()) < this.forceFieldRange * this.forceFieldRange || entity.method_5858((class_1297)mod.getPlayer()) < 40.0) {
                boolean canAttack;
                if (entity instanceof class_1674) {
                    mod.getControllerExtras().attack(entity);
                }
                if (equipWeapon) {
                    KillAura.equipWeapon(mod);
                    canAttack = true;
                } else {
                    canAttack = mod.getSlotHandler().forceDeequipHitTool();
                }
                if (canAttack && (mod.getPlayer().method_24828() || mod.getPlayer().method_18798().method_10214() < 0.0 || mod.getPlayer().method_5799())) {
                    this.attackedLastTick = true;
                    mod.getControllerExtras().attack(entity);
                }
            }
        }
    }

    public void startShielding(PlayerEngineController mod) {
        class_1799 handItem;
        this.shielding = true;
        ((PathingBehavior)mod.getBaritone().getPathingBehavior()).requestPause();
        mod.getExtraBaritoneSettings().setInteractionPaused(true);
        if (!mod.getPlayer().method_6039() && ItemVer.isFood(handItem = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())))) {
            List<class_1799> spaceSlots = mod.getItemStorage().getItemStacksPlayerInventory(false);
            if (!spaceSlots.isEmpty()) {
                for (class_1799 spaceSlot : spaceSlots) {
                    if (!spaceSlot.method_7960()) continue;
                    mod.getSlotHandler().clickSlot(PlayerSlot.getEquipSlot(mod.getInventory()), 0, class_1713.field_7794);
                    return;
                }
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().forceEquipItem(StorageHelper.getItemStackInSlot(slot).method_7909()));
        }
        mod.getInputControls().hold(Input.SNEAK);
        mod.getInputControls().hold(Input.CLICK_RIGHT);
    }

    public void stopShielding(PlayerEngineController mod) {
        if (this.shielding) {
            Optional<Slot> toMoveTo;
            class_1799 cursor = StorageHelper.getItemStackInCursorSlot(mod);
            if (ItemVer.isFood(cursor) && (toMoveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursor, false).or(() -> StorageHelper.getGarbageSlot(mod))).isPresent()) {
                Slot garbageSlot = toMoveTo.get();
                mod.getSlotHandler().clickSlot(garbageSlot, 0, class_1713.field_7790);
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.CLICK_RIGHT);
            mod.getInputControls().release(Input.JUMP);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
            this.shielding = false;
        }
    }

    public boolean isShielding() {
        return this.shielding;
    }

    public static enum Strategy {
        OFF,
        FASTEST,
        DELAY,
        SMART;

    }
}

