/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9129;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class STTUtils {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ExecutorService sttThread = Executors.newSingleThreadExecutor();
    public static volatile boolean isListening = false;
    private static volatile boolean recordingThreadRunning = false;
    private static TargetDataLine line;
    public static String clientId;
    private static ByteArrayOutputStream buffer;
    private static final float SAMPLE_RATE = 16000.0f;
    private static final int SAMPLE_SIZE_BITS = 16;
    private static final int CHANNELS = 1;
    private static final AudioFormat AUDIO_FORMAT;
    private static final int BYTES_PER_FRAME;
    private static final BlockingQueue<byte[]> audioQueue;
    private static volatile String currentToken;
    private static final HttpClient HTTP;
    private static final String API_BASE = "https://api.player2.game/v1/stt/audio";

    public static void update() {
    }

    public static void onInitialize() {
        try {
            line = AudioSystem.getTargetDataLine(AUDIO_FORMAT);
            line.open(AUDIO_FORMAT);
            LOGGER.info("Audio line opened.");
        }
        catch (Exception e) {
            LOGGER.error("Failed to open audio line", (Throwable)e);
        }
    }

    public static void setIsListening(boolean v, String clientId) {
        isListening = v;
        STTUtils.clientId = clientId;
        if (isListening) {
            STTUtils.startRecording();
            STTUtils.initToken();
        }
    }

    private static synchronized void startRecording() {
        if (recordingThreadRunning) {
            return;
        }
        if (line == null) {
            LOGGER.error("Audio line not initialized. Call onInitialize() first.");
            return;
        }
        recordingThreadRunning = true;
        sttThread.execute(() -> {
            line.start();
            buffer = new ByteArrayOutputStream();
            byte[] chunk = new byte[4096];
            while (isListening && line != null) {
                int read = line.read(chunk, 0, chunk.length);
                if (read <= 0) continue;
                LOGGER.info("STT-read {}", (Object)read);
                buffer.write(chunk, 0, read);
            }
            try {
                line.stop();
            }
            catch (Exception e) {
                LOGGER.info("STT: failed to stop line");
            }
            try {
                byte[] pcm = buffer.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(pcm);
                AudioInputStream ais = new AudioInputStream(bais, AUDIO_FORMAT, pcm.length / BYTES_PER_FRAME);
                ByteArrayOutputStream wavOutBaos = new ByteArrayOutputStream();
                AudioSystem.write(ais, AudioFileFormat.Type.WAVE, wavOutBaos);
                byte[] wavBytes = wavOutBaos.toByteArray();
                try {
                    File wavFile = new File("recorded.wav");
                    try (FileOutputStream fos = new FileOutputStream(wavFile);){
                        fos.write(wavBytes);
                    }
                    LOGGER.info("WAV saved at: " + wavFile.getAbsolutePath());
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to write local WAV file (non-fatal): {}", (Object)e.toString());
                }
                STTUtils.sendToApi(wavBytes, null);
            }
            catch (Exception e) {
                LOGGER.error("STT: Failed creating wav bytes", (Throwable)e);
            }
            finally {
                LOGGER.info("STT: Recording thread exiting");
                recordingThreadRunning = false;
            }
        });
    }

    public static void shutdown() {
        isListening = false;
        try {
            if (line != null) {
                line.stop();
                line.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sttThread.shutdownNow();
        LOGGER.info("STTUtils shutdown complete.");
    }

    public static void connect(String token) {
        if (token == null) {
            LOGGER.warn("connect called with null token; ignoring.");
            return;
        }
        sttThread.execute(() -> {
            currentToken = token;
            STTUtils.flushQueue();
        });
    }

    public static void sendToApi(byte[] wavAudio, String token) {
        if (wavAudio == null || wavAudio.length == 0) {
            LOGGER.warn("sendToApi called with empty wavAudio");
            return;
        }
        if (token != null) {
            sttThread.execute(() -> {
                currentToken = token;
                STTUtils.flushQueue();
                Optional<String> result = STTUtils.doHttpPost(wavAudio, currentToken);
                if (result.isEmpty()) {
                    boolean offered = audioQueue.offer(wavAudio);
                    LOGGER.warn("Failed to send immediate wav; requeued: {}", (Object)offered);
                } else {
                    String msg = result.get();
                    if (!msg.isBlank()) {
                        STTUtils.onSTTMessageGenerated(msg);
                    }
                }
            });
            return;
        }
        boolean offered = audioQueue.offer(wavAudio);
        if (!offered) {
            LOGGER.error("Failed to enqueue wavAudio (queue.offer returned false)");
        } else {
            LOGGER.info("Enqueued wavAudio for later sending. queueSize={}", (Object)audioQueue.size());
        }
    }

    private static void flushQueue() {
        byte[] item;
        if (currentToken == null) {
            LOGGER.info("No token available; will not flush queue.");
            return;
        }
        LOGGER.info("Flushing audio queue (size={})", (Object)audioQueue.size());
        while ((item = (byte[])audioQueue.poll()) != null) {
            Optional<String> result = STTUtils.doHttpPost(item, currentToken);
            if (result.isEmpty()) {
                boolean requeued = audioQueue.offer(item);
                LOGGER.warn("Failed to send queued audio; requeued: {}", (Object)requeued);
                break;
            }
            String msg = result.get();
            if (msg.isBlank()) continue;
            STTUtils.onSTTMessageGenerated(msg);
        }
    }

    private static Optional<String> doHttpPost(byte[] wavBytes, String token) {
        try {
            String uri = "https://api.player2.game/v1/stt/audio?encoding=linear16&sample_rate=16000";
            HttpRequest.Builder b = HttpRequest.newBuilder().uri(URI.create(uri)).timeout(Duration.ofSeconds(30L)).header("Content-Type", "application/octet-stream").POST(HttpRequest.BodyPublishers.ofByteArray(wavBytes));
            if (token != null && !token.isEmpty()) {
                b.header("Authorization", "Bearer " + token);
            }
            HttpRequest req = b.build();
            LOGGER.info("Sending {} bytes to STT API...", (Object)wavBytes.length);
            HttpResponse<String> resp = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
            int code = resp.statusCode();
            LOGGER.info("STT API response: {} body-size={} (body first 200 chars: {})", (Object)code, (Object)(resp.body() == null ? 0 : resp.body().length()), (Object)(resp.body() == null ? "" : resp.body().substring(0, Math.min(200, resp.body().length()))));
            if (code >= 200 && code < 300 && resp.body() != null) {
                String transcript = STTUtils.extractTranscript(resp.body());
                return Optional.ofNullable(transcript);
            }
            LOGGER.warn("Non-2xx response from STT API: {}", (Object)code);
            return Optional.empty();
        }
        catch (HttpTimeoutException e) {
            LOGGER.warn("Timeout sending to STT API: {}", (Object)e.getMessage());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Exception sending to STT API", (Throwable)e);
            return Optional.empty();
        }
    }

    private static void initToken() {
        class_9129 buf = new class_9129(Unpooled.buffer(), class_310.method_1551().field_1724.method_56673());
        buf.method_10814(clientId);
        class_310.method_1551().method_1562().method_52787(NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)class_2960.method_60655((String)"playerengine", (String)"request_stt"), (class_9129)buf));
    }

    private static void onSTTMessageGenerated(String message) {
        class_9129 buf = new class_9129(Unpooled.buffer(), class_310.method_1551().field_1724.method_56673());
        buf.method_10814(message);
        class_310.method_1551().method_1562().method_52787(NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)class_2960.method_60655((String)"playerengine", (String)"user_message"), (class_9129)buf));
    }

    private static String extractTranscript(String json) {
        try {
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            if (obj.has("transcript")) {
                return obj.get("transcript").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
        BYTES_PER_FRAME = AUDIO_FORMAT.getFrameSize();
        audioQueue = new LinkedBlockingQueue<byte[]>();
        currentToken = null;
        HTTP = HttpClient.newHttpClient();
    }
}

