/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.class_2338;

public class GetToBlockTask
extends CustomBaritoneGoalTask
implements ITaskRequiresGrounded {
    private final class_2338 position;
    private final boolean preferStairs;
    private final Dimension dimension;
    private int finishedTicks = 0;
    private final TimerGame wanderTimer = new TimerGame(2.0);

    public GetToBlockTask(class_2338 position, boolean preferStairs) {
        this(position, preferStairs, null);
    }

    public GetToBlockTask(class_2338 position, Dimension dimension) {
        this(position, false, dimension);
    }

    public GetToBlockTask(class_2338 position, boolean preferStairs, Dimension dimension) {
        this.dimension = dimension;
        this.position = position;
        this.preferStairs = preferStairs;
    }

    public GetToBlockTask(class_2338 position) {
        this(position, false);
    }

    @Override
    protected Task onTick() {
        if (this.dimension != null && WorldHelper.getCurrentDimension(this.controller) != this.dimension) {
            return new DefaultGoToDimensionTask(this.dimension);
        }
        this.finishedTicks = this.isFinished() ? ++this.finishedTicks : 0;
        if (this.finishedTicks > 200) {
            this.wanderTimer.reset();
            Debug.logWarning("GetToBlock was finished for 10 seconds yet is still being called, wandering");
            this.finishedTicks = 0;
            return new TimeoutWanderTask();
        }
        return !this.wanderTimer.elapsed() ? new TimeoutWanderTask() : super.onTick();
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.preferStairs) {
            this.controller.getBehaviour().push();
            this.controller.getBehaviour().setPreferredStairs(true);
        }
    }

    @Override
    protected void onStop(Task interruptTask) {
        super.onStop(interruptTask);
        if (this.preferStairs) {
            this.controller.getBehaviour().pop();
        }
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof GetToBlockTask)) {
            bl = false;
        } else {
            GetToBlockTask task = (GetToBlockTask)other;
            bl = task.position.equals((Object)this.position) && task.preferStairs == this.preferStairs && task.dimension == this.dimension;
        }
        return bl;
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() && (this.dimension == null || this.dimension == WorldHelper.getCurrentDimension(this.controller));
    }

    @Override
    protected String toDebugString() {
        return "Getting to block " + String.valueOf(this.position) + (String)(this.dimension != null ? " in dimension " + String.valueOf((Object)this.dimension) : "");
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        return new GoalBlock(this.position);
    }

    @Override
    protected void onWander(PlayerEngineController mod) {
        super.onWander(mod);
        mod.getBlockScanner().requestBlockUnreachable(this.position);
    }
}

