/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.baritone.GoalFollowEntity;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;

public class GetToEntityTask
extends Task
implements ITaskRequiresGrounded {
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final MovementProgressChecker progress = new MovementProgressChecker();
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final class_1297 entity;
    private final double closeEnoughDistance;
    class_2248[] annoyingBlocks = new class_2248[]{class_2246.field_10597, class_2246.field_22117, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22124, class_2246.field_9983, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_10214, class_2246.field_10219, class_2246.field_16999};
    private Task unstuckTask = null;

    public GetToEntityTask(class_1297 entity, double closeEnoughDistance) {
        this.entity = entity;
        this.closeEnoughDistance = closeEnoughDistance;
    }

    public GetToEntityTask(class_1297 entity) {
        this(entity, 1.0);
    }

    private static class_2338[] generateSides(class_2338 pos) {
        return new class_2338[]{pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, -1), pos.method_10069(1, 0, 1), pos.method_10069(-1, 0, -1), pos.method_10069(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, class_2338 pos) {
        class_2248[] arrayOfBlock;
        int i;
        int b;
        if (this.annoyingBlocks != null && (b = 0) < (i = (arrayOfBlock = this.annoyingBlocks).length)) {
            class_2248 AnnoyingBlocks = arrayOfBlock[b];
            return mod.getWorld().method_8320(pos).method_26204() == AnnoyingBlocks || mod.getWorld().method_8320(pos).method_26204() instanceof class_2323 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2354 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2349 || mod.getWorld().method_8320(pos).method_26204() instanceof class_2356;
        }
        return false;
    }

    private class_2338 stuckInBlock(PlayerEngineController mod) {
        class_2338[] toCheckHigh;
        class_2338[] toCheck;
        class_2338 p = mod.getPlayer().method_24515();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.method_10084())) {
            return p.method_10084();
        }
        for (class_2338 check : toCheck = GetToEntityTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (class_2338 checkx : toCheckHigh = GetToEntityTask.generateSides(p.method_10084())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.progress.reset();
        this.stuckCheck.reset();
        this.wanderTask.resetWander();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progress.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                mod.getInputControls().hold(Input.SNEAK);
                mod.getInputControls().hold(Input.MOVE_FORWARD);
                return null;
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progress.check(mod) || !this.stuckCheck.check(mod)) {
            class_2338 blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.progress.reset();
            this.setDebugState("Failed to get to target, wandering for a bit.");
            return this.wanderTask;
        }
        if (!mod.getBaritone().getCustomGoalProcess().isActive()) {
            mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalFollowEntity(this.entity, this.closeEnoughDistance));
        }
        if (mod.getPlayer().method_24516(this.entity, this.closeEnoughDistance)) {
            this.progress.reset();
        }
        if (!this.progress.check(mod)) {
            return this.wanderTask;
        }
        this.setDebugState("Going to entity");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof GetToEntityTask)) {
            bl = false;
        } else {
            GetToEntityTask task = (GetToEntityTask)other;
            bl = task.entity.equals((Object)this.entity) && Math.abs(task.closeEnoughDistance - this.closeEnoughDistance) < 0.1;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Approach entity " + this.entity.method_5864().method_5882();
    }
}

