/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.MiningRequirement;
import java.util.Arrays;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class CollectBlockByOneTask
extends ResourceTask {
    private final class_1792 item;
    private final class_2248[] blocks;
    private final MiningRequirement requirement;
    private final int count;

    public CollectBlockByOneTask(class_1792 item, class_2248[] blocks, MiningRequirement requirement, int targetCount) {
        super(item, targetCount);
        this.item = item;
        this.blocks = blocks;
        this.requirement = requirement;
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        return new MineAndCollectTask(this.item, this.count, this.blocks, this.requirement);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (!(other instanceof CollectBlockByOneTask)) {
            bl = false;
        } else {
            CollectBlockByOneTask task = (CollectBlockByOneTask)other;
            bl = task.count == this.count && task.item.equals(this.item) && Arrays.stream(task.blocks).allMatch(block -> Arrays.stream(this.blocks).toList().contains(block));
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + String.valueOf(this.item);
    }

    public static class CollectEndStoneTask
    extends CollectBlockByOneTask {
        public CollectEndStoneTask(int targetCount) {
            super(class_1802.field_20399, new class_2248[]{class_2246.field_10471}, MiningRequirement.WOOD, targetCount);
        }
    }

    public static class CollectCobblestoneTask
    extends CollectBlockByOneTask {
        public CollectCobblestoneTask(int targetCount) {
            super(class_1802.field_20412, new class_2248[]{class_2246.field_10340, class_2246.field_10445}, MiningRequirement.WOOD, targetCount);
        }
    }

    public static class CollectCobbledDeepslateTask
    extends CollectBlockByOneTask {
        public CollectCobbledDeepslateTask(int targetCount) {
            super(class_1802.field_29025, new class_2248[]{class_2246.field_28888, class_2246.field_29031}, MiningRequirement.WOOD, targetCount);
        }
    }
}

