/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class CollectWheatTask
extends ResourceTask {
    private final int count;

    public CollectWheatTask(int targetCount) {
        super(class_1802.field_8861, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        int potentialCount = mod.getItemStorage().getItemCount(class_1802.field_8861) + 9 * mod.getItemStorage().getItemCount(class_1802.field_17528);
        if (potentialCount >= this.count) {
            this.setDebugState("Crafting wheat");
            return new CraftInInventoryTask(new RecipeTarget(class_1802.field_8861, this.count, CraftingRecipe.newShapedRecipe("wheat", new ItemTarget[]{new ItemTarget(class_1802.field_17528, 1), null, null, null}, 9)));
        }
        return !mod.getBlockScanner().anyFound(class_2246.field_10359) && !mod.getEntityTracker().itemDropped(class_1802.field_17528) ? new CollectCropTask(new ItemTarget(class_1802.field_8861, this.count), new class_2248[]{class_2246.field_10293}, class_1802.field_8317) : new MineAndCollectTask(class_1802.field_17528, 99999999, new class_2248[]{class_2246.field_10359}, MiningRequirement.HAND);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectWheatTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " wheat.";
    }
}

