/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.ShearSheepTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;

public class CollectWoolTask
extends ResourceTask {
    private final int count;
    private final HashSet<class_1767> colors;
    private final class_1792[] wools;

    public CollectWoolTask(class_1767[] colors, int count) {
        super(new ItemTarget(ItemHelper.WOOL, count));
        this.colors = new HashSet<class_1767>(Arrays.asList(colors));
        this.count = count;
        this.wools = CollectWoolTask.getWoolColorItems(colors);
    }

    public CollectWoolTask(class_1767 color, int count) {
        this(new class_1767[]{color}, count);
    }

    public CollectWoolTask(int count) {
        this(class_1767.values(), count);
    }

    private static class_1792[] getWoolColorItems(class_1767[] colors) {
        class_1792[] result = new class_1792[colors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ItemHelper.getColorfulItems((class_1767)colors[i]).wool;
        }
        return result;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        class_2248[] woolBlocks = ItemHelper.itemsToBlocks(this.wools);
        if (mod.getBlockScanner().anyFound(woolBlocks)) {
            return new MineAndCollectTask(new ItemTarget(this.wools), woolBlocks, MiningRequirement.HAND);
        }
        if (this.isInWrongDimension(mod) && !mod.getEntityTracker().entityFound(class_1472.class)) {
            return this.getToCorrectDimensionTask(mod);
        }
        return mod.getItemStorage().hasItem(class_1802.field_8868) ? new ShearSheepTask() : new KillAndLootTask(class_1472.class, entity -> {
            boolean bl;
            if (!(entity instanceof class_1472)) {
                bl = false;
            } else {
                class_1472 sheep = (class_1472)entity;
                bl = this.colors.contains(sheep.method_6633()) && !sheep.method_6629();
            }
            return bl;
        }, new ItemTarget(this.wools, this.count));
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectWoolTask && ((CollectWoolTask)other).count == this.count;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " wool.";
    }
}

