/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.utils.Debug;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.AbstractDoToEntityTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_4760;
import net.minecraft.class_4836;

public class TradeWithPiglinsTask
extends ResourceTask {
    private static final boolean AVOID_HOGLINS = true;
    private static final double HOGLIN_AVOID_TRADE_RADIUS = 64.0;
    private static final double TRADING_PIGLIN_TOO_FAR_AWAY = 72.0;
    private final int goldBuffer;
    private final Task tradeTask = new PerformTradeWithPiglin();
    private Task goldTask = null;

    public TradeWithPiglinsTask(int goldBuffer, ItemTarget[] itemTargets) {
        super(itemTargets);
        this.goldBuffer = goldBuffer;
    }

    public TradeWithPiglinsTask(int goldBuffer, ItemTarget target) {
        super(target);
        this.goldBuffer = goldBuffer;
    }

    public TradeWithPiglinsTask(int goldBuffer, class_1792 item, int targetCount) {
        super(item, targetCount);
        this.goldBuffer = goldBuffer;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (this.goldTask != null && this.goldTask.isActive() && !this.goldTask.isFinished()) {
            this.setDebugState("Collecting gold");
            return this.goldTask;
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8695)) {
            if (this.goldTask == null) {
                this.goldTask = TaskCatalogue.getItemTask(class_1802.field_8695, this.goldBuffer);
            }
            return this.goldTask;
        }
        if (!mod.getEntityTracker().entityFound(class_4836.class)) {
            this.setDebugState("Wandering");
            return new TimeoutWanderTask(false);
        }
        this.setDebugState("Trading with Piglin");
        return this.tradeTask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof TradeWithPiglinsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Trading with Piglins";
    }

    static class PerformTradeWithPiglin
    extends AbstractDoToEntityTask {
        private static final double PIGLIN_NEARBY_RADIUS = 10.0;
        private final TimerGame barterTimeout = new TimerGame(2.0);
        private final TimerGame intervalTimeout = new TimerGame(10.0);
        private final HashSet<class_1297> blacklisted = new HashSet();
        private class_1297 currentlyBartering = null;

        public PerformTradeWithPiglin() {
            super(3.0);
        }

        @Override
        protected void onStart() {
            super.onStart();
            PlayerEngineController mod = this.controller;
            mod.getBehaviour().push();
            mod.getBehaviour().addProtectedItems(class_1802.field_8695);
            mod.getBehaviour().addForceFieldExclusion(entity -> entity instanceof class_4836 ? !this.blacklisted.contains(entity) : false);
        }

        @Override
        protected void onStop(Task interruptTask) {
            super.onStop(interruptTask);
            this.controller.getBehaviour().pop();
        }

        @Override
        protected boolean isSubEqual(AbstractDoToEntityTask other) {
            return other instanceof PerformTradeWithPiglin;
        }

        @Override
        protected Task onEntityInteract(PlayerEngineController mod, class_1297 entity) {
            Optional<class_1297> closestHoglin;
            if (this.intervalTimeout.elapsed()) {
                this.barterTimeout.reset();
                this.intervalTimeout.reset();
            }
            if (EntityHelper.isTradingPiglin(this.currentlyBartering)) {
                this.barterTimeout.reset();
            }
            if (!entity.equals((Object)this.currentlyBartering)) {
                this.currentlyBartering = entity;
                this.barterTimeout.reset();
            }
            if (this.barterTimeout.elapsed()) {
                Debug.logMessage("Failed bartering with current piglin, blacklisting.");
                this.blacklisted.add(this.currentlyBartering);
                this.barterTimeout.reset();
                this.currentlyBartering = null;
                return null;
            }
            if (this.currentlyBartering != null && !EntityHelper.isTradingPiglin(this.currentlyBartering) && (closestHoglin = mod.getEntityTracker().getClosestEntity(this.currentlyBartering.method_19538(), class_4760.class)).isPresent() && closestHoglin.get().method_24516(entity, 64.0)) {
                Debug.logMessage("Aborting further trading because a hoglin showed up");
                this.blacklisted.add(this.currentlyBartering);
                this.barterTimeout.reset();
                this.currentlyBartering = null;
            }
            this.setDebugState("Trading with piglin");
            if (mod.getSlotHandler().forceEquipItem(class_1802.field_8695)) {
                Debug.logError("NYI");
                this.intervalTimeout.reset();
            }
            return null;
        }

        @Override
        protected Optional<class_1297> getEntityTarget(PlayerEngineController mod) {
            Optional<class_1297> found = mod.getEntityTracker().getClosestEntity(mod.getPlayer().method_19538(), entity -> {
                if (!(this.blacklisted.contains(entity) || EntityHelper.isTradingPiglin(entity) || entity instanceof class_1309 && ((class_1309)entity).method_6109() || this.currentlyBartering != null && !entity.method_24516(this.currentlyBartering, 10.0))) {
                    Optional<class_1297> closestHoglin = mod.getEntityTracker().getClosestEntity(entity.method_19538(), class_4760.class);
                    return closestHoglin.isEmpty() || !closestHoglin.get().method_24516(entity, 64.0);
                }
                return false;
            }, class_4836.class);
            if (found.isEmpty()) {
                if (this.currentlyBartering != null && (this.blacklisted.contains(this.currentlyBartering) || !this.currentlyBartering.method_5805())) {
                    this.currentlyBartering = null;
                }
                found = Optional.ofNullable(this.currentlyBartering);
            }
            return found;
        }

        @Override
        protected String toDebugString() {
            return "Trading with piglin";
        }
    }
}

