/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.AdditionalBaritoneSettings;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.utils.Debug;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3959;

public class BotBehaviour {
    private final PlayerEngineController mod;
    Deque<State> states = new ArrayDeque<State>();

    public BotBehaviour(PlayerEngineController mod) {
        this.mod = mod;
        this.push();
    }

    public boolean shouldEscapeLava() {
        return this.current().escapeLava;
    }

    public void setEscapeLava(boolean allow) {
        this.current().escapeLava = allow;
        this.current().applyState();
    }

    public void setFollowDistance(double distance) {
        this.current().followOffsetDistance = distance;
        this.current().applyState();
    }

    public void setMineScanDroppedItems(boolean value) {
        this.current().mineScanDroppedItems = value;
        this.current().applyState();
    }

    public boolean exclusivelyMineLogs() {
        return this.current().exclusivelyMineLogs;
    }

    public void setExclusivelyMineLogs(boolean value) {
        this.current().exclusivelyMineLogs = value;
        this.current().applyState();
    }

    public boolean shouldExcludeFromForcefield(class_1297 entity) {
        if (!this.current().excludeFromForceField.isEmpty()) {
            for (Predicate<class_1297> pred : this.current().excludeFromForceField) {
                if (!pred.test(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public void addForceFieldExclusion(Predicate<class_1297> pred) {
        this.current().excludeFromForceField.add(pred);
    }

    public void avoidBlockBreaking(class_2338 pos) {
        this.current().blocksToAvoidBreaking.add(pos);
        this.current().applyState();
    }

    public void avoidBlockBreaking(Predicate<class_2338> pred) {
        this.current().toAvoidBreaking.add(pred);
        this.current().applyState();
    }

    public void avoidBlockPlacing(Predicate<class_2338> pred) {
        this.current().toAvoidPlacing.add(pred);
        this.current().applyState();
    }

    public void allowWalkingOn(Predicate<class_2338> pred) {
        this.current().allowWalking.add(pred);
        this.current().applyState();
    }

    public void avoidWalkingThrough(Predicate<class_2338> pred) {
        this.current().avoidWalkingThrough.add(pred);
        this.current().applyState();
    }

    public void forceUseTool(BiPredicate<class_2680, class_1799> pred) {
        this.current().forceUseTools.add(pred);
        this.current().applyState();
    }

    public void setRayTracingFluidHandling(class_3959.class_242 fluidHandling) {
        this.current().rayFluidHandling = fluidHandling;
        this.current().applyState();
    }

    public void setAllowWalkThroughFlowingWater(boolean value) {
        this.current().allowWalkThroughFlowingWater = value;
        this.current().applyState();
    }

    public void setPauseOnLostFocus(boolean pauseOnLostFocus) {
        this.current().pauseOnLostFocus = pauseOnLostFocus;
        this.current().applyState();
    }

    public void addProtectedItems(class_1792 ... items) {
        Collections.addAll(this.current().protectedItems, items);
        this.current().applyState();
    }

    public void removeProtectedItems(class_1792 ... items) {
        this.current().protectedItems.removeAll(Arrays.asList(items));
        this.current().applyState();
    }

    public boolean isProtected(class_1792 item) {
        return this.current().protectedItems.contains(item);
    }

    public boolean shouldForceFieldPlayers() {
        return this.current().forceFieldPlayers;
    }

    public void setForceFieldPlayers(boolean forceFieldPlayers) {
        this.current().forceFieldPlayers = forceFieldPlayers;
    }

    public void allowSwimThroughLava(boolean allow) {
        this.current().swimThroughLava = allow;
        this.current().applyState();
    }

    public void setPreferredStairs(boolean allow) {
        this.current().applyState();
    }

    public void setAllowDiagonalAscend(boolean allow) {
        this.current().allowDiagonalAscend = allow;
        this.current().applyState();
    }

    public void setBlockPlacePenalty(double penalty) {
        this.current().blockPlacePenalty = penalty;
        this.current().applyState();
    }

    public void setBlockBreakAdditionalPenalty(double penalty) {
        this.current().blockBreakAdditionalPenalty = penalty;
        this.current().applyState();
    }

    public void avoidDodgingProjectile(Predicate<class_1297> whenToDodge) {
        this.current().avoidDodgingProjectile.add(whenToDodge);
    }

    public void addGlobalHeuristic(BiFunction<Double, class_2338, Double> heuristic) {
        this.current().globalHeuristics.add(heuristic);
        this.current().applyState();
    }

    public boolean shouldAvoidDodgingProjectile(class_1297 entity) {
        if (!this.current().avoidDodgingProjectile.isEmpty()) {
            for (Predicate<class_1297> test : this.current().avoidDodgingProjectile) {
                if (!test.test(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public void push() {
        if (this.states.isEmpty()) {
            this.states.push(new State());
        } else {
            this.states.push(new State(this.current()));
        }
    }

    public void push(State customState) {
        this.states.push(customState);
    }

    public State pop() {
        if (this.states.isEmpty()) {
            Debug.logError("State stack is empty. This shouldn't be happening.");
            return null;
        }
        State popped = this.states.pop();
        if (this.states.isEmpty()) {
            Debug.logError("State stack is empty after pop. This shouldn't be happening.");
            return null;
        }
        this.states.peek().applyState();
        return popped;
    }

    private State current() {
        if (this.states.isEmpty()) {
            Debug.logError("STATE EMPTY, UNEMPTIED!");
            this.push();
        }
        return this.states.peek();
    }

    private class State {
        public double followOffsetDistance;
        public HashSet<class_1792> protectedItems = new HashSet();
        public boolean mineScanDroppedItems;
        public boolean swimThroughLava;
        public boolean allowDiagonalAscend;
        public double blockPlacePenalty;
        public double blockBreakAdditionalPenalty;
        public boolean exclusivelyMineLogs;
        public boolean forceFieldPlayers;
        public List<Predicate<class_1297>> avoidDodgingProjectile = new ArrayList<Predicate<class_1297>>();
        public List<Predicate<class_1297>> excludeFromForceField = new ArrayList<Predicate<class_1297>>();
        public HashSet<class_2338> blocksToAvoidBreaking = new HashSet();
        public List<Predicate<class_2338>> toAvoidBreaking = new ArrayList<Predicate<class_2338>>();
        public List<Predicate<class_2338>> toAvoidPlacing = new ArrayList<Predicate<class_2338>>();
        public List<Predicate<class_2338>> allowWalking = new ArrayList<Predicate<class_2338>>();
        public List<Predicate<class_2338>> avoidWalkingThrough = new ArrayList<Predicate<class_2338>>();
        public List<BiPredicate<class_2680, class_1799>> forceUseTools = new ArrayList<BiPredicate<class_2680, class_1799>>();
        public List<BiFunction<Double, class_2338, Double>> globalHeuristics = new ArrayList<BiFunction<Double, class_2338, Double>>();
        public boolean allowWalkThroughFlowingWater = false;
        public boolean pauseOnLostFocus = true;
        public class_3959.class_242 rayFluidHandling;
        public boolean escapeLava = true;

        public State() {
            this(null);
        }

        public State(State toCopy) {
            this.readState(BotBehaviour.this.mod.getBaritoneSettings());
            this.readExtraState(BotBehaviour.this.mod.getExtraBaritoneSettings());
            this.readMinecraftState();
            if (toCopy != null) {
                this.exclusivelyMineLogs = toCopy.exclusivelyMineLogs;
                this.avoidDodgingProjectile.addAll(toCopy.avoidDodgingProjectile);
                this.excludeFromForceField.addAll(toCopy.excludeFromForceField);
                this.forceFieldPlayers = toCopy.forceFieldPlayers;
                this.escapeLava = toCopy.escapeLava;
            }
        }

        public void applyState() {
            this.applyState(BotBehaviour.this.mod.getBaritoneSettings(), BotBehaviour.this.mod.getExtraBaritoneSettings());
        }

        private void readState(Settings s) {
            this.followOffsetDistance = s.followOffsetDistance.get();
            this.mineScanDroppedItems = s.mineScanDroppedItems.get();
            this.swimThroughLava = s.assumeWalkOnLava.get();
            this.allowDiagonalAscend = s.allowDiagonalAscend.get();
            this.blockPlacePenalty = s.blockPlacementPenalty.get();
            this.blockBreakAdditionalPenalty = s.blockBreakAdditionalPenalty.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readExtraState(AdditionalBaritoneSettings settings) {
            Object object = settings.getBreakMutex();
            synchronized (object) {
                Object object2 = settings.getPlaceMutex();
                synchronized (object2) {
                    this.blocksToAvoidBreaking = new HashSet<class_2338>(settings.getBlocksToAvoidBreaking());
                    this.toAvoidBreaking = new ArrayList<Predicate<class_2338>>(settings.getBreakAvoiders());
                    this.toAvoidPlacing = new ArrayList<Predicate<class_2338>>(settings.getPlaceAvoiders());
                    this.protectedItems = new HashSet<class_1792>(settings.getProtectedItems());
                    Object object3 = settings.getPropertiesMutex();
                    synchronized (object3) {
                        this.allowWalking = new ArrayList<Predicate<class_2338>>(settings.getForceWalkOnPredicates());
                        this.avoidWalkingThrough = new ArrayList<Predicate<class_2338>>(settings.getForceAvoidWalkThroughPredicates());
                        this.forceUseTools = new ArrayList<BiPredicate<class_2680, class_1799>>(settings.getForceUseToolPredicates());
                    }
                }
            }
            object = settings.getGlobalHeuristicMutex();
            synchronized (object) {
                this.globalHeuristics = new ArrayList<BiFunction<Double, class_2338, Double>>(settings.getGlobalHeuristics());
            }
            this.allowWalkThroughFlowingWater = settings.isFlowingWaterPassAllowed();
            this.rayFluidHandling = RayTraceUtils.fluidHandling;
        }

        private void readMinecraftState() {
            this.pauseOnLostFocus = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyState(Settings s, AdditionalBaritoneSettings sa) {
            s.followOffsetDistance.set(this.followOffsetDistance);
            s.mineScanDroppedItems.set(this.mineScanDroppedItems);
            s.allowDiagonalAscend.set(this.allowDiagonalAscend);
            s.blockPlacementPenalty.set(this.blockPlacePenalty);
            s.blockBreakAdditionalPenalty.set(this.blockBreakAdditionalPenalty);
            Object object = sa.getBreakMutex();
            synchronized (object) {
                Object object2 = sa.getPlaceMutex();
                synchronized (object2) {
                    sa.getBreakAvoiders().clear();
                    sa.getBreakAvoiders().addAll(this.toAvoidBreaking);
                    sa.getBlocksToAvoidBreaking().clear();
                    sa.getBlocksToAvoidBreaking().addAll(this.blocksToAvoidBreaking);
                    sa.getPlaceAvoiders().clear();
                    sa.getPlaceAvoiders().addAll(this.toAvoidPlacing);
                    sa.getProtectedItems().clear();
                    sa.getProtectedItems().addAll(this.protectedItems);
                    Object object3 = sa.getPropertiesMutex();
                    synchronized (object3) {
                        sa.getForceWalkOnPredicates().clear();
                        sa.getForceWalkOnPredicates().addAll(this.allowWalking);
                        sa.getForceAvoidWalkThroughPredicates().clear();
                        sa.getForceAvoidWalkThroughPredicates().addAll(this.avoidWalkingThrough);
                        sa.getForceUseToolPredicates().clear();
                        sa.getForceUseToolPredicates().addAll(this.forceUseTools);
                    }
                }
            }
            object = sa.getGlobalHeuristicMutex();
            synchronized (object) {
                sa.getGlobalHeuristics().clear();
                sa.getGlobalHeuristics().addAll(this.globalHeuristics);
            }
            sa.setFlowingWaterPass(this.allowWalkThroughFlowingWater);
            sa.allowSwimThroughLava(this.swimThroughLava);
            RayTraceUtils.fluidHandling = this.rayFluidHandling;
        }
    }
}

