/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingEntityInventory
implements class_1263,
class_1275 {
    public static final Logger LOGGER = LogManager.getLogger((String)"PlayerEngine");
    public static final int ITEM_USAGE_COOLDOWN = 5;
    public static final int MAIN_SIZE = 36;
    private static final int HOTBAR_SIZE = 9;
    public static final int OFF_HAND_SLOT = 40;
    public static final int NOT_FOUND = -1;
    public static final int[] ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOTS = new int[]{3};
    public final class_2371<class_1799> main = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
    public final class_2371<class_1799> armor = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public final class_2371<class_1799> offHand = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private final List<class_2371<class_1799>> combinedInventory = ImmutableList.of(this.main, this.armor, this.offHand);
    public int selectedSlot;
    public class_1309 player;
    private int changeCount;

    public LivingEntityInventory(class_1309 player) {
        this.player = player;
    }

    public class_1799 getMainHandStack() {
        return LivingEntityInventory.isValidHotbarIndex(this.selectedSlot) ? (class_1799)this.main.get(this.selectedSlot) : class_1799.field_8037;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack) && existingStack.method_7946() && existingStack.method_7947() < existingStack.method_7914() && existingStack.method_7947() < this.method_5444();
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.main.size(); ++i) {
            if (!((class_1799)this.main.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void addPickBlock(class_1799 stack) {
        int i = this.getSlotWithStack(stack);
        if (LivingEntityInventory.isValidHotbarIndex(i)) {
            this.selectedSlot = i;
        } else if (i == -1) {
            int j;
            this.selectedSlot = this.getSwappableHotbarSlot();
            if (!((class_1799)this.main.get(this.selectedSlot)).method_7960() && (j = this.getEmptySlot()) != -1) {
                this.main.set(j, (Object)((class_1799)this.main.get(this.selectedSlot)));
            }
            this.main.set(this.selectedSlot, (Object)stack);
        } else {
            this.swapSlotWithHotbar(i);
        }
    }

    public void swapSlotWithHotbar(int slot) {
        this.selectedSlot = this.getSwappableHotbarSlot();
        class_1799 itemStack = (class_1799)this.main.get(this.selectedSlot);
        this.main.set(this.selectedSlot, (Object)((class_1799)this.main.get(slot)));
        this.main.set(slot, (Object)itemStack);
    }

    public static boolean isValidHotbarIndex(int slot) {
        return slot >= 0 && slot < 9;
    }

    public int getSlotWithStack(class_1799 stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((class_1799)this.main.get(i)).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.main.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(class_1799 stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            class_1799 itemStack = (class_1799)this.main.get(i);
            if (((class_1799)this.main.get(i)).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)this.main.get(i))) || ((class_1799)this.main.get(i)).method_7986() || itemStack.method_7942() || itemStack.method_57826(class_9334.field_49631)) continue;
            return i;
        }
        return -1;
    }

    public int getSwappableHotbarSlot() {
        int j;
        for (int i = 0; i < 9; ++i) {
            j = (this.selectedSlot + i) % 9;
            if (!((class_1799)this.main.get(j)).method_7960()) continue;
            return j;
        }
        for (int ix = 0; ix < 9; ++ix) {
            j = (this.selectedSlot + ix) % 9;
            if (((class_1799)this.main.get(j)).method_7942()) continue;
            return j;
        }
        return this.selectedSlot;
    }

    public void scrollInHotbar(double scrollAmount) {
        int i = (int)Math.signum(scrollAmount);
        this.selectedSlot -= i;
        while (this.selectedSlot < 0) {
            this.selectedSlot += 9;
        }
        while (this.selectedSlot >= 9) {
            this.selectedSlot -= 9;
        }
    }

    public int remove(Predicate<class_1799> shouldRemove, int maxCount, class_1263 craftingInventory) {
        int i = 0;
        boolean bl = maxCount == 0;
        i += class_1262.method_29234((class_1263)this, shouldRemove, (int)(maxCount - i), (boolean)bl);
        return i + class_1262.method_29234((class_1263)craftingInventory, shouldRemove, (int)(maxCount - i), (boolean)bl);
    }

    private int addStack(class_1799 stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        return i == -1 ? stack.method_7947() : this.addStack(i, stack);
    }

    private int addStack(int slot, class_1799 stack) {
        class_1792 item = stack.method_7909();
        int i = stack.method_7947();
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = new class_1799((class_1935)item, 0);
            itemStack.method_57365(stack.method_57353());
            this.method_5447(slot, itemStack);
        }
        int j = i;
        if (i > itemStack.method_7914() - itemStack.method_7947()) {
            j = itemStack.method_7914() - itemStack.method_7947();
        }
        if (j > this.method_5444() - itemStack.method_7947()) {
            j = this.method_5444() - itemStack.method_7947();
        }
        if (j == 0) {
            return i;
        }
        itemStack.method_7933(j);
        itemStack.method_7912(5);
        return i -= j;
    }

    public int getOccupiedSlotWithRoomForStack(class_1799 stack) {
        if (this.canStackAddMore(this.method_5438(this.selectedSlot), stack)) {
            return this.selectedSlot;
        }
        if (this.canStackAddMore(this.method_5438(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.main.size(); ++i) {
            if (!this.canStackAddMore((class_1799)this.main.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void updateItems() {
        for (class_2371<class_1799> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (((class_1799)defaultedList.get(i)).method_7960()) continue;
                ((class_1799)defaultedList.get(i)).method_7917(this.player.method_37908(), (class_1297)this.player, i, this.selectedSlot == i);
            }
        }
    }

    public boolean insertStack(class_1799 stack) {
        return this.insertStack(-1, stack);
    }

    public boolean insertStack(int slot, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        try {
            int i;
            if (stack.method_7986()) {
                if (slot == -1) {
                    slot = this.getEmptySlot();
                }
                if (slot >= 0) {
                    this.main.set(slot, (Object)stack.method_51164());
                    ((class_1799)this.main.get(slot)).method_7912(5);
                    return true;
                }
                return false;
            }
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(this.addStack(stack));
                    continue;
                }
                stack.method_7939(this.addStack(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            return stack.method_7947() < i;
        }
        catch (Throwable var6) {
            class_128 crashReport = class_128.method_560((Throwable)var6, (String)"Adding item to inventory");
            class_129 crashReportSection = crashReport.method_562("Item being added");
            crashReportSection.method_578("Item ID", (Object)class_1792.method_7880((class_1792)stack.method_7909()));
            crashReportSection.method_578("Item data", (Object)stack.method_7919());
            crashReportSection.method_577("Item name", () -> stack.method_7964().getString());
            throw new class_148(crashReport);
        }
    }

    public class_1799 method_5434(int slot, int amount) {
        class_2371<class_1799> list = null;
        for (class_2371<class_1799> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list != null && !((class_1799)list.get(slot)).method_7960() ? class_1262.method_5430(list, (int)slot, (int)amount) : class_1799.field_8037;
    }

    public void removeOne(class_1799 stack) {
        block0: for (class_2371<class_1799> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (defaultedList.get(i) != stack) continue;
                defaultedList.set(i, (Object)class_1799.field_8037);
                continue block0;
            }
        }
    }

    public class_1799 method_5441(int slot) {
        class_2371<class_1799> defaultedList = null;
        for (class_2371<class_1799> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null && !((class_1799)defaultedList.get(slot)).method_7960()) {
            class_1799 itemStack = (class_1799)defaultedList.get(slot);
            defaultedList.set(slot, (Object)class_1799.field_8037);
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        class_2371<class_1799> defaultedList = null;
        for (class_2371<class_1799> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null) {
            defaultedList.set(slot, (Object)stack);
        }
    }

    public float getBlockBreakingSpeed(class_2680 block) {
        return ((class_1799)this.main.get(this.selectedSlot)).method_7924(block);
    }

    private void writeItemTag(class_7225.class_7874 levelRegistryAccess, class_1799 stack, class_2499 nbtList, int index) {
        if (stack.method_7960()) {
            return;
        }
        LOGGER.info("Writing itemTag={}");
        class_2487 itemTag = new class_2487();
        stack.method_57376(levelRegistryAccess, (class_2520)itemTag);
        if (!itemTag.method_10545("id")) {
            class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (key != null) {
                itemTag.method_10582("id", key.toString());
                itemTag.method_10567("Count", (byte)stack.method_7947());
            } else {
                LOGGER.info("ERR writing item: key={}, itemTag={} ", (Object)key, (Object)itemTag);
            }
        }
        itemTag.method_10567("Slot", (byte)index);
        nbtList.add((Object)itemTag);
        LOGGER.info("Done writing itemTag={}");
    }

    public class_2499 writeNbt(class_7225.class_7874 levelRegistryAccess, class_2499 nbtList) {
        class_1799 stack;
        LOGGER.info("writeNBT inventory");
        for (int i = 0; i < this.main.size(); ++i) {
            stack = (class_1799)this.main.get(i);
            this.writeItemTag(levelRegistryAccess, stack, nbtList, i);
        }
        for (int ix = 0; ix < this.armor.size(); ++ix) {
            stack = (class_1799)this.armor.get(ix);
            this.writeItemTag(levelRegistryAccess, stack, nbtList, ix + 100);
        }
        for (int ixx = 0; ixx < this.offHand.size(); ++ixx) {
            stack = (class_1799)this.offHand.get(ixx);
            this.writeItemTag(levelRegistryAccess, stack, nbtList, ixx + 150);
        }
        LOGGER.info("DONE writeNBT inventory");
        return nbtList;
    }

    public void readNbt(class_7225.class_7874 levelRegistryAccess, class_2499 nbtList) {
        LOGGER.info("writeNBT inventory");
        this.main.clear();
        this.armor.clear();
        this.offHand.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("Slot") & 0xFF;
            class_1799 itemStack = class_1799.method_57359((class_7225.class_7874)levelRegistryAccess, (class_2487)nbtCompound);
            if (itemStack.method_7960()) continue;
            LOGGER.info("Reading stack {}", (Object)itemStack);
            if (j >= 0 && j < this.main.size()) {
                this.main.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j < 150 || j >= this.offHand.size() + 150) continue;
            this.offHand.set(j - 150, (Object)itemStack);
        }
        LOGGER.info("DONE writeNBT inventory");
    }

    public int method_5439() {
        return this.main.size() + this.armor.size() + this.offHand.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.main) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        for (class_1799 itemStackx : this.armor) {
            if (itemStackx.method_7960()) continue;
            return false;
        }
        for (class_1799 itemStackxx : this.offHand) {
            if (itemStackxx.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        class_2371<class_1799> list = null;
        for (class_2371<class_1799> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list == null ? class_1799.field_8037 : (class_1799)list.get(slot);
    }

    public class_2561 method_5477() {
        return class_2561.method_43471((String)"container.inventory");
    }

    public class_1799 getArmorStack(int slot) {
        return (class_1799)this.armor.get(slot);
    }

    public void damageArmor(class_1282 damageSource, float amount, int[] slots) {
        if (!(amount <= 0.0f)) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            for (int i : slots) {
                class_1799 itemStack = (class_1799)this.armor.get(i);
                if (damageSource.method_48789(class_8103.field_42246) && itemStack.method_7909().method_57347().method_57832(class_9334.field_50076) || !(itemStack.method_7909() instanceof class_1738)) continue;
                itemStack.method_7970((int)amount, this.player, this.player.method_32326(itemStack));
            }
        }
    }

    public void dropAll() {
        for (List list : this.combinedInventory) {
            for (int i = 0; i < list.size(); ++i) {
                class_1799 itemStack = (class_1799)list.get(i);
                if (itemStack.method_7960()) continue;
                this.player.method_5775(itemStack);
                list.set(i, class_1799.field_8037);
            }
        }
    }

    public void method_5431() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean method_5443(class_1657 player) {
        return this.player.method_31481() ? false : !(player.method_5858((class_1297)this.player) > 64.0);
    }

    public boolean contains(class_1799 stack) {
        for (List list : this.combinedInventory) {
            for (class_1799 itemStack : list) {
                if (itemStack.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(class_6862<class_1792> key) {
        for (List list : this.combinedInventory) {
            for (class_1799 itemStack : list) {
                if (itemStack.method_7960() || !itemStack.method_31573(key)) continue;
                return true;
            }
        }
        return false;
    }

    public void clone(LivingEntityInventory other) {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.method_5447(i, other.method_5438(i));
        }
        this.selectedSlot = other.selectedSlot;
    }

    public void method_5448() {
        for (List list : this.combinedInventory) {
            list.clear();
        }
    }

    public void populateRecipeFinder(class_1662 finder) {
        for (class_1799 itemStack : this.main) {
            finder.method_7404(itemStack);
        }
    }

    public class_1799 dropSelectedItem(boolean entireStack) {
        class_1799 itemStack = this.getMainHandStack();
        return itemStack.method_7960() ? class_1799.field_8037 : this.method_5434(this.selectedSlot, entireStack ? itemStack.method_7947() : 1);
    }
}

