/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_3621;

public class MovementParkour
extends Movement {
    private static final BetterBlockPos[] EMPTY = new BetterBlockPos[0];
    private final class_2350 direction;
    private final int dist;
    private final boolean ascend;

    private MovementParkour(IBaritone baritone, BetterBlockPos src, int dist, class_2350 dir, boolean ascend) {
        super(baritone, src, src.offset(dir, dist).up(ascend ? 1 : 0), EMPTY, src.offset(dir, dist).down(ascend ? 0 : 1));
        this.direction = dir;
        this.dist = dist;
        this.ascend = ascend;
    }

    public static MovementParkour cost(CalculationContext context, BetterBlockPos src, class_2350 direction) {
        MutableMoveResult res = new MutableMoveResult();
        MovementParkour.cost(context, src.x, src.y, src.z, direction, res);
        int dist = Math.abs(res.x - src.x) + Math.abs(res.z - src.z);
        return new MovementParkour(context.getBaritone(), src, dist, direction, res.y > src.y);
    }

    public static void cost(CalculationContext context, int x, int y, int z, class_2350 dir, MutableMoveResult res) {
        class_2680 standingOn;
        class_2680 adj;
        int zDiff;
        int xDiff;
        if (context.allowParkour && context.height <= 2 && context.width <= 1 && (y != context.worldTop || context.allowJumpAt256) && MovementHelper.fullyPassable(context, x + (xDiff = dir.method_10148()), y, z + (zDiff = dir.method_10165())) && !MovementHelper.canWalkOn(context.bsi, x + xDiff, y - 1, z + zDiff, adj = context.get(x + xDiff, y - 1, z + zDiff), context.baritone.settings()) && (!MovementHelper.avoidWalkingInto(adj) || adj.method_26227().method_15772() instanceof class_3621) && MovementHelper.fullyPassable(context, x + xDiff, y + 1, z + zDiff) && MovementHelper.fullyPassable(context, x + xDiff, y + 2, z + zDiff) && MovementHelper.fullyPassable(context, x, y + 2, z) && (standingOn = context.get(x, y - 1, z)).method_26204() != class_2246.field_10597 && standingOn.method_26204() != class_2246.field_9983 && !(standingOn.method_26204() instanceof class_2510) && !MovementHelper.isBottomSlab(standingOn) && standingOn.method_26227().method_15772() == class_3612.field_15906) {
            class_2680 toReplace;
            int destZx;
            int destXx;
            double placeCost;
            int maxJump = (double)standingOn.method_26204().method_23349() < 0.8 ? 2 : (context.canSprint ? 4 : 3);
            boolean smol = context.height <= 1;
            for (int i = 2; i <= maxJump; ++i) {
                int destX = x + xDiff * i;
                int destZ = z + zDiff * i;
                if (!MovementHelper.fullyPassable(context, destX, y + 1, destZ)) {
                    return;
                }
                if (!smol && !MovementHelper.fullyPassable(context, destX, y + 2, destZ)) {
                    return;
                }
                class_2680 destInto = context.bsi.get0(destX, y, destZ);
                if (!MovementHelper.fullyPassable(context.bsi.access, (class_2338)context.bsi.isPassableBlockPos.method_10103(destX, y, destZ), destInto)) {
                    if (i <= 3 && context.allowParkourAscend && context.canSprint && MovementHelper.canWalkOn(context.bsi, destX, y, destZ, destInto, context.baritone.settings()) && MovementParkour.checkOvershootSafety(context.bsi, destX + xDiff, y + 1, destZ + zDiff)) {
                        res.x = destX;
                        res.y = y + 1;
                        res.z = destZ;
                        res.cost = (double)i * 3.563791874554526 + context.jumpPenalty;
                        res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
                    }
                    return;
                }
                class_2680 landingOn = context.bsi.get0(destX, y - 1, destZ);
                if (!(landingOn.method_26204() instanceof class_2344) && MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, landingOn, context.baritone.settings())) {
                    if (MovementParkour.checkOvershootSafety(context.bsi, destX + xDiff, y, destZ + zDiff)) {
                        res.x = destX;
                        res.y = y;
                        res.z = destZ;
                        res.cost = MovementParkour.costFromJumpDistance(i) + context.jumpPenalty;
                        res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
                    }
                    return;
                }
                if (MovementHelper.fullyPassable(context, destX, y + context.height + 1, destZ)) continue;
                return;
            }
            if (maxJump == 4 && context.allowParkourPlace && !((placeCost = context.costOfPlacingAt(destXx = x + 4 * xDiff, y - 1, destZx = z + 4 * zDiff, toReplace = context.get(destXx, y - 1, destZx))) >= 1000000.0) && MovementHelper.isReplaceable(destXx, y - 1, destZx, toReplace, context.bsi) && MovementParkour.checkOvershootSafety(context.bsi, destXx + xDiff, y, destZx + zDiff)) {
                for (int i = 0; i < 5; ++i) {
                    int againstX = destXx + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10148();
                    int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10164();
                    int againstZ = destZx + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].method_10165();
                    if (againstX == x + xDiff * 3 && againstZ == z + zDiff * 3 || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                    res.x = destXx;
                    res.y = y;
                    res.z = destZx;
                    res.cost = MovementParkour.costFromJumpDistance(4) + placeCost + context.jumpPenalty;
                    res.oxygenCost = context.oxygenCost(res.cost, class_2246.field_10124.method_9564());
                    return;
                }
            }
        }
    }

    private static boolean checkOvershootSafety(BlockStateInterface bsi, int x, int y, int z) {
        return !MovementHelper.avoidWalkingInto(bsi.get0(x, y, z)) && !MovementHelper.avoidWalkingInto(bsi.get0(x, y + 1, z));
    }

    private static double costFromJumpDistance(int dist) {
        switch (dist) {
            case 2: {
                return 9.26569376882094;
            }
            case 3: {
                return 13.89854065323141;
            }
            case 4: {
                return 14.255167498218103;
            }
        }
        throw new IllegalStateException("LOL " + dist);
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult res = new MutableMoveResult();
        MovementParkour.cost(context, this.src.x, this.src.y, this.src.z, this.direction, res);
        return res.x == this.dest.x && res.y == this.dest.y && res.z == this.dest.z ? res.cost : 1000000.0;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        for (int i = 0; i <= this.dist; ++i) {
            for (int y = 0; y < 2; ++y) {
                set.add(this.src.offset(this.direction, i).up(y));
            }
        }
        return set;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.feetPos().y < this.src.y) {
            this.baritone.logDebug("sorry");
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        if (this.ctx.feetPos().equals((Object)this.dest)) {
            class_2248 d = BlockStateInterface.getBlock(this.ctx, this.dest);
            if (d == class_2246.field_10597 || d == class_2246.field_9983) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (this.ctx.entity().method_18798().method_1029().method_1026(this.ctx.entity().method_5720()) > 0.5) {
                state.setInput(Input.MOVE_BACK, true);
            }
            if (this.ctx.entity().method_23318() - (double)this.ctx.feetPos().method_10264() < 0.094) {
                state.setStatus(MovementStatus.SUCCESS);
            }
        } else {
            MovementHelper.moveTowards(this.ctx, state, this.dest);
            if (this.dist >= 4 || this.ascend) {
                state.setInput(Input.SPRINT, true);
            }
            if (!this.ctx.feetPos().equals((Object)this.src)) {
                if (!this.ctx.feetPos().equals((Object)this.src.offset(this.direction)) && !(this.ctx.entity().method_23318() - (double)this.src.y > 1.0E-4)) {
                    if (!this.ctx.feetPos().equals((Object)this.dest.offset(this.direction, -1))) {
                        state.setInput(Input.SPRINT, false);
                        if (this.ctx.feetPos().equals((Object)this.src.offset(this.direction, -1))) {
                            MovementHelper.moveTowards(this.ctx, state, this.src);
                        } else {
                            MovementHelper.moveTowards(this.ctx, state, this.src.offset(this.direction, -1));
                        }
                    }
                } else {
                    if (!MovementHelper.canWalkOn(this.ctx, this.dest.down()) && !this.ctx.entity().method_24828() && MovementHelper.attemptToPlaceABlock(state, this.baritone, this.dest.down(), true, false) == MovementHelper.PlaceResult.READY_TO_PLACE) {
                        state.setInput(Input.CLICK_RIGHT, true);
                    }
                    if (this.dist == 3 && !this.ascend) {
                        double xDiff = (double)this.src.x + 0.5 - this.ctx.entity().method_23317();
                        double zDiff = (double)this.src.z + 0.5 - this.ctx.entity().method_23321();
                        double distFromStart = Math.max(Math.abs(xDiff), Math.abs(zDiff));
                        if (distFromStart < 0.7) {
                            return state;
                        }
                    }
                    state.setInput(Input.JUMP, true);
                }
            }
        }
        return state;
    }
}

