/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.player;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.cache.IWorldData;
import com.player2.playerengine.automaton.api.entity.IHungerManagerProvider;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityHungerManager;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.calc.Avoidance;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.IInteractionController;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1590;
import net.minecraft.class_1628;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2482;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class EntityContext
implements IEntityContext {
    private final class_1309 entity;
    @Nullable
    private Supplier<List<Avoidance>> avoidanceFinder;

    public EntityContext(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public class_1309 entity() {
        return this.entity;
    }

    @Override
    @Nullable
    public LivingEntityInventory inventory() {
        return this.entity instanceof IInventoryProvider ? ((IInventoryProvider)this.entity).getLivingInventory() : null;
    }

    @Override
    @Nullable
    public LivingEntityHungerManager hungerManager() {
        return this.entity instanceof IHungerManagerProvider ? ((IHungerManagerProvider)this.entity).getHungerManager() : null;
    }

    @Override
    public IInteractionController playerController() {
        return IInteractionController.KEY.get(this.entity);
    }

    @Override
    public class_3218 world() {
        class_1937 world = this.entity.method_37908();
        if (world.field_9236) {
            throw new IllegalStateException();
        }
        return (class_3218)world;
    }

    @Override
    public IWorldData worldData() {
        return BaritoneAPI.getProvider().getBaritone(this.entity).getEntityContext().worldData();
    }

    @Override
    public class_239 objectMouseOver() {
        return RayTraceUtils.rayTraceTowards((class_1297)this.entity(), this.entityRotations(), this.playerController().getBlockReachDistance());
    }

    @Override
    public BetterBlockPos feetPos() {
        class_2818 chunk;
        double x = this.entity().method_23317();
        double z = this.entity().method_23321();
        BetterBlockPos feet = new BetterBlockPos(x, this.entity().method_23318() + 0.1251, z);
        class_3218 world = this.world();
        if (world != null && (chunk = ((ServerChunkManagerAccessor)world.method_14178()).automatone$getChunkNow((int)x << 4, (int)z << 4)) != null && chunk.method_8320((class_2338)feet).method_26204() instanceof class_2482) {
            return feet.up();
        }
        return feet;
    }

    private Stream<class_1297> streamHostileEntities() {
        return this.worldEntitiesStream().filter(entity -> entity instanceof class_1308).filter(entity -> !(entity instanceof class_1628) || (double)entity.method_5718() < 0.5).filter(entity -> !(entity instanceof class_1590) || ((class_1590)entity).method_6065() != null).filter(entity -> !(entity instanceof class_1560) || ((class_1560)entity).method_7028());
    }

    @Override
    public void setAvoidanceFinder(@Nullable Supplier<List<Avoidance>> avoidanceFinder) {
        this.avoidanceFinder = avoidanceFinder;
    }

    @Override
    public List<Avoidance> listAvoidedAreas() {
        if (!this.baritone().settings().avoidance.get().booleanValue()) {
            return Collections.emptyList();
        }
        if (this.avoidanceFinder != null) {
            return this.avoidanceFinder.get();
        }
        ArrayList<Avoidance> res = new ArrayList<Avoidance>();
        double mobCoeff = this.baritone().settings().mobAvoidanceCoefficient.get();
        if (mobCoeff != 1.0) {
            this.streamHostileEntities().forEach(entity -> res.add(new Avoidance(entity.method_24515(), mobCoeff, this.baritone().settings().mobAvoidanceRadius.get())));
        }
        return res;
    }
}

