/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.eventbus.EventBus;
import com.player2.playerengine.eventbus.events.EntitySwungEvent;
import com.player2.playerengine.eventbus.events.PlayerDamageEvent;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.entity.KillPlayerTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public class PlayerDefenseChain
extends SingleTaskChain {
    private Map<String, DamageTarget> damageTargets = new HashMap<String, DamageTarget>();
    private Map<Integer, TimerGame> recentlySwung = new HashMap<Integer, TimerGame>();
    private TimerGame recentlyDamagedUnknown = new TimerGame(0.3);
    private String currentlyAttackingPlayer = null;
    private static int HITS_BEFORE_RETALIATION = 2;
    private static int HITS_BEFORE_RETALIATION_LOW_HEALTH = 1;
    private static int LOW_HEALTH_THRESHOLD = 14;
    private static double SWING_TIMEOUT = 0.4;
    private PlayerEngineController mod;

    public PlayerDefenseChain(TaskRunner runner) {
        super(runner);
        this.mod = runner.getMod();
        EventBus.subscribe(PlayerDamageEvent.class, evt -> {
            if (this.controller.getPlayer() == evt.target) {
                this.onPlayerDamage(evt.source.method_5529());
            }
        });
        EventBus.subscribe(EntitySwungEvent.class, evt -> this.onEntitySwung(evt.entity));
    }

    private void processMaybeDamaged() {
        if (this.recentlyDamagedUnknown != null && !this.recentlyDamagedUnknown.elapsed()) {
            this.recentlyDamagedUnknown = null;
            class_1309 player = this.mod.getPlayer();
            for (class_1297 entity : this.mod.getWorld().method_27909()) {
                if (entity == this.mod.getOwner()) continue;
                if (!(entity == null || this.recentlySwung.containsKey(entity.method_5628()) && this.recentlySwung.get(entity.method_5628()).elapsed())) {
                    if (entity.method_5739((class_1297)player) > 5.0f) continue;
                    class_243 playerCenter = player.method_19538().method_1019(new class_243(0.0, (double)player.method_5751(), 0.0));
                    if (!entity.method_5805() || !LookHelper.isLookingAt(entity, playerCenter, 60.0)) continue;
                    this.recentlySwung.remove(entity.method_5628());
                    this.onPlayerDamage(entity);
                    return;
                }
                this.recentlySwung.remove(entity.method_5628());
            }
        } else {
            this.recentlyDamagedUnknown = null;
        }
    }

    private void onEntitySwung(class_1297 entity) {
        int id = entity.method_5628();
        TimerGame timeout = new TimerGame(SWING_TIMEOUT);
        timeout.reset();
        this.recentlySwung.put(id, timeout);
        this.processMaybeDamaged();
    }

    private void onPlayerDamage(class_1297 damagedBy) {
        if (damagedBy != null) {
            class_1309 clientPlayer = this.mod.getPlayer();
            this.recentlyDamagedUnknown = null;
            if (damagedBy instanceof class_1657) {
                class_1657 player = (class_1657)damagedBy;
                String offendingName = player.method_5477().getString();
                if (!this.damageTargets.containsKey(offendingName)) {
                    this.damageTargets.put(offendingName, new DamageTarget());
                }
                DamageTarget target = this.damageTargets.get(offendingName);
                if (target.forgetInstigationTimer.elapsed()) {
                    target.timesHit = 0;
                }
                if (target.forgetAttackTimer.elapsed()) {
                    target.attacking = false;
                }
                target.forgetInstigationTimer.reset();
                if (!target.attacking) {
                    ++target.timesHit;
                    int hitsBeforeRetaliation = clientPlayer.method_6032() < (float)LOW_HEALTH_THRESHOLD ? HITS_BEFORE_RETALIATION_LOW_HEALTH : HITS_BEFORE_RETALIATION;
                    System.out.println("Another player hit us " + target.timesHit + "times: " + offendingName + ", attacking if they hit us " + (hitsBeforeRetaliation - target.timesHit) + " more time(s).");
                    if (target.timesHit >= hitsBeforeRetaliation) {
                        System.out.println("Too many attacks from another player! Retaliating attacks against offending player: " + offendingName);
                        target.attacking = true;
                        target.forgetAttackTimer.reset();
                        target.timesHit = 0;
                        this.currentlyAttackingPlayer = offendingName;
                    }
                } else {
                    target.forgetAttackTimer.reset();
                }
            }
        } else {
            if (this.recentlyDamagedUnknown == null || this.recentlyDamagedUnknown.elapsed()) {
                this.recentlyDamagedUnknown = new TimerGame(0.3);
                this.recentlyDamagedUnknown.reset();
            }
            this.processMaybeDamaged();
        }
    }

    @Override
    public float getPriority() {
        String[] playerNames;
        Optional<class_1657> currentPlayerEntity;
        if (!(this.currentlyAttackingPlayer == null || (currentPlayerEntity = this.controller.getEntityTracker().getPlayerEntity(this.currentlyAttackingPlayer)).isPresent() && currentPlayerEntity.get().method_5805())) {
            this.currentlyAttackingPlayer = null;
        }
        for (String potentialAttacker : playerNames = (String[])this.damageTargets.keySet().toArray(String[]::new)) {
            if (potentialAttacker == null) {
                this.damageTargets.remove(potentialAttacker);
                continue;
            }
            class_1309 potentialPlayer = this.controller.getEntityTracker().getPlayerEntity(potentialAttacker).orElse(null);
            if (potentialPlayer != null && potentialPlayer.method_5805() && !this.damageTargets.get((Object)potentialAttacker).forgetAttackTimer.elapsed()) continue;
            System.out.println("Either forgot or killed player: " + potentialAttacker + " (no longer attacking)");
            this.damageTargets.remove(potentialAttacker);
            if (!potentialAttacker.equals(this.currentlyAttackingPlayer)) continue;
            this.currentlyAttackingPlayer = null;
        }
        if (this.currentlyAttackingPlayer != null) {
            this.setTask(new KillPlayerTask(this.currentlyAttackingPlayer));
            return 55.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public String getName() {
        return "Player Defense";
    }

    static class DamageTarget {
        public TimerGame forgetInstigationTimer = new TimerGame(6.0);
        public TimerGame forgetAttackTimer = new TimerGame(30.0);
        public int timesHit = 0;
        public boolean attacking = false;

        public DamageTarget() {
            this.forgetInstigationTimer.reset();
            this.forgetAttackTimer.reset();
        }
    }
}

