/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.construction.PutOutFireTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.EscapeFromLavaTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.class_1294;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4770;

public class WorldSurvivalChain
extends SingleTaskChain {
    private final TimerGame wasInLavaTimer = new TimerGame(1.0);
    private final TimerGame portalStuckTimer = new TimerGame(5.0);
    private boolean wasAvoidingDrowning;
    private class_2338 extinguishWaterPosition;

    public WorldSurvivalChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public float getPriority() {
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        this.handleDrowning(mod);
        if (this.isInLavaOhShit(mod) && mod.getBehaviour().shouldEscapeLava()) {
            this.setTask(new EscapeFromLavaTask(mod));
            return 100.0f;
        }
        if (this.isInFire(mod)) {
            this.setTask(new DoToClosestBlockTask(PutOutFireTask::new, class_2246.field_10036, class_2246.field_22089));
            return 100.0f;
        }
        if (mod.getModSettings().shouldExtinguishSelfWithWater()) {
            if (!(this.mainTask instanceof EscapeFromLavaTask && this.isCurrentlyRunning(mod) || !mod.getPlayer().method_5809() || mod.getPlayer().method_6059(class_1294.field_5918) || mod.getWorld().method_8597().comp_644())) {
                Optional<Rotation> reach;
                class_2338 targetWaterPos;
                if (mod.getItemStorage().hasItem(class_1802.field_8705) && WorldHelper.isSolidBlock(this.controller, (targetWaterPos = mod.getPlayer().method_24515()).method_10074()) && WorldHelper.canPlace(this.controller, targetWaterPos) && (reach = LookHelper.getReach(this.controller, targetWaterPos.method_10074(), class_2350.field_11036)).isPresent()) {
                    mod.getBaritone().getLookBehavior().updateTarget(reach.get(), true);
                    if (mod.getBaritone().getEntityContext().isLookingAt(targetWaterPos.method_10074()) && mod.getSlotHandler().forceEquipItem(class_1802.field_8705)) {
                        this.extinguishWaterPosition = targetWaterPos;
                        mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                        this.setTask(null);
                        return 90.0f;
                    }
                }
                this.setTask(new DoToClosestBlockTask(GetToBlockTask::new, class_2246.field_10382));
                return 90.0f;
            }
            if (mod.getItemStorage().hasItem(class_1802.field_8550) && this.extinguishWaterPosition != null && mod.getBlockScanner().isBlockAtPosition(this.extinguishWaterPosition, class_2246.field_10382)) {
                this.setTask(new InteractWithBlockTask(new ItemTarget(class_1802.field_8550, 1), class_2350.field_11036, this.extinguishWaterPosition.method_10074(), true));
                return 60.0f;
            }
            this.extinguishWaterPosition = null;
        }
        if (this.isStuckInNetherPortal()) {
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
        } else {
            this.portalStuckTimer.reset();
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }
        if (this.portalStuckTimer.elapsed()) {
            this.setTask(new SafeRandomShimmyTask());
            return 60.0f;
        }
        return Float.NEGATIVE_INFINITY;
    }

    private void handleDrowning(PlayerEngineController mod) {
        boolean avoidedDrowning = false;
        if (mod.getModSettings().shouldAvoidDrowning() && !mod.getBaritone().getPathingBehavior().isPathing() && mod.getPlayer().method_5799() && mod.getPlayer().method_5669() < mod.getPlayer().method_5748()) {
            mod.getInputControls().hold(Input.JUMP);
            avoidedDrowning = true;
            this.wasAvoidingDrowning = true;
        }
        if (this.wasAvoidingDrowning && !avoidedDrowning) {
            this.wasAvoidingDrowning = false;
            mod.getInputControls().release(Input.JUMP);
        }
    }

    private boolean isInLavaOhShit(PlayerEngineController mod) {
        if (mod.getPlayer().method_5771() && !mod.getPlayer().method_6059(class_1294.field_5918)) {
            this.wasInLavaTimer.reset();
            return true;
        }
        return mod.getPlayer().method_5809() && !this.wasInLavaTimer.elapsed();
    }

    private boolean isInFire(PlayerEngineController mod) {
        if (mod.getPlayer().method_5809() && !mod.getPlayer().method_6059(class_1294.field_5918)) {
            for (class_2338 pos : WorldHelper.getBlocksTouchingPlayer(this.controller.getPlayer())) {
                class_2248 b = mod.getWorld().method_8320(pos).method_26204();
                if (!(b instanceof class_4770)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStuckInNetherPortal() {
        return WorldHelper.isInNetherPortal(this.controller) && !this.controller.getUserTaskChain().getCurrentTask().thisOrChildSatisfies(task -> task instanceof EnterNetherPortalTask);
    }

    @Override
    public String getName() {
        return "Misc World Survival Chain";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void onStop() {
        super.onStop();
    }
}

