/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.commands.base.ItemList;
import com.player2.playerengine.tasks.container.StoreInAnyContainerTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class DepositCommand
extends Command {
    private static final int NEARBY_RANGE = 20;
    private static final class_2248[] VALID_CONTAINERS = (class_2248[])Stream.concat(Arrays.stream(new class_2248[]{class_2246.field_10034, class_2246.field_10380, class_2246.field_16328}), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.SHULKER_BOXES))).toArray(class_2248[]::new);

    public DepositCommand() throws CommandException {
        super("deposit", "Deposit our items to a nearby chest, making a chest if one doesn't exist. Pass no arguments to depisot ALL items. Examples: `deposit` deposits ALL items, `deposit diamond 2` deposits 2 diamonds.", new Arg<Object>(ItemList.class, "items (empty for ALL non gear items)", null, 0, false));
    }

    public static ItemTarget[] getAllNonEquippedOrToolItemsAsTarget(PlayerEngineController mod) {
        return StorageHelper.getAllInventoryItemsAsTargets(mod, slot -> {
            if (slot.getInventory().size() == 4) {
                return false;
            }
            class_1799 stack = StorageHelper.getItemStackInSlot(slot);
            if (!stack.method_7960()) {
                class_1792 item = stack.method_7909();
                return !(item instanceof class_1831);
            }
            return false;
        });
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        ItemList itemList = parser.get(ItemList.class);
        if (itemList != null) {
            HashMap<String, Integer> countsLeftover = new HashMap<String, Integer>();
            for (ItemTarget itemTarget : itemList.items) {
                String name = itemTarget.getCatalogueName();
                countsLeftover.put(name, countsLeftover.getOrDefault(name, 0) + itemTarget.getTargetCount());
            }
            for (int i = 0; i < mod.getInventory().method_5439(); ++i) {
                class_1799 stack = mod.getInventory().method_5438(i);
                if (stack.method_7960()) continue;
                String name = ItemHelper.stripItemName(stack.method_7909());
                int count = stack.method_7947();
                if (!countsLeftover.containsKey(name)) continue;
                countsLeftover.put(name, (Integer)countsLeftover.get(name) - count);
                if ((Integer)countsLeftover.get(name) > 0) continue;
                countsLeftover.remove(name);
            }
            if (countsLeftover.size() != 0) {
                String leftover = String.join((CharSequence)",", countsLeftover.entrySet().stream().map(e -> (String)e.getKey() + " x " + ((Integer)e.getValue()).toString()).toList());
                mod.log("Insuffucient items in inventory to deposit. We still need: " + leftover + ".");
                this.finish();
                return;
            }
        }
        ItemTarget[] items = itemList == null ? DepositCommand.getAllNonEquippedOrToolItemsAsTarget(mod) : itemList.items;
        mod.runUserTask(new StoreInAnyContainerTask(false, items), () -> this.finish());
    }
}

