/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class DoToClosestBlockTask
extends AbstractDoToClosestObjectTask<class_2338> {
    private final class_2248[] targetBlocks;
    private final Supplier<class_243> getOriginPos;
    private final Function<class_243, Optional<class_2338>> getClosest;
    private final Function<class_2338, Task> getTargetTask;
    private final Predicate<class_2338> isValid;

    public DoToClosestBlockTask(Supplier<class_243> getOriginSupplier, Function<class_2338, Task> getTargetTask, Function<class_243, Optional<class_2338>> getClosestBlock, Predicate<class_2338> isValid, class_2248 ... blocks) {
        this.getOriginPos = getOriginSupplier;
        this.getTargetTask = getTargetTask;
        this.getClosest = getClosestBlock;
        this.isValid = isValid;
        this.targetBlocks = blocks;
    }

    public DoToClosestBlockTask(Function<class_2338, Task> getTargetTask, Function<class_243, Optional<class_2338>> getClosestBlock, Predicate<class_2338> isValid, class_2248 ... blocks) {
        this((Supplier<class_243>)null, getTargetTask, getClosestBlock, isValid, blocks);
    }

    public DoToClosestBlockTask(Function<class_2338, Task> getTargetTask, Predicate<class_2338> isValid, class_2248 ... blocks) {
        this((Supplier<class_243>)null, getTargetTask, (Function<class_243, Optional<class_2338>>)null, isValid, blocks);
    }

    public DoToClosestBlockTask(Function<class_2338, Task> getTargetTask, class_2248 ... blocks) {
        this(getTargetTask, (Function<class_243, Optional<class_2338>>)null, (class_2338 blockPos) -> true, blocks);
    }

    @Override
    protected class_243 getPos(PlayerEngineController mod, class_2338 obj) {
        return WorldHelper.toVec3d(obj);
    }

    @Override
    protected Optional<class_2338> getClosestTo(PlayerEngineController mod, class_243 pos) {
        return this.getClosest != null ? this.getClosest.apply(pos) : mod.getBlockScanner().getNearestBlock(pos, this.isValid, this.targetBlocks);
    }

    @Override
    protected class_243 getOriginPos(PlayerEngineController mod) {
        return this.getOriginPos != null ? this.getOriginPos.get() : mod.getPlayer().method_19538();
    }

    @Override
    protected Task getGoalTask(class_2338 obj) {
        return this.getTargetTask.apply(obj);
    }

    @Override
    protected boolean isValid(PlayerEngineController mod, class_2338 obj) {
        if (!mod.getChunkTracker().isChunkLoaded(obj)) {
            return true;
        }
        return this.isValid != null && !this.isValid.test(obj) ? false : mod.getBlockScanner().isBlockAtPosition(obj, this.targetBlocks);
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof DoToClosestBlockTask) {
            DoToClosestBlockTask task = (DoToClosestBlockTask)other;
            bl = Arrays.equals(task.targetBlocks, this.targetBlocks);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Doing something to closest block...";
    }
}

