/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.commands.BlockScanner;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.ClearLiquidTask;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Arrays;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;

public class PlaceObsidianBucketTask
extends Task {
    public static final class_2382[] CAST_FRAME = new class_2382[]{new class_2382(0, -1, 0), new class_2382(0, -1, -1), new class_2382(0, -1, 1), new class_2382(-1, -1, 0), new class_2382(1, -1, 0), new class_2382(0, 0, -1), new class_2382(0, 0, 1), new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(1, 1, 0)};
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final class_2338 pos;
    private class_2338 currentCastTarget;
    private class_2338 currentDestroyTarget;

    public PlaceObsidianBucketTask(class_2338 pos) {
        this.pos = pos;
    }

    @Override
    protected void onStart() {
        BotBehaviour botBehaviour = this.controller.getBehaviour();
        botBehaviour.push();
        botBehaviour.avoidBlockBreaking(this::isBlockInCastFrame);
        botBehaviour.avoidBlockPlacing(this::isBlockInCastWaterOrLava);
        this.progressChecker.reset();
        Debug.logInternal("Started onStart method");
        Debug.logInternal("Behaviour pushed");
        Debug.logInternal("Avoiding block breaking");
        Debug.logInternal("Avoiding block placing");
        Debug.logInternal("Progress checker reset");
    }

    private boolean isBlockInCastFrame(class_2338 block) {
        return Arrays.stream(CAST_FRAME).map(arg_0 -> ((class_2338)this.pos).method_10081(arg_0)).anyMatch(arg_0 -> ((class_2338)block).equals(arg_0));
    }

    private boolean isBlockInCastWaterOrLava(class_2338 blockPos) {
        class_2338 waterTarget = this.pos.method_10084();
        Debug.logInternal("blockPos: " + String.valueOf(blockPos));
        Debug.logInternal("waterTarget: " + String.valueOf(waterTarget));
        return blockPos.equals((Object)this.pos) || blockPos.equals((Object)waterTarget);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (mod.getBlockScanner().isBlockAtPosition(this.pos, class_2246.field_10540) && mod.getBlockScanner().isBlockAtPosition(this.pos.method_10084(), class_2246.field_10382)) {
            return new ClearLiquidTask(this.pos.method_10084());
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8705)) {
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(class_1802.field_8705, 1);
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8187) && !mod.getBlockScanner().isBlockAtPosition(this.pos, class_2246.field_10164)) {
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(class_1802.field_8187, 1);
        }
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            mod.getBlockScanner().requestBlockUnreachable(this.pos);
            this.progressChecker.reset();
            return new TimeoutWanderTask(5.0f);
        }
        if (this.currentCastTarget != null) {
            if (!WorldHelper.isSolidBlock(this.controller, this.currentCastTarget)) {
                return new PlaceBlockTask(this.currentCastTarget, (class_2248[])Arrays.stream(ItemHelper.itemsToBlocks(mod.getModSettings().getThrowawayItems(mod))).filter(b -> !Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.LEAVES)).toList().contains(b)).toArray(class_2248[]::new));
            }
            this.currentCastTarget = null;
        }
        if (this.currentDestroyTarget != null) {
            if (WorldHelper.isSolidBlock(this.controller, this.currentDestroyTarget)) {
                return new DestroyBlockTask(this.currentDestroyTarget);
            }
            this.currentDestroyTarget = null;
        }
        if (this.currentCastTarget != null && WorldHelper.isSolidBlock(this.controller, this.currentCastTarget)) {
            this.currentCastTarget = null;
        }
        for (class_2382 castPosRelative : CAST_FRAME) {
            class_2338 castPos = this.pos.method_10081(castPosRelative);
            if (WorldHelper.isSolidBlock(this.controller, castPos)) continue;
            this.currentCastTarget = castPos;
            Debug.logInternal("Building cast frame...");
            return null;
        }
        if (mod.getWorld().method_8320(this.pos).method_26204() != class_2246.field_10164) {
            class_2338 targetPos = this.pos.method_10069(-1, 1, 0);
            if (!mod.getPlayer().method_24515().equals((Object)targetPos) && mod.getItemStorage().hasItem(class_1802.field_8187)) {
                Debug.logInternal("Positioning player before placing lava...");
                return new GetToBlockTask(targetPos, false);
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos)) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos;
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos.method_10084())) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos.method_10084();
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos.method_10086(2))) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos.method_10086(2);
                return null;
            }
            Debug.logInternal("Placing lava for cast...");
            return new InteractWithBlockTask(new ItemTarget(class_1802.field_8187, 1), class_2350.field_11039, this.pos.method_10069(1, 0, 0), false);
        }
        class_2338 waterCheck = this.pos.method_10084();
        if (mod.getWorld().method_8320(waterCheck).method_26204() != class_2246.field_10382) {
            Debug.logInternal("Placing water for cast...");
            class_2338 targetPos = this.pos.method_10069(-1, 1, 0);
            if (!mod.getPlayer().method_24515().equals((Object)targetPos) && mod.getItemStorage().hasItem(class_1802.field_8705)) {
                Debug.logInternal("Positioning player before placing water...");
                return new GetToBlockTask(targetPos, false);
            }
            if (WorldHelper.isSolidBlock(this.controller, waterCheck)) {
                this.currentDestroyTarget = waterCheck;
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, waterCheck.method_10084())) {
                this.currentDestroyTarget = waterCheck.method_10084();
                return null;
            }
            return new InteractWithBlockTask(new ItemTarget(class_1802.field_8705, 1), class_2350.field_11039, this.pos.method_10069(1, 1, 0), true);
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        if (this.controller.getBehaviour() != null) {
            this.controller.getBehaviour().pop();
            Debug.logInternal("Behaviour popped.");
        }
    }

    @Override
    public boolean isFinished() {
        BlockScanner blockTracker = this.controller.getBlockScanner();
        class_2338 pos = this.pos;
        boolean isObsidian = blockTracker.isBlockAtPosition(pos, class_2246.field_10540);
        Debug.logInternal("isObsidian: " + isObsidian);
        boolean isNotWaterAbove = !blockTracker.isBlockAtPosition(pos.method_10084(), class_2246.field_10382);
        Debug.logInternal("isNotWaterAbove: " + isNotWaterAbove);
        boolean isFinished = isObsidian && isNotWaterAbove;
        Debug.logInternal("isFinished: " + isFinished);
        return isFinished;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof PlaceObsidianBucketTask) {
            PlaceObsidianBucketTask task = (PlaceObsidianBucketTask)other;
            boolean isEqual = task.getPos().equals((Object)this.getPos());
            Debug.logInternal("isEqual: " + isEqual);
            return isEqual;
        }
        Debug.logInternal("isEqual: false");
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Placing obsidian at " + String.valueOf(this.pos) + " with a cast";
    }

    public class_2338 getPos() {
        Debug.logInternal("Entering getPos()");
        return this.pos;
    }
}

