/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.resources.CollectRecipeCataloguedResourcesTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class CraftInTableTask
extends ResourceTask {
    private final RecipeTarget[] targets;
    private class_2338 craftingTablePos = null;
    private final TimerGame craftTimer = new TimerGame(2.0);
    private boolean isCrafting = false;

    public CraftInTableTask(RecipeTarget[] targets) {
        super(CraftInTableTask.extractItemTargets(targets));
        this.targets = targets;
    }

    public CraftInTableTask(RecipeTarget target) {
        this(new RecipeTarget[]{target});
    }

    private static ItemTarget[] extractItemTargets(RecipeTarget[] recipeTargets) {
        return (ItemTarget[])Arrays.stream(recipeTargets).map(t -> new ItemTarget(t.getOutputItem(), t.getTargetCount())).toArray(ItemTarget[]::new);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
        controller.getBehaviour().push();
        for (RecipeTarget target : this.targets) {
            for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                if (ingredient == null || ingredient.isEmpty()) continue;
                controller.getBehaviour().addProtectedItems(ingredient.getMatches());
            }
        }
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        boolean allDone = Arrays.stream(this.targets).allMatch(targetx -> controller.getItemStorage().getItemCount(targetx.getOutputItem()) >= targetx.getTargetCount());
        if (allDone) {
            return null;
        }
        if (!StorageHelper.hasRecipeMaterialsOrTarget(controller, this.targets)) {
            this.setDebugState("Collecting ingredients");
            return new CollectRecipeCataloguedResourcesTask(false, this.targets);
        }
        if (this.craftingTablePos == null || !controller.getWorld().method_8320(this.craftingTablePos).method_27852(class_2246.field_9980)) {
            Optional<class_2338> nearestTable = controller.getBlockScanner().getNearestBlock(class_2246.field_9980);
            if (nearestTable.isPresent()) {
                this.craftingTablePos = nearestTable.get();
                this.setDebugState("Found crafting table: " + this.craftingTablePos.method_23854());
            } else {
                this.craftingTablePos = null;
                this.setDebugState("Crafting table not found.");
            }
        }
        if (this.craftingTablePos == null) {
            if (controller.getItemStorage().hasItem(class_1802.field_8465)) {
                this.setDebugState("Placing crafting table.");
                return new PlaceBlockNearbyTask(class_2246.field_9980);
            }
            this.setDebugState("Obtaining crafting table.");
            return TaskCatalogue.getItemTask(class_1802.field_8465, 1);
        }
        if (!this.craftingTablePos.method_19771(new class_2382((int)controller.getEntity().method_19538().field_1352, (int)controller.getEntity().method_19538().field_1351, (int)controller.getEntity().method_19538().field_1350), 3.5)) {
            this.setDebugState("Going to crafting table at: " + this.craftingTablePos.method_23854());
            return new GetCloseToBlockTask(this.craftingTablePos);
        }
        this.setDebugState("Crafting...");
        if (!this.isCrafting) {
            this.craftTimer.reset();
            this.isCrafting = true;
        }
        if (!this.craftTimer.elapsed()) {
            return null;
        }
        for (RecipeTarget target : this.targets) {
            int currentAmount = controller.getItemStorage().getItemCount(target.getOutputItem());
            if (currentAmount >= target.getTargetCount()) continue;
            int craftsNeeded = (int)Math.ceil((double)(target.getTargetCount() - currentAmount) / (double)target.getRecipe().outputCount());
            for (int i = 0; i < craftsNeeded; ++i) {
                if (!StorageHelper.hasRecipeMaterialsOrTarget(controller, new RecipeTarget(target.getOutputItem(), target.getRecipe().outputCount(), target.getRecipe()))) {
                    Debug.logWarning("Not enough ingredients to craft, even though the check passed. Aborting.");
                    return new CollectRecipeCataloguedResourcesTask(false, this.targets);
                }
                LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
                for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                    if (ingredient == null || ingredient.isEmpty()) continue;
                    inventory.remove(stack -> ingredient.matches(stack.method_7909()), ingredient.getTargetCount(), inventory);
                }
                class_1799 result = new class_1799((class_1935)target.getOutputItem(), target.getRecipe().outputCount());
                inventory.insertStack(result);
                controller.getItemStorage().registerSlotAction();
            }
        }
        controller.getEntity().method_6104(class_1268.field_5808);
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
        controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CraftInTableTask) {
            CraftInTableTask task = (CraftInTableTask)other;
            bl = Arrays.equals(task.targets, this.targets);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Craft on table: " + Arrays.toString(Arrays.stream(this.targets).map(t -> t.getOutputItem().method_7848().getString()).toArray());
    }

    public RecipeTarget[] getRecipeTargets() {
        return this.targets;
    }
}

