/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.mixins.MixinAbstractFurnaceBlockEntity;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.CollectFuelTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2609;

public class SmeltInSmokerTask
extends ResourceTask {
    private final SmeltTarget[] targets;
    private final TimerGame smeltTimer = new TimerGame(5.0);
    private class_2338 smokerPos = null;
    private boolean isSmelting = false;
    private SmokerCache cache;

    public SmeltInSmokerTask(SmeltTarget ... targets) {
        super(SmeltInSmokerTask.extractItemTargets(targets));
        this.targets = targets;
    }

    public SmeltInSmokerTask(SmeltTarget target) {
        this(new SmeltTarget[]{target});
    }

    private static ItemTarget[] extractItemTargets(SmeltTarget[] recipeTargets) {
        ArrayList<ItemTarget> result = new ArrayList<ItemTarget>(recipeTargets.length);
        for (SmeltTarget target : recipeTargets) {
            result.add(target.getItem());
        }
        return (ItemTarget[])result.toArray(ItemTarget[]::new);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController controller) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController controller) {
        controller.getBehaviour().push();
        controller.getBehaviour().addProtectedItems(class_1802.field_16309);
        for (SmeltTarget target : this.targets) {
            controller.getBehaviour().addProtectedItems(target.getMaterial().getMatches());
        }
    }

    @Override
    protected Task onResourceTick(PlayerEngineController controller) {
        boolean allDone = Arrays.stream(this.targets).allMatch(target -> controller.getItemStorage().getItemCount(target.getItem()) >= target.getItem().getTargetCount());
        if (allDone) {
            this.setDebugState("Done smoking.");
            return null;
        }
        SmeltTarget currentTarget = Arrays.stream(this.targets).filter(t -> controller.getItemStorage().getItemCount(t.getItem()) < t.getItem().getTargetCount()).findFirst().orElse(null);
        if (currentTarget == null) {
            return null;
        }
        this.smeltTimer.setInterval(10 * currentTarget.getItem().getTargetCount());
        int fuelNeeded = (int)Math.ceil((double)currentTarget.getItem().getTargetCount() / 8.0);
        if (!this.isSmelting) {
            if (!controller.getItemStorage().hasItem(currentTarget.getMaterial())) {
                this.setDebugState("Collecting raw food: " + String.valueOf(currentTarget.getMaterial()));
                return TaskCatalogue.getItemTask(currentTarget.getMaterial());
            }
            if (StorageHelper.calculateInventoryFuelCount(controller) < (double)fuelNeeded) {
                this.setDebugState("Collecting fuel.");
                return new CollectFuelTask(fuelNeeded);
            }
        }
        if (this.smokerPos == null || !controller.getWorld().method_8320(this.smokerPos).method_27852(class_2246.field_16334)) {
            Optional<class_2338> nearestSmoker = controller.getBlockScanner().getNearestBlock(class_2246.field_16334);
            if (!nearestSmoker.isPresent()) {
                if (controller.getItemStorage().hasItem(class_1802.field_16309)) {
                    this.setDebugState("Placing smoker.");
                    return new PlaceBlockNearbyTask(class_2246.field_16334);
                }
                this.setDebugState("Obtaining smoker.");
                return TaskCatalogue.getItemTask(class_1802.field_16309, 1);
            }
            this.smokerPos = nearestSmoker.get();
        }
        if (!this.smokerPos.method_19771(new class_2382((int)controller.getEntity().method_19538().field_1352, (int)controller.getEntity().method_19538().field_1351, (int)controller.getEntity().method_19538().field_1350), 4.5)) {
            this.setDebugState("Going to smoker.");
            return new GetCloseToBlockTask(this.smokerPos);
        }
        class_2586 class_25862 = controller.getWorld().method_8321(this.smokerPos);
        if (class_25862 instanceof class_2609) {
            LivingEntityInventory playerInv;
            class_2609 smoker = (class_2609)class_25862;
            class_1799 outputStack = smoker.method_5438(2);
            if (!outputStack.method_7960()) {
                this.setDebugState("Taking smoked items.");
                playerInv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
                if (!playerInv.insertStack(outputStack)) {
                    this.setDebugState("Inventory full.");
                    return null;
                }
                smoker.method_5447(2, class_1799.field_8037);
                smoker.method_5431();
            }
            if (this.isSmelting) {
                this.setDebugState("Waiting for items to smoke...");
                if (this.smeltTimer.elapsed()) {
                    this.isSmelting = false;
                }
                return null;
            }
            playerInv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
            if (((MixinAbstractFurnaceBlockEntity)smoker).getPropertyDelegate().method_17390(0) <= 1 && smoker.method_5438(1).method_7960()) {
                this.setDebugState("Adding fuel.");
                class_1792 fuelItem = controller.getModSettings().getSupportedFuelItems()[0];
                int fuelSlotIndex = playerInv.getSlotWithStack(new class_1799((class_1935)fuelItem));
                if (fuelSlotIndex != -1) {
                    smoker.method_5447(1, playerInv.method_5434(fuelSlotIndex, fuelNeeded));
                    smoker.method_5431();
                }
            }
            if (smoker.method_5438(0).method_7960()) {
                this.setDebugState("Adding raw food.");
                class_1792 materialItem = currentTarget.getMaterial().getMatches()[0];
                int materialSlotIndex = playerInv.getSlotWithStack(new class_1799((class_1935)materialItem));
                if (materialSlotIndex != -1) {
                    smoker.method_5447(0, playerInv.method_5434(materialSlotIndex, currentTarget.getMaterial().getTargetCount()));
                    this.isSmelting = true;
                    this.smeltTimer.reset();
                    smoker.method_5431();
                    return null;
                }
            }
            this.isSmelting = true;
            this.smeltTimer.reset();
            this.setDebugState("Waiting for smoker...");
            return null;
        }
        Debug.logWarning("Block at smoker position is not a smoker BE. Resetting.");
        this.smokerPos = null;
        return new TimeoutWanderTask(1.0f);
    }

    @Override
    protected void onResourceStop(PlayerEngineController controller, Task interruptTask) {
        controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof SmeltInSmokerTask) {
            SmeltInSmokerTask task = (SmeltInSmokerTask)other;
            bl = Arrays.equals(task.targets, this.targets);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Smelting in Smoker";
    }

    static class SmokerCache {
        public class_1799 materialSlot = class_1799.field_8037;
        public class_1799 fuelSlot = class_1799.field_8037;
        public class_1799 outputSlot = class_1799.field_8037;
        public double burningFuelCount;
        public double burnPercentage;

        SmokerCache() {
        }
    }
}

