/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.base.Task;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_243;

public class DoToClosestEntityTask
extends AbstractDoToClosestObjectTask<class_1297> {
    private final Class[] targetEntities;
    private final Supplier<class_243> getOriginPos;
    private final Function<class_1297, Task> getTargetTask;
    private final Predicate<class_1297> shouldInteractWith;

    public DoToClosestEntityTask(Supplier<class_243> getOriginSupplier, Function<class_1297, Task> getTargetTask, Predicate<class_1297> shouldInteractWith, Class ... entities) {
        this.getOriginPos = getOriginSupplier;
        this.getTargetTask = getTargetTask;
        this.shouldInteractWith = shouldInteractWith;
        this.targetEntities = entities;
    }

    public DoToClosestEntityTask(Supplier<class_243> getOriginSupplier, Function<class_1297, Task> getTargetTask, Class ... entities) {
        this(getOriginSupplier, getTargetTask, (class_1297 entity) -> true, entities);
    }

    public DoToClosestEntityTask(Function<class_1297, Task> getTargetTask, Predicate<class_1297> shouldInteractWith, Class ... entities) {
        this((Supplier<class_243>)null, getTargetTask, shouldInteractWith, entities);
    }

    public DoToClosestEntityTask(Function<class_1297, Task> getTargetTask, Class ... entities) {
        this((Supplier<class_243>)null, getTargetTask, (class_1297 entity) -> true, entities);
    }

    @Override
    protected class_243 getPos(PlayerEngineController mod, class_1297 obj) {
        return obj.method_19538();
    }

    @Override
    protected Optional<class_1297> getClosestTo(PlayerEngineController mod, class_243 pos) {
        return !mod.getEntityTracker().entityFound(this.targetEntities) ? Optional.empty() : mod.getEntityTracker().getClosestEntity(pos, this.shouldInteractWith, this.targetEntities);
    }

    @Override
    protected class_243 getOriginPos(PlayerEngineController mod) {
        return this.getOriginPos != null ? this.getOriginPos.get() : mod.getPlayer().method_19538();
    }

    @Override
    protected Task getGoalTask(class_1297 obj) {
        return this.getTargetTask.apply(obj);
    }

    @Override
    protected boolean isValid(PlayerEngineController mod, class_1297 obj) {
        return obj.method_5805() && mod.getEntityTracker().isEntityReachable(obj) && obj != mod.getEntity();
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof DoToClosestEntityTask) {
            DoToClosestEntityTask task = (DoToClosestEntityTask)other;
            bl = Arrays.equals(task.targetEntities, this.targetEntities);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Doing something to closest entity...";
    }
}

