/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import net.minecraft.class_1297;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.apache.commons.lang3.ArrayUtils;

public class PlaceBedAndSetSpawnTask
extends Task {
    private final TimerGame regionScanTimer = new TimerGame(9.0);
    private final class_2382 BED_CLEAR_SIZE = new class_2382(3, 2, 3);
    private final class_2382[] BED_BOTTOM_PLATFORM = new class_2382[]{new class_2382(0, -1, 0), new class_2382(1, -1, 0), new class_2382(2, -1, 0), new class_2382(0, -1, -1), new class_2382(1, -1, -1), new class_2382(2, -1, -1), new class_2382(0, -1, 1), new class_2382(1, -1, 1), new class_2382(2, -1, 1)};
    private final class_2382 BED_PLACE_STAND_POS = new class_2382(0, 0, 1);
    private final class_2382 BED_PLACE_POS = new class_2382(1, 0, 1);
    private final class_2382[] BED_PLACE_POS_OFFSET = new class_2382[]{this.BED_PLACE_POS, this.BED_PLACE_POS.method_35861(), this.BED_PLACE_POS.method_35859(), this.BED_PLACE_POS.method_35855(), this.BED_PLACE_POS.method_35857(), this.BED_PLACE_POS.method_34592(-1, 0, 1), this.BED_PLACE_POS.method_34592(1, 0, 1), this.BED_PLACE_POS.method_34592(-1, 0, -1), this.BED_PLACE_POS.method_34592(1, 0, -1), this.BED_PLACE_POS.method_35860(2), this.BED_PLACE_POS.method_35858(2), this.BED_PLACE_POS.method_35854(2), this.BED_PLACE_POS.method_35856(2), this.BED_PLACE_POS.method_34592(-2, 0, 1), this.BED_PLACE_POS.method_34592(-2, 0, 2), this.BED_PLACE_POS.method_34592(2, 0, 1), this.BED_PLACE_POS.method_34592(2, 0, 2), this.BED_PLACE_POS.method_34592(-2, 0, -1), this.BED_PLACE_POS.method_34592(-2, 0, -2), this.BED_PLACE_POS.method_34592(2, 0, -1), this.BED_PLACE_POS.method_34592(2, 0, -2)};
    private final class_2350 BED_PLACE_DIRECTION = class_2350.field_11036;
    private final TimerGame bedInteractTimeout = new TimerGame(5.0);
    private final TimerGame inBedTimer = new TimerGame(1.0);
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private boolean stayInBed;
    private class_2338 currentBedRegion;
    private class_2338 currentStructure;
    private class_2338 currentBreak;
    private boolean spawnSet;
    private boolean sleepAttemptMade;
    private boolean wasSleeping;
    private class_2338 bedForSpawnPoint;

    public PlaceBedAndSetSpawnTask stayInBed() {
        Debug.logInternal("Stay in bed method called");
        this.stayInBed = true;
        Debug.logInternal("Setting stayInBed to true");
        return this;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        this.progressChecker.reset();
        this.currentBedRegion = null;
        mod.getBehaviour().avoidBlockPlacing(pos -> {
            if (this.currentBedRegion == null) {
                return false;
            }
            class_2338 start = this.currentBedRegion;
            class_2338 end = this.currentBedRegion.method_10081(this.BED_CLEAR_SIZE);
            return start.method_10263() <= pos.method_10263() && pos.method_10263() < end.method_10263() && start.method_10260() <= pos.method_10260() && pos.method_10260() < end.method_10260() && start.method_10264() <= pos.method_10264() && pos.method_10264() < end.method_10264();
        });
        mod.getBehaviour().avoidBlockBreaking(pos -> {
            if (this.currentBedRegion != null) {
                for (class_2382 baseOffs : this.BED_BOTTOM_PLATFORM) {
                    class_2338 base = this.currentBedRegion.method_10081(baseOffs);
                    if (!base.equals(pos)) continue;
                    return true;
                }
            }
            return mod.getWorld() != null ? mod.getWorld().method_8320(pos).method_26204() instanceof class_2244 : false;
        });
        this.spawnSet = false;
        this.sleepAttemptMade = false;
        this.wasSleeping = false;
        Debug.logInternal("Started onStart() method");
        Debug.logInternal("Current bed region: " + String.valueOf(this.currentBedRegion));
        Debug.logInternal("Spawn set: " + this.spawnSet);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (!this.progressChecker.check(mod) && this.currentBedRegion != null) {
            this.progressChecker.reset();
            Debug.logMessage("Searching new bed region.");
            this.currentBedRegion = null;
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            this.setDebugState("We are in nether portal. Wandering");
            this.currentBedRegion = null;
            return new TimeoutWanderTask();
        }
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD) {
            this.setDebugState("Going to the overworld first.");
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        if (mod.getBlockScanner().anyFound(blockPosx -> WorldHelper.canReach(this.controller, blockPosx) && blockPosx.method_19769((class_2374)mod.getPlayer().method_19538(), 40.0) && mod.getItemStorage().hasItem(ItemHelper.BED) || WorldHelper.canReach(this.controller, blockPosx) && !mod.getItemStorage().hasItem(ItemHelper.BED), ItemHelper.itemsToBlocks(ItemHelper.BED))) {
            this.setDebugState("Going to bed to sleep...");
            return new DoToClosestBlockTask(toSleepIn -> {
                boolean closeEnough = toSleepIn.method_19771(new class_2382((int)mod.getPlayer().method_19538().field_1352, (int)mod.getPlayer().method_19538().field_1351, (int)mod.getPlayer().method_19538().field_1350), 3.0);
                if (closeEnough) {
                    class_243 centerBed = new class_243((double)toSleepIn.method_10263() + 0.5, (double)toSleepIn.method_10264() + 0.2, (double)toSleepIn.method_10260() + 0.5);
                    class_3965 hit = LookHelper.raycast((class_1297)mod.getPlayer(), centerBed, 6.0);
                    closeEnough = false;
                    if (hit.method_17783() != class_239.class_240.field_1333) {
                        class_2338 p = hit.method_17777();
                        if (ArrayUtils.contains((Object[])ItemHelper.itemsToBlocks(ItemHelper.BED), (Object)mod.getWorld().method_8320(p).method_26204())) {
                            closeEnough = true;
                        }
                    }
                }
                this.bedForSpawnPoint = WorldHelper.getBedHead(this.controller, toSleepIn);
                if (this.bedForSpawnPoint == null) {
                    this.bedForSpawnPoint = toSleepIn;
                }
                if (!closeEnough) {
                    try {
                        class_2350 face = (class_2350)mod.getWorld().method_8320(toSleepIn).method_11654((class_2769)class_2244.field_11177);
                        class_2350 side = face.method_10170();
                        return new GetToBlockTask(this.bedForSpawnPoint.method_10081(side.method_10163()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    this.inBedTimer.reset();
                }
                if (closeEnough) {
                    this.inBedTimer.reset();
                }
                this.progressChecker.reset();
                return new InteractWithBlockTask(this.bedForSpawnPoint);
            }, ItemHelper.itemsToBlocks(ItemHelper.BED));
        }
        if (mod.getPlayer().method_5799() && mod.getItemStorage().hasItem(ItemHelper.BED)) {
            this.setDebugState("We are in water. Wandering");
            this.currentBedRegion = null;
            return new TimeoutWanderTask();
        }
        if (this.currentBedRegion != null) {
            for (class_2382 BedPlacePos : this.BED_PLACE_POS_OFFSET) {
                class_2248 getBlock = mod.getWorld().method_8320(this.currentBedRegion.method_10081(BedPlacePos)).method_26204();
                if (!(getBlock instanceof class_2244)) continue;
                mod.getBlockScanner().addBlock(getBlock, this.currentBedRegion.method_10081(BedPlacePos));
                break;
            }
        }
        if (!mod.getItemStorage().hasItem(ItemHelper.BED)) {
            this.setDebugState("Getting a bed first");
            return TaskCatalogue.getItemTask("bed", 1);
        }
        if (this.currentBedRegion == null && this.regionScanTimer.elapsed()) {
            Debug.logMessage("Rescanning for nearby bed place position...");
            this.regionScanTimer.reset();
            this.currentBedRegion = this.locateBedRegion(mod, mod.getPlayer().method_24515());
        }
        if (this.currentBedRegion == null) {
            this.setDebugState("Searching for spot to place bed, wandering...");
            return new TimeoutWanderTask();
        }
        for (class_2382 baseOffs : this.BED_BOTTOM_PLATFORM) {
            class_2338 blockPos = this.currentBedRegion.method_10081(baseOffs);
            if (WorldHelper.isSolidBlock(this.controller, blockPos)) continue;
            this.currentStructure = blockPos;
            break;
        }
        block2: for (int dx = 0; dx < this.BED_CLEAR_SIZE.method_10263(); ++dx) {
            for (int dz = 0; dz < this.BED_CLEAR_SIZE.method_10260(); ++dz) {
                for (int dy = 0; dy < this.BED_CLEAR_SIZE.method_10264(); ++dy) {
                    class_2338 toClear = this.currentBedRegion.method_10069(dx, dy, dz);
                    if (!WorldHelper.isSolidBlock(this.controller, toClear)) continue;
                    this.currentBreak = toClear;
                    break block2;
                }
            }
        }
        if (this.currentStructure != null) {
            if (!WorldHelper.isSolidBlock(this.controller, this.currentStructure)) {
                this.setDebugState("Placing structure for bed");
                return new PlaceStructureBlockTask(this.currentStructure);
            }
            this.currentStructure = null;
        }
        if (this.currentBreak != null) {
            if (WorldHelper.isSolidBlock(this.controller, this.currentBreak)) {
                this.setDebugState("Clearing region for bed");
                return new DestroyBlockTask(this.currentBreak);
            }
            this.currentBreak = null;
        }
        class_2338 toStand = this.currentBedRegion.method_10081(this.BED_PLACE_STAND_POS);
        if (!mod.getPlayer().method_24515().equals((Object)toStand)) {
            return new GetToBlockTask(toStand);
        }
        class_2338 toPlace = this.currentBedRegion.method_10081(this.BED_PLACE_POS);
        if (mod.getWorld().method_8320(toPlace.method_10093(this.BED_PLACE_DIRECTION)).method_26204() instanceof class_2244) {
            this.setDebugState("Waiting to rescan + find bed that we just placed. Should be almost instant.");
            this.progressChecker.reset();
            return null;
        }
        this.setDebugState("Placing bed...");
        this.setDebugState("Filling in Portal");
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().cancelEverything();
            mod.getBaritone().getPathingBehavior().forceCancel();
            mod.getBaritone().getExploreProcess().onLostControl();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            this.progressChecker.reset();
        }
        if (this.thisOrChildSatisfies(task -> {
            InteractWithBlockTask intr;
            return task instanceof InteractWithBlockTask ? (intr = (InteractWithBlockTask)task).getClickStatus() == InteractWithBlockTask.ClickResponse.CLICK_ATTEMPTED : false;
        })) {
            mod.getInputControls().tryPress(Input.MOVE_BACK);
        }
        return new InteractWithBlockTask(new ItemTarget("bed", 1), this.BED_PLACE_DIRECTION, toPlace.method_10093(this.BED_PLACE_DIRECTION.method_10153()), false);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
        Debug.logInternal("Tracking stopped for beds");
        Debug.logInternal("Behaviour popped");
        Debug.logInternal("Unsubscribed from respawn point set message");
        Debug.logInternal("Unsubscribed from respawn failure message");
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean isSameTask = other instanceof PlaceBedAndSetSpawnTask;
        if (!isSameTask) {
            Debug.logInternal("Tasks are not of the same type");
        }
        return isSameTask;
    }

    @Override
    protected String toDebugString() {
        return "Placing a bed nearby + resetting spawn point";
    }

    @Override
    public boolean isFinished() {
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD) {
            Debug.logInternal("Can't place spawnpoint/sleep in a bed unless we're in the overworld!");
            return true;
        }
        boolean isSleeping = this.controller.getPlayer().method_6113();
        boolean timerElapsed = this.inBedTimer.elapsed();
        boolean isFinished = this.spawnSet && !isSleeping && timerElapsed;
        Debug.logInternal("isSleeping: " + isSleeping);
        Debug.logInternal("timerElapsed: " + timerElapsed);
        Debug.logInternal("isFinished: " + isFinished);
        return isFinished;
    }

    public class_2338 getBedSleptPos() {
        Debug.logInternal("Fetching bed slept position");
        return this.bedForSpawnPoint;
    }

    public boolean isSpawnSet() {
        Debug.logInternal("Checking if spawn is set");
        return this.spawnSet;
    }

    private class_2338 locateBedRegion(PlayerEngineController mod, class_2338 origin) {
        int SCAN_RANGE = 10;
        class_2338 closestGood = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (int x = origin.method_10263() - 10; x < origin.method_10263() + 10; ++x) {
            for (int z = origin.method_10260() - 10; z < origin.method_10260() + 10; ++z) {
                for (int y = origin.method_10264() - 10; y < origin.method_10264() + 10; ++y) {
                    class_2338 attemptPos = new class_2338(x, y, z);
                    double distance = BlockPosVer.getSquaredDistance(attemptPos, (class_2374)mod.getPlayer().method_19538());
                    Debug.logInternal("Checking position: " + String.valueOf(attemptPos));
                    if (distance > closestDist) {
                        Debug.logInternal("Skipping position: " + String.valueOf(attemptPos));
                        continue;
                    }
                    if (!this.isGoodPosition(mod, attemptPos)) continue;
                    Debug.logInternal("Found good position: " + String.valueOf(attemptPos));
                    closestGood = attemptPos;
                    closestDist = distance;
                }
            }
        }
        return closestGood;
    }

    private boolean isGoodPosition(PlayerEngineController mod, class_2338 pos) {
        class_2338 BED_CLEAR_SIZE = new class_2338(2, 1, 2);
        for (int x = 0; x < BED_CLEAR_SIZE.method_10263(); ++x) {
            for (int y = 0; y < BED_CLEAR_SIZE.method_10264(); ++y) {
                for (int z = 0; z < BED_CLEAR_SIZE.method_10260(); ++z) {
                    class_2338 checkPos = pos.method_10069(x, y, z);
                    if (this.isGoodToPlaceInsideOrClear(mod, checkPos)) continue;
                    Debug.logInternal("Not a good position: " + String.valueOf(checkPos));
                    return false;
                }
            }
        }
        Debug.logInternal("Good position");
        return true;
    }

    private boolean isGoodToPlaceInsideOrClear(PlayerEngineController mod, class_2338 pos) {
        class_2382[] CHECK;
        for (class_2382 offset : CHECK = new class_2382[]{new class_2382(0, 0, 0), new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(0, 1, 0), new class_2382(0, -1, 0), new class_2382(0, 0, 1), new class_2382(0, 0, -1)}) {
            class_2338 newPos = pos.method_10081(offset);
            if (this.isGoodAsBorder(mod, newPos)) continue;
            Debug.logInternal("Not good as border: " + String.valueOf(newPos));
            return false;
        }
        Debug.logInternal("Good to place inside or clear");
        return true;
    }

    private boolean isGoodAsBorder(PlayerEngineController mod, class_2338 pos) {
        boolean isSolid = WorldHelper.isSolidBlock(this.controller, pos);
        Debug.logInternal("isSolid: " + isSolid);
        if (isSolid) {
            boolean canBreak = WorldHelper.canBreak(this.controller, pos);
            Debug.logInternal("canBreak: " + canBreak);
            return canBreak;
        }
        boolean isAir = WorldHelper.isAir(this.controller, pos);
        Debug.logInternal("isAir: " + isAir);
        return isAir;
    }
}

