/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.GetToXZTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.apache.commons.lang3.NotImplementedException;

public class FastTravelTask
extends Task {
    private static final double IN_NETHER_CLOSE_ENOUGH_THRESHOLD = 15.0;
    private final boolean collectPortalMaterialsIfAbsent;
    private final class_2338 target;
    private final Integer threshold;
    private final TimerGame attemptToMoveToIdealNetherCoordinateTimeout = new TimerGame(15.0);
    private boolean forceOverworldWalking;
    private Task goToOverworldTask;

    public FastTravelTask(class_2338 overworldTarget, Integer threshold, boolean collectPortalMaterialsIfAbsent) {
        this.target = overworldTarget;
        this.threshold = null;
        this.collectPortalMaterialsIfAbsent = collectPortalMaterialsIfAbsent;
    }

    public FastTravelTask(class_2338 overworldTarget, boolean collectPortalMaterialsIfAbsent) {
        this(overworldTarget, null, collectPortalMaterialsIfAbsent);
    }

    @Override
    protected void onStart() {
        class_2338 netherTarget = new class_2338(this.target.method_10263() / 8, this.target.method_10264(), this.target.method_10260() / 8);
        this.goToOverworldTask = new EnterNetherPortalTask(new ConstructNetherPortalObsidianTask(), Dimension.OVERWORLD, checkPos -> WorldHelper.inRangeXZ(checkPos, netherTarget, 7.0));
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        class_2338 netherTarget = new class_2338(this.target.method_10263() / 8, this.target.method_10264(), this.target.method_10260() / 8);
        boolean canBuildPortal = mod.getItemStorage().hasItem(class_1802.field_8377) || mod.getItemStorage().getItemCount(class_1802.field_8281) >= 10;
        boolean canLightPortal = mod.getItemStorage().hasItem(class_1802.field_8884, class_1802.field_8814);
        switch (WorldHelper.getCurrentDimension(this.controller)) {
            case OVERWORLD: {
                this.attemptToMoveToIdealNetherCoordinateTimeout.reset();
                if (!this.forceOverworldWalking && !WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), this.target, (double)this.getOverworldThreshold(mod))) {
                    if (!canBuildPortal || !canLightPortal) {
                        if (!this.collectPortalMaterialsIfAbsent) {
                            this.setDebugState("Walking: We don't have portal building materials");
                            return new GetToBlockTask(this.target);
                        }
                        this.setDebugState("Collecting portal building materials");
                        if (!canBuildPortal) {
                            return TaskCatalogue.getItemTask(class_1802.field_8377, 1);
                        }
                        if (!canLightPortal) {
                            return TaskCatalogue.getItemTask(class_1802.field_8884, 1);
                        }
                    }
                    return new DefaultGoToDimensionTask(Dimension.NETHER);
                }
                this.forceOverworldWalking = true;
                this.setDebugState("Walking: We're close enough to our target");
                if (mod.getBlockScanner().anyFound(class_2246.field_10398)) {
                    this.setDebugState("Walking to portal");
                    return new GetToBlockTask(mod.getBlockScanner().getNearestBlock(class_2246.field_10398).get());
                }
                return new GetToBlockTask(this.target);
            }
            case NETHER: {
                Optional<class_2338> portalEntrance;
                if (!this.forceOverworldWalking && (portalEntrance = mod.getMiscBlockTracker().getLastUsedNetherPortal(Dimension.NETHER)).isPresent() && !portalEntrance.get().method_19771(new class_2382((int)mod.getPlayer().method_19538().field_1352, (int)mod.getPlayer().method_19538().field_1351, (int)mod.getPlayer().method_19538().field_1350), 3.0)) {
                    this.forceOverworldWalking = true;
                }
                if (this.goToOverworldTask.isActive() && !this.goToOverworldTask.isFinished()) {
                    this.setDebugState("Going back to overworld");
                    return this.goToOverworldTask;
                }
                if (mod.getItemStorage().getItemCount(class_1802.field_8281) < 10) {
                    this.setDebugState("Making sure we can build our portal");
                    return TaskCatalogue.getItemTask(class_1802.field_8281, 10);
                }
                if (!canLightPortal && mod.getEntityTracker().itemDropped(class_1802.field_8884, class_1802.field_8814)) {
                    this.setDebugState("Making sure we can light our portal");
                    return new PickupDroppedItemTask(new ItemTarget(class_1802.field_8884, class_1802.field_8814), true);
                }
                if (!(WorldHelper.inRangeXZ((class_1297)mod.getPlayer(), netherTarget, 15.0) && mod.getBaritone().getPathingBehavior().isSafeToCancel() && (mod.getPlayer().method_31477() == netherTarget.method_10263() && mod.getPlayer().method_31479() == netherTarget.method_10260() || this.attemptToMoveToIdealNetherCoordinateTimeout.elapsed()))) {
                    this.attemptToMoveToIdealNetherCoordinateTimeout.reset();
                    this.setDebugState("Traveling to ideal coordinates");
                    return new GetToXZTask(netherTarget.method_10263(), netherTarget.method_10260());
                }
                return this.goToOverworldTask;
            }
            case END: {
                this.setDebugState("Why are you running this here?");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
        }
        throw new NotImplementedException("Unimplemented dimension: " + String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)));
    }

    private int getOverworldThreshold(PlayerEngineController mod) {
        int threshold = this.threshold == null ? mod.getModSettings().getNetherFastTravelWalkingRange() : this.threshold.intValue();
        threshold = Math.max(152, threshold);
        return Math.max(128, threshold);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof FastTravelTask)) {
            bl = false;
        } else {
            FastTravelTask task = (FastTravelTask)other;
            bl = task.target.equals((Object)this.target) && task.collectPortalMaterialsIfAbsent == this.collectPortalMaterialsIfAbsent && Objects.equals(task.threshold, this.threshold);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Fast travelling to " + this.target.method_23854();
    }
}

