/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1589;
import net.minecraft.class_1802;

public class CollectMagmaCreamTask
extends ResourceTask {
    private final int count;

    public CollectMagmaCreamTask(int count) {
        super(class_1802.field_8135, count);
        this.count = count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        int currentCream = mod.getItemStorage().getItemCount(class_1802.field_8135);
        int neededCream = this.count - currentCream;
        switch (WorldHelper.getCurrentDimension(this.controller).ordinal()) {
            case 1: {
                if (mod.getEntityTracker().entityFound(class_1589.class)) {
                    this.setDebugState("Killing Magma cube");
                    return new KillAndLootTask(class_1589.class, new ItemTarget(class_1802.field_8135));
                }
                int currentBlazePowderPotential = mod.getItemStorage().getItemCount(class_1802.field_8183) + mod.getItemStorage().getItemCount(class_1802.field_8894);
                if (neededCream > currentBlazePowderPotential) {
                    this.setDebugState("Getting blaze powder");
                    return TaskCatalogue.getItemTask(class_1802.field_8183, neededCream - currentCream);
                }
                this.setDebugState("Going back to overworld to kill slimes, we have enough blaze powder and no nearby magma cubes.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
            case 2: {
                int currentSlime = mod.getItemStorage().getItemCount(class_1802.field_8777);
                if (neededCream > currentSlime) {
                    this.setDebugState("Getting slime balls");
                    return TaskCatalogue.getItemTask(class_1802.field_8777, neededCream - currentCream);
                }
                this.setDebugState("Going to nether to get blaze powder and/or kill magma cubes");
                return new DefaultGoToDimensionTask(Dimension.NETHER);
            }
            case 3: {
                this.setDebugState("Going to overworld, no magma cream materials exist here.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
        }
        this.setDebugState("INVALID DIMENSION??: " + String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)));
        return null;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectMagmaCreamTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Magma cream.";
    }
}

