/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;

public class GetSmithingTemplateTask
extends ResourceTask {
    private final Task searcher = new SearchChunkForBlockTask(class_2246.field_23869);
    private final int count;
    private class_2338 chestloc = null;

    public GetSmithingTemplateTask(int count) {
        super(class_1802.field_41946, count);
        this.count = count;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (WorldHelper.getCurrentDimension(mod) != Dimension.NETHER) {
            this.setDebugState("Going to nether");
            return new DefaultGoToDimensionTask(Dimension.NETHER);
        }
        if (this.chestloc == null) {
            for (class_2338 pos : mod.getBlockScanner().getKnownLocations(class_2246.field_10034)) {
                if (!WorldHelper.isInteractableBlock(mod, pos)) continue;
                this.chestloc = pos;
                break;
            }
        }
        if (this.chestloc != null) {
            this.setDebugState("Destroying Chest");
            if (WorldHelper.isInteractableBlock(mod, this.chestloc)) {
                return new DestroyBlockTask(this.chestloc);
            }
            this.chestloc = null;
            for (class_2338 posx : mod.getBlockScanner().getKnownLocations(class_2246.field_10034)) {
                if (!WorldHelper.isInteractableBlock(mod, posx)) continue;
                this.chestloc = posx;
                break;
            }
        }
        this.setDebugState("Searching for/Traveling around bastion");
        return this.searcher;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof GetSmithingTemplateTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " smithing templates";
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }
}

