/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.datatypes.EntityClassById;
import com.player2.playerengine.automaton.api.command.datatypes.IDatatypeFor;
import com.player2.playerengine.automaton.api.command.datatypes.NearbyPlayer;
import com.player2.playerengine.automaton.api.command.exception.CommandErrorMessageException;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class FollowCommand
extends Command {
    public FollowCommand() {
        super("follow");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        FollowGroup group;
        args.requireMin(1);
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        ArrayList<class_1299> classes = new ArrayList<class_1299>();
        if (args.hasExactlyOne()) {
            group = args.getEnum(FollowGroup.class);
            baritone.getFollowProcess().follow(group.filter);
        } else {
            args.requireMin(2);
            group = null;
            FollowList list = args.getEnum(FollowList.class);
            while (args.hasAny()) {
                Object gotten = args.getDatatypeFor(list.datatype);
                if (gotten instanceof class_1299) {
                    classes.add((class_1299)gotten);
                    continue;
                }
                if (gotten == null) continue;
                entities.add((class_1297)gotten);
            }
            baritone.getFollowProcess().follow(classes.isEmpty() ? entities::contains : e -> classes.stream().anyMatch(c -> e.method_5864().equals(c)));
        }
        if (group != null) {
            this.logDirect(source, String.format("Following all %s", group.name().toLowerCase(Locale.US)));
        } else if (classes.isEmpty()) {
            if (entities.isEmpty()) {
                throw new NoEntitiesException();
            }
            this.logDirect(source, "Following these entities:");
            entities.stream().map(class_1297::toString).forEach(message -> this.logDirect(source, (String)message));
        } else {
            this.logDirect(source, "Following these types of entities:");
            classes.stream().map(arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0)).map(Objects::requireNonNull).map(class_2960::toString).forEach(message -> this.logDirect(source, (String)message));
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) throws CommandException {
        IDatatypeFor<?> followType;
        if (args.hasExactlyOne()) {
            return new TabCompleteHelper().append(FollowGroup.class).append(FollowList.class).filterPrefix(args.getString()).stream();
        }
        try {
            followType = args.getEnum(FollowList.class).datatype;
        }
        catch (NullPointerException var5) {
            return Stream.empty();
        }
        while (args.has(2)) {
            if (args.peekDatatypeOrNull(followType) == null) {
                return Stream.empty();
            }
            args.get();
        }
        return args.tabCompleteDatatype(followType);
    }

    @Override
    public String getShortDesc() {
        return "Follow entity things";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The follow command makes an entity follow other entities of certain kinds.", "", "Usage:", "> follow entities - Follows all entities.", "> follow entity <entity1> <entity2> <...> - Follow certain entities (for example 'skeleton', 'horse' etc.)", "> follow players - Follow players", "> follow player <username1> <username2> <...> - Follow certain players");
    }

    @KeepName
    private static enum FollowGroup {
        ENTITIES(class_1309.class::isInstance),
        PLAYERS(class_1657.class::isInstance);

        final Predicate<class_1297> filter;

        private FollowGroup(Predicate<class_1297> filter) {
            this.filter = filter;
        }
    }

    @KeepName
    private static enum FollowList {
        ENTITY(EntityClassById.INSTANCE),
        PLAYER(NearbyPlayer.INSTANCE);

        final IDatatypeFor<?> datatype;

        private FollowList(IDatatypeFor<?> datatype) {
            this.datatype = datatype;
        }
    }

    public static class NoEntitiesException
    extends CommandErrorMessageException {
        protected NoEntitiesException() {
            super("No valid entities in range!");
        }
    }
}

