/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.pathing.goals.GoalStrictDirection;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class TunnelCommand
extends Command {
    public TunnelCommand() {
        super("tunnel");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        args.requireMax(3);
        IEntityContext ctx = baritone.getEntityContext();
        if (args.hasExactly(3)) {
            boolean cont = true;
            int height = Integer.parseInt(args.getArgs().get(0).getValue());
            int width = Integer.parseInt(args.getArgs().get(1).getValue());
            int depth = Integer.parseInt(args.getArgs().get(2).getValue());
            if (width < 1 || height < 2 || depth < 1 || height > 255) {
                this.logDirect(source, "Width and depth must at least be 1 block; Height must at least be 2 blocks, and cannot be greater than the build limit.");
                cont = false;
            }
            if (cont) {
                class_2338 corner1;
                --height;
                class_2350 enumFacing = ctx.entity().method_5735();
                int addition = --width % 2 == 0 ? 0 : 1;
                class_2338 corner2 = switch (enumFacing) {
                    case class_2350.field_11034 -> {
                        corner1 = new class_2338(ctx.feetPos().x, ctx.feetPos().y, ctx.feetPos().z - width / 2);
                        yield new class_2338(ctx.feetPos().x + depth, ctx.feetPos().y + height, ctx.feetPos().z + width / 2 + addition);
                    }
                    case class_2350.field_11039 -> {
                        corner1 = new class_2338(ctx.feetPos().x, ctx.feetPos().y, ctx.feetPos().z + width / 2 + addition);
                        yield new class_2338(ctx.feetPos().x - depth, ctx.feetPos().y + height, ctx.feetPos().z - width / 2);
                    }
                    case class_2350.field_11043 -> {
                        corner1 = new class_2338(ctx.feetPos().x - width / 2, ctx.feetPos().y, ctx.feetPos().z);
                        yield new class_2338(ctx.feetPos().x + width / 2 + addition, ctx.feetPos().y + height, ctx.feetPos().z - depth);
                    }
                    case class_2350.field_11035 -> {
                        corner1 = new class_2338(ctx.feetPos().x + width / 2 + addition, ctx.feetPos().y, ctx.feetPos().z);
                        yield new class_2338(ctx.feetPos().x - width / 2, ctx.feetPos().y + height, ctx.feetPos().z + depth);
                    }
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(enumFacing));
                };
                this.logDirect(source, String.format("Creating a tunnel %s block(s) high, %s block(s) wide, and %s block(s) deep", height + 1, width + 1, depth));
                baritone.getBuilderProcess().clearArea(corner1, corner2);
            }
        } else {
            GoalStrictDirection goal = new GoalStrictDirection(ctx.feetPos(), ctx.entity().method_5735());
            baritone.getCustomGoalProcess().setGoalAndPath(goal);
            this.logDirect(source, String.format("Goal: %s", ((Object)goal).toString()));
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) {
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Set a goal to tunnel in your current direction";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The tunnel command sets a goal that tells Automatone to mine completely straight in the direction that you're facing.", "", "Usage:", "> tunnel - No arguments, mines in a 1x2 radius.", "> tunnel <height> <width> <depth> - Tunnels in a user defined height, width and depth.");
    }
}

