/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.cache.IWaypoint;
import com.player2.playerengine.automaton.api.cache.Waypoint;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.datatypes.ForWaypoints;
import com.player2.playerengine.automaton.api.command.datatypes.RelativeBlockPos;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidStateException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidTypeException;
import com.player2.playerengine.automaton.api.command.helpers.Paginator;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class WaypointsCommand
extends Command {
    public WaypointsCommand() {
        super("waypoints", "waypoint", "wp");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        Action action;
        Action action2 = action = args.hasAny() ? Action.getByName(args.getString()) : Action.LIST;
        if (action == null) {
            throw new CommandInvalidTypeException(args.consumed(), "an action");
        }
        BiFunction<IWaypoint, Action, class_2561> toComponent = (waypointx, _action) -> {
            class_5250 component = class_2561.method_43470((String)"");
            class_5250 tagComponent = class_2561.method_43470((String)(waypointx.getTag().name() + " "));
            tagComponent.method_10862(tagComponent.method_10866().method_27706(class_124.field_1080));
            String name = waypointx.getName();
            class_5250 nameComponent = class_2561.method_43470((String)(!name.isEmpty() ? name : "<empty>"));
            nameComponent.method_10862(nameComponent.method_10866().method_27706(!name.isEmpty() ? class_124.field_1080 : class_124.field_1063));
            class_5250 timestamp = class_2561.method_43470((String)(" @ " + String.valueOf(new Date(waypointx.getCreationTimestamp()))));
            timestamp.method_10862(timestamp.method_10866().method_27706(class_124.field_1063));
            component.method_10852((class_2561)tagComponent);
            component.method_10852((class_2561)nameComponent);
            component.method_10852((class_2561)timestamp);
            component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to select"))).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s %s %s @ %d", "/automatone ", label, _action.names[0], waypointx.getTag().getName(), waypointx.getCreationTimestamp()))));
            return component;
        };
        Function<IWaypoint, class_2561> transform = waypointx -> (class_2561)toComponent.apply((IWaypoint)waypointx, action == Action.LIST ? Action.INFO : action);
        if (action == Action.LIST) {
            IWaypoint[] waypoints;
            IWaypoint.Tag tag;
            IWaypoint.Tag tag2 = tag = args.hasAny() ? IWaypoint.Tag.getByName(args.peekString()) : null;
            if (tag != null) {
                args.get();
            }
            IWaypoint[] iWaypointArray = waypoints = tag != null ? ForWaypoints.getWaypointsByTag(baritone, tag) : ForWaypoints.getWaypoints(baritone);
            if (waypoints.length <= 0) {
                args.requireMax(0);
                throw new CommandInvalidStateException(tag != null ? "No waypoints found by that tag" : "No waypoints found");
            }
            args.requireMax(1);
            Paginator.paginate(args, waypoints, () -> this.logDirect(source, tag != null ? String.format("All waypoints by tag %s:", tag.name()) : "All waypoints:"), transform, String.format("%s%s %s%s", "/automatone ", label, action.names[0], tag != null ? " " + tag.getName() : ""), source);
        } else if (action == Action.SAVE) {
            IWaypoint.Tag tagx = IWaypoint.Tag.getByName(args.getString());
            if (tagx == null) {
                throw new CommandInvalidStateException(String.format("'%s' is not a tag ", args.consumedString()));
            }
            String name = args.hasAny() ? args.getString() : "";
            BetterBlockPos pos = args.hasAny() ? (BetterBlockPos)((Object)args.getDatatypePost(RelativeBlockPos.INSTANCE, baritone.getEntityContext().feetPos())) : baritone.getEntityContext().feetPos();
            args.requireMax(0);
            Waypoint waypoint = new Waypoint(name, tagx, pos);
            ForWaypoints.waypoints(baritone).addWaypoint(waypoint);
            class_5250 component = class_2561.method_43470((String)"Waypoint added: ");
            component.method_10862(component.method_10866().method_27706(class_124.field_1080));
            component.method_10852(toComponent.apply(waypoint, Action.INFO));
            this.logDirect(source, new class_2561[]{component});
        } else if (action == Action.CLEAR) {
            IWaypoint[] waypoints;
            args.requireMax(1);
            IWaypoint.Tag tagx = IWaypoint.Tag.getByName(args.getString());
            for (IWaypoint waypoint : waypoints = ForWaypoints.getWaypointsByTag(baritone, tagx)) {
                ForWaypoints.waypoints(baritone).removeWaypoint(waypoint);
            }
            this.logDirect(source, String.format("Cleared %d waypoints", waypoints.length));
        } else {
            IWaypoint[] waypoints = (IWaypoint[])args.getDatatypeFor(ForWaypoints.INSTANCE);
            IWaypoint waypoint = null;
            if (args.hasAny() && args.peekString().equals("@")) {
                args.requireExactly(2);
                args.get();
                long timestamp = args.getAs(Long.class);
                for (IWaypoint iWaypoint : waypoints) {
                    if (iWaypoint.getCreationTimestamp() != timestamp) continue;
                    waypoint = iWaypoint;
                    break;
                }
                if (waypoint == null) {
                    throw new CommandInvalidStateException("Timestamp was specified but no waypoint was found");
                }
            } else {
                switch (waypoints.length) {
                    case 0: {
                        throw new CommandInvalidStateException("No waypoints found");
                    }
                    case 1: {
                        waypoint = waypoints[0];
                    }
                }
            }
            if (waypoint == null) {
                args.requireMax(1);
                Paginator.paginate(args, waypoints, () -> this.logDirect(source, "Multiple waypoints were found:"), transform, String.format("%s%s %s %s", "/automatone ", label, action.names[0], args.consumedString()), source);
            } else if (action == Action.INFO) {
                this.logDirect(source, transform.apply(waypoint));
                this.logDirect(source, String.format("Position: %s", new Object[]{waypoint.getLocation()}));
                class_5250 deleteComponent = class_2561.method_43470((String)"Click to delete this waypoint");
                deleteComponent.method_10862(deleteComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s delete %s @ %d", "/automatone ", label, waypoint.getTag().getName(), waypoint.getCreationTimestamp()))));
                class_5250 goalComponent = class_2561.method_43470((String)"Click to set goal to this waypoint");
                goalComponent.method_10862(goalComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s goal %s @ %d", "/automatone ", label, waypoint.getTag().getName(), waypoint.getCreationTimestamp()))));
                class_5250 backComponent = class_2561.method_43470((String)"Click to return to the waypoints list");
                backComponent.method_10862(backComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s list", "/automatone ", label))));
                this.logDirect(source, new class_2561[]{deleteComponent});
                this.logDirect(source, new class_2561[]{goalComponent});
                this.logDirect(source, new class_2561[]{backComponent});
            } else if (action == Action.DELETE) {
                ForWaypoints.waypoints(baritone).removeWaypoint(waypoint);
                this.logDirect(source, "That waypoint has successfully been deleted");
            } else if (action == Action.GOAL) {
                GoalBlock goal = new GoalBlock(waypoint.getLocation());
                baritone.getCustomGoalProcess().setGoal(goal);
                this.logDirect(source, String.format("Goal: %s", goal));
            } else if (action == Action.GOTO) {
                GoalBlock goal = new GoalBlock(waypoint.getLocation());
                baritone.getCustomGoalProcess().setGoalAndPath(goal);
                this.logDirect(source, String.format("Going to: %s", goal));
            }
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) throws CommandException {
        if (args.hasAny()) {
            if (args.hasExactlyOne()) {
                return new TabCompleteHelper().append(Action.getAllNames()).sortAlphabetically().filterPrefix(args.getString()).stream();
            }
            Action action = Action.getByName(args.getString());
            if (args.hasExactlyOne()) {
                if (action != Action.LIST && action != Action.SAVE && action != Action.CLEAR) {
                    return args.tabCompleteDatatype(ForWaypoints.INSTANCE);
                }
                return new TabCompleteHelper().append(IWaypoint.Tag.getAllNames()).sortAlphabetically().filterPrefix(args.getString()).stream();
            }
            if (args.has(3) && action == Action.SAVE) {
                args.get();
                args.get();
                return args.tabCompleteDatatype(RelativeBlockPos.INSTANCE);
            }
        }
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Manage waypoints";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The waypoint command allows you to manage Baritone's waypoints.", "", "Waypoints can be used to mark positions for later. Waypoints are each given a tag and an optional name.", "", "Note that the info, delete, and goal commands let you specify a waypoint by tag. If there is more than one waypoint with a certain tag, then they will let you select which waypoint you mean.", "", "Usage:", "> wp [l/list] - List all waypoints.", "> wp <s/save> <tag> - Save your current position as an unnamed waypoint with the specified tag.", "> wp <s/save> <tag> <name> - Save the waypoint with the specified name.", "> wp <s/save> <tag> <name> <pos> - Save the waypoint with the specified name and position.", "> wp <i/info/show> <tag> - Show info on a waypoint by tag.", "> wp <d/delete> <tag> - Delete a waypoint by tag.", "> wp <g/goal> <tag> - Set a goal to a waypoint by tag.", "> wp <goto> <tag> - Set a goal to a waypoint by tag and start pathing.");
    }

    private static enum Action {
        LIST("list", "get", "l"),
        CLEAR("clear", "c"),
        SAVE("save", "s"),
        INFO("info", "show", "i"),
        DELETE("delete", "d"),
        GOAL("goal", "g"),
        GOTO("goto");

        private final String[] names;

        private Action(String ... names) {
            this.names = names;
        }

        public static Action getByName(String name) {
            for (Action action : Action.values()) {
                for (String alias : action.names) {
                    if (!alias.equalsIgnoreCase(name)) continue;
                    return action;
                }
            }
            return null;
        }

        public static String[] getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (Action action : Action.values()) {
                names.addAll(Arrays.asList(action.names));
            }
            return names.toArray(new String[0]);
        }
    }
}

