/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.entity;

import com.mojang.logging.LogUtils;
import com.player2.playerengine.PlayerEngine;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1675;
import net.minecraft.class_1682;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CustomFishingBobberEntity
extends class_1682 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_5819 velocityRandom = class_5819.method_43047();
    private boolean caughtFish;
    private int outOfOpenWaterTicks;
    private static final int MAX_TIME_OUT_OF_WATER = 10;
    private static final class_2940<Integer> HOOK_ENTITY_ID = class_2945.method_12791(CustomFishingBobberEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CAUGHT_FISH = class_2945.method_12791(CustomFishingBobberEntity.class, (class_2941)class_2943.field_13323);
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inOpenWater = true;
    @Nullable
    private class_1297 hookedEntity;
    private State state = State.FLYING;
    private final int luckOfTheSeaLevel;
    private final int lureLevel;

    public CustomFishingBobberEntity(class_1299<? extends CustomFishingBobberEntity> type, class_1937 world, int luckOfTheSeaLevel, int lureLevel) {
        super(type, world);
        this.field_5985 = true;
        this.luckOfTheSeaLevel = Math.max(0, luckOfTheSeaLevel);
        this.lureLevel = Math.max(0, lureLevel);
    }

    public CustomFishingBobberEntity(class_1299<? extends CustomFishingBobberEntity> entityType, class_1937 world) {
        this(entityType, world, 0, 0);
    }

    public CustomFishingBobberEntity(class_1309 thrower, class_1937 world, int luckOfTheSeaLevel, int lureLevel) {
        this((class_1299<? extends CustomFishingBobberEntity>)((class_1299)PlayerEngine.FISHING_BOBBER.get()), world, luckOfTheSeaLevel, lureLevel);
        this.method_7432((class_1297)thrower);
        float f = thrower.method_36455();
        float g = thrower.method_36454();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        double d = thrower.method_23317() - (double)i * 0.3;
        double e = thrower.method_23320();
        double l = thrower.method_23321() - (double)h * 0.3;
        this.method_5808(d, e, l, g, f);
        class_243 vec3d = new class_243((double)(-i), (double)class_3532.method_15363((float)(-(k / j)), (float)-5.0f, (float)5.0f), (double)(-h));
        double m = vec3d.method_1033();
        vec3d = vec3d.method_18805(0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365), 0.6 / m + this.field_5974.method_43385(0.5, 0.0103365));
        this.method_18799(vec3d);
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 180.0 / 3.1415927410125732));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * 180.0 / 3.1415927410125732));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_5693() {
        this.method_5841().method_12784(HOOK_ENTITY_ID, (Object)0);
        this.method_5841().method_12784(CAUGHT_FISH, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (HOOK_ENTITY_ID.equals(data)) {
            int i = (Integer)this.method_5841().method_12789(HOOK_ENTITY_ID);
            class_1297 class_12972 = this.hookedEntity = i > 0 ? this.method_37908().method_8469(i - 1) : null;
        }
        if (CAUGHT_FISH.equals(data)) {
            this.caughtFish = (Boolean)this.method_5841().method_12789(CAUGHT_FISH);
            if (this.caughtFish) {
                this.method_18800(this.method_18798().field_1352, -0.4f * class_3532.method_15344((class_5819)this.velocityRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        super.method_5674(data);
    }

    public boolean method_5640(double distance) {
        double d = 64.0;
        return distance < 4096.0;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
    }

    public void method_5773() {
        this.velocityRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.method_37908().method_8510());
        this.method_5670();
        class_1309 playerEntity = this.getPlayerOwner();
        if (playerEntity == null) {
            this.method_31472();
        } else if (this.method_37908().field_9236 || !this.removeIfInvalid(playerEntity)) {
            boolean bl;
            if (this.method_24828()) {
                ++this.removalTimer;
                if (this.removalTimer >= 1200) {
                    this.method_31472();
                    return;
                }
            } else {
                this.removalTimer = 0;
            }
            float f = 0.0f;
            class_2338 blockPos = this.method_24515();
            class_3610 fluidState = this.method_37908().method_8316(blockPos);
            if (fluidState.method_15767(class_3486.field_15517)) {
                f = fluidState.method_15763((class_1922)this.method_37908(), blockPos);
            }
            boolean bl2 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (this.hookedEntity != null) {
                    this.method_18799(class_243.field_1353);
                    this.state = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (bl) {
                    this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
                    this.state = State.BOBBING;
                    return;
                }
                this.checkForCollision();
            } else {
                if (this.state == State.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.method_31481() && this.hookedEntity.method_37908().method_27983() == this.method_37908().method_27983()) {
                            this.method_5814(this.hookedEntity.method_23317(), this.hookedEntity.method_23323(0.8), this.hookedEntity.method_23321());
                        } else {
                            this.updateHookedEntityId(null);
                            this.state = State.FLYING;
                        }
                    }
                    return;
                }
                if (this.state == State.BOBBING) {
                    class_243 vec3d = this.method_18798();
                    double d = this.method_23318() + vec3d.field_1351 - (double)blockPos.method_10264() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.method_18800(vec3d.field_1352 * 0.9, vec3d.field_1351 - d * (double)this.field_5974.method_43057() * 0.2, vec3d.field_1350 * 0.9);
                    if (this.hookCountdown <= 0 && this.fishTravelCountdown <= 0) {
                        this.inOpenWater = true;
                    } else {
                        boolean bl3 = this.inOpenWater = this.inOpenWater && this.outOfOpenWaterTicks < 10 && this.isOpenOrWaterAround(blockPos);
                    }
                    if (bl) {
                        this.outOfOpenWaterTicks = Math.max(0, this.outOfOpenWaterTicks - 1);
                        if (this.caughtFish) {
                            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.velocityRandom.method_43057() * (double)this.velocityRandom.method_43057(), 0.0));
                        }
                        if (!this.method_37908().field_9236) {
                            this.tickFishingLogic(blockPos);
                        }
                    } else {
                        this.outOfOpenWaterTicks = Math.min(10, this.outOfOpenWaterTicks + 1);
                    }
                }
            }
            if (!fluidState.method_15767(class_3486.field_15517)) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_26962();
            if (this.state == State.FLYING && (this.method_24828() || this.field_5976)) {
                this.method_18799(class_243.field_1353);
            }
            double e = 0.92;
            this.method_18799(this.method_18798().method_1021(0.92));
            this.method_23311();
        }
    }

    private boolean removeIfInvalid(class_1309 player) {
        class_1799 itemStack = player.method_6047();
        class_1799 itemStack2 = player.method_6079();
        boolean bl = itemStack.method_31574(class_1802.field_8378);
        boolean bl2 = itemStack2.method_31574(class_1802.field_8378);
        if (!player.method_31481() && player.method_5805() && (bl || bl2) && !(this.method_5858((class_1297)player) > 1024.0)) {
            return false;
        }
        this.method_31472();
        return true;
    }

    private void checkForCollision() {
        class_239 hitResult = class_1675.method_49997((class_1297)this, this::method_26958);
        this.method_7488(hitResult);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) || entity.method_5805() && entity instanceof class_1542;
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_37908().field_9236) {
            this.updateHookedEntityId(entityHitResult.method_17782());
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_18799(this.method_18798().method_1029().method_1021(blockHitResult.method_24801((class_1297)this)));
    }

    private void updateHookedEntityId(@Nullable class_1297 entity) {
        this.hookedEntity = entity;
        this.method_5841().method_12778(HOOK_ENTITY_ID, (Object)(entity == null ? 0 : entity.method_5628() + 1));
    }

    private void tickFishingLogic(class_2338 pos) {
        class_3218 serverWorld = (class_3218)this.method_37908();
        int i = 1;
        class_2338 blockPos = pos.method_10084();
        if (this.field_5974.method_43057() < 0.25f && this.method_37908().method_8520(blockPos)) {
            ++i;
        }
        if (this.field_5974.method_43057() < 0.5f && !this.method_37908().method_8311(blockPos)) {
            --i;
        }
        if (this.hookCountdown > 0) {
            --this.hookCountdown;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.method_5841().method_12778(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            this.fishTravelCountdown -= i;
            if (this.fishTravelCountdown > 0) {
                double j;
                double e;
                this.fishAngle += (float)this.field_5974.method_43385(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float g = class_3532.method_15374((float)f);
                float h = class_3532.method_15362((float)f);
                double d = this.method_23317() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
                class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)((e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0), (double)(j = this.method_23321() + (double)(h * (float)this.fishTravelCountdown * 0.1f))));
                if (blockState.method_27852(class_2246.field_10382)) {
                    if (this.field_5974.method_43057() < 0.15f) {
                        serverWorld.method_14199((class_2394)class_2398.field_11247, d, e - (double)0.1f, j, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverWorld.method_14199((class_2394)class_2398.field_11244, d, e, j, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverWorld.method_14199((class_2394)class_2398.field_11244, d, e, j, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else {
                this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
                double m = this.method_23318() + 0.5;
                serverWorld.method_14199((class_2394)class_2398.field_11247, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                serverWorld.method_14199((class_2394)class_2398.field_11244, this.method_23317(), m, this.method_23321(), (int)(1.0f + this.method_17681() * 20.0f), (double)this.method_17681(), 0.0, (double)this.method_17681(), (double)0.2f);
                this.hookCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                this.method_5841().method_12778(CAUGHT_FISH, (Object)true);
            }
        } else if (this.waitCountdown > 0) {
            this.waitCountdown -= i;
            float f = 0.15f;
            if (this.waitCountdown < 20) {
                f += (float)(20 - this.waitCountdown) * 0.05f;
            } else if (this.waitCountdown < 40) {
                f += (float)(40 - this.waitCountdown) * 0.02f;
            } else if (this.waitCountdown < 60) {
                f += (float)(60 - this.waitCountdown) * 0.01f;
            }
            if (this.field_5974.method_43057() < f) {
                double j;
                double e;
                float g = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double d = this.method_23317() + (double)(class_3532.method_15374((float)g) * h) * 0.1;
                class_2680 blockState = serverWorld.method_8320(class_2338.method_49637((double)d, (double)((e = (double)((float)class_3532.method_15357((double)this.method_23318()) + 1.0f)) - 1.0), (double)(j = this.method_23321() + (double)(class_3532.method_15362((float)g) * h) * 0.1)));
                if (blockState.method_27852(class_2246.field_10382)) {
                    serverWorld.method_14199((class_2394)class_2398.field_11202, d, e, j, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.waitCountdown = class_3532.method_15395((class_5819)this.field_5974, (int)100, (int)600);
            this.waitCountdown -= this.lureLevel * 20 * 5;
        }
    }

    private boolean isOpenOrWaterAround(class_2338 pos) {
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            PositionType positionType2 = this.getPositionType(pos.method_10069(-2, i, -2), pos.method_10069(2, i, 2));
            switch (positionType2.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (positionType != PositionType.ABOVE_WATER) break;
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    private PositionType getPositionType(class_2338 start, class_2338 end) {
        return class_2338.method_20437((class_2338)start, (class_2338)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
    }

    private PositionType getPositionType(class_2338 pos) {
        class_2680 blockState = this.method_37908().method_8320(pos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && blockState.method_26220((class_1922)this.method_37908(), pos).method_1110() ? PositionType.INSIDE_WATER : PositionType.INVALID;
        }
        return PositionType.ABOVE_WATER;
    }

    public boolean isInOpenWater() {
        return this.inOpenWater;
    }

    public void method_5652(class_2487 nbt) {
    }

    public void method_5749(class_2487 nbt) {
    }

    public int use(class_1799 usedItem) {
        class_1309 playerEntity = this.getPlayerOwner();
        if (!this.method_37908().field_9236 && playerEntity != null && !this.removeIfInvalid(playerEntity)) {
            int i = 0;
            if (this.hookedEntity != null) {
                this.pullHookedEntity(this.hookedEntity);
                this.method_37908().method_8421((class_1297)this, (byte)31);
                i = this.hookedEntity instanceof class_1542 ? 3 : 5;
            } else if (this.hookCountdown > 0) {
                class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)usedItem).method_51874(class_181.field_1226, (Object)this).method_51871((float)this.luckOfTheSeaLevel).method_51875(class_173.field_1176);
                class_52 lootTable = this.method_37908().method_8503().method_3857().getLootTable(class_39.field_353);
                for (class_1799 itemStack : lootTable.method_51878(lootContextParameterSet)) {
                    class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
                    double d = playerEntity.method_23317() - this.method_23317();
                    double e = playerEntity.method_23318() - this.method_23318();
                    double f = playerEntity.method_23321() - this.method_23321();
                    double g = 0.1;
                    itemEntity.method_18800(d * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * 0.1);
                    this.method_37908().method_8649((class_1297)itemEntity);
                    playerEntity.method_37908().method_8649((class_1297)new class_1303(playerEntity.method_37908(), playerEntity.method_23317(), playerEntity.method_23318() + 0.5, playerEntity.method_23321() + 0.5, this.field_5974.method_43048(6) + 1));
                    if (!itemStack.method_31573(class_3489.field_15527)) continue;
                }
                i = 1;
            }
            if (this.method_24828()) {
                i = 2;
            }
            this.method_31472();
            return i;
        }
        return 0;
    }

    public void method_5711(byte status) {
        if (status == 31 && this.method_37908().field_9236 && this.hookedEntity instanceof class_1309) {
            this.pullHookedEntity(this.hookedEntity);
        }
        super.method_5711(status);
    }

    protected void pullHookedEntity(class_1297 entity) {
        class_1297 entity2 = this.method_24921();
        if (entity2 != null) {
            class_243 vec3d = new class_243(entity2.method_23317() - this.method_23317(), entity2.method_23318() - this.method_23318(), entity2.method_23321() - this.method_23321()).method_1021(0.1);
            entity.method_18799(entity.method_18798().method_1019(vec3d));
        }
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.setPlayerFishHook(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.setPlayerFishHook(null);
    }

    public void method_7432(@Nullable class_1297 entity) {
        super.method_7432(entity);
        this.setPlayerFishHook(this);
    }

    private void setPlayerFishHook(@Nullable CustomFishingBobberEntity fishingBobber) {
        class_1309 playerEntity = this.getPlayerOwner();
        if (playerEntity != null) {
            // empty if block
        }
    }

    @Nullable
    public class_1309 getPlayerOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof class_1309 ? (class_1309)entity : null;
    }

    @Nullable
    public class_1297 getHookedEntity() {
        return this.hookedEntity;
    }

    public boolean method_5822() {
        return false;
    }

    public class_2596<class_2602> method_18002() {
        class_1297 entity = this.method_24921();
        return new class_2604((class_1297)this, entity == null ? this.method_5628() : entity.method_5628());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getPlayerOwner() == null) {
            int i = packet.method_11166();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.method_37908().method_8469(i), (Object)i);
            this.method_5768();
        }
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum PositionType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

