/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.pathing.goals.GoalRunAway;
import com.player2.playerengine.automaton.api.pathing.goals.GoalTwoBlocks;
import com.player2.playerengine.automaton.api.process.IMineProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMeta;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMetaLookup;
import com.player2.playerengine.automaton.api.utils.BlockUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.cache.CachedChunk;
import com.player2.playerengine.automaton.cache.WorldScanner;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public final class MineProcess
extends BaritoneProcessHelper
implements IMineProcess {
    private static final int ORE_LOCATIONS_COUNT = 64;
    private BlockOptionalMetaLookup filter;
    private List<class_2338> knownOreLocations;
    private List<class_2338> blacklist;
    private Map<class_2338, Long> anticipatedDrops;
    private class_2338 branchPoint;
    private GoalRunAway branchPointRunaway;
    private int desiredQuantity;
    private int tickCount;

    public MineProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.filter != null;
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        PathingCommand command;
        if (this.desiredQuantity > 0) {
            LivingEntityInventory inventory = this.ctx.inventory();
            int curr = inventory == null ? -1 : inventory.main.stream().filter(stack -> this.filter.has((class_1799)stack)).mapToInt(class_1799::method_7947).sum();
            PlayerEngine.LOGGER.debug("Currently have " + curr + " valid items");
            if (curr >= this.desiredQuantity) {
                this.logDirect("Have " + curr + " valid items");
                this.cancel();
                return null;
            }
        }
        if (calcFailed) {
            if (this.knownOreLocations.isEmpty() || !this.baritone.settings().blacklistClosestOnFailure.get().booleanValue()) {
                this.logDirect("Unable to find any path to " + String.valueOf(this.filter) + ", canceling mine");
                if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                    NotificationHelper.notify("Unable to find any path to " + String.valueOf(this.filter) + ", canceling mine", true);
                }
                this.cancel();
                return null;
            }
            this.logDirect("Unable to find any path to " + String.valueOf(this.filter) + ", blacklisting presumably unreachable closest instance...");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                NotificationHelper.notify("Unable to find any path to " + String.valueOf(this.filter) + ", blacklisting presumably unreachable closest instance...", true);
            }
            this.knownOreLocations.stream().min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).method_10262(arg_0))).ifPresent(this.blacklist::add);
            this.knownOreLocations.removeIf(this.blacklist::contains);
        }
        if (!this.baritone.settings().allowBreak.get().booleanValue()) {
            this.logDirect("Unable to mine when allowBreak is false!");
            this.cancel();
            return null;
        }
        this.updateLoucaSystem();
        int mineGoalUpdateInterval = this.baritone.settings().mineGoalUpdateInterval.get();
        ArrayList<class_2338> curr = new ArrayList<class_2338>(this.knownOreLocations);
        if (mineGoalUpdateInterval != 0 && this.tickCount++ % mineGoalUpdateInterval == 0) {
            CalculationContext context = new CalculationContext(this.baritone, true);
            PlayerEngine.getExecutor().execute(() -> this.rescan(curr, context));
        }
        if (this.baritone.settings().legitMine.get().booleanValue()) {
            this.addNearby();
        }
        Optional<class_2338> shaft = curr.stream().filter(pos -> pos.method_10263() == this.ctx.feetPos().method_10263() && pos.method_10260() == this.ctx.feetPos().method_10260()).filter(pos -> pos.method_10264() >= this.ctx.feetPos().method_10264()).filter(pos -> !(BlockStateInterface.get(this.ctx, pos).method_26204() instanceof class_2189)).min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).method_10262(arg_0)));
        this.baritone.getInputOverrideHandler().clearAllKeys();
        if (shaft.isPresent() && this.ctx.entity().method_24828()) {
            Optional<Rotation> rot;
            class_2338 pos2 = shaft.get();
            class_2680 state = this.baritone.bsi.get0(pos2);
            if (!MovementHelper.avoidBreaking(this.baritone.bsi, pos2.method_10263(), pos2.method_10264(), pos2.method_10260(), state, this.baritone.settings()) && (rot = RotationUtils.reachable(this.ctx, pos2)).isPresent() && isSafeToCancel) {
                this.baritone.getLookBehavior().updateTarget(rot.get(), true);
                MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().method_8320(pos2));
                if (this.ctx.isLookingAt(pos2) || this.ctx.entityRotations().isReallyCloseTo(rot.get())) {
                    this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
                }
                return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
            }
        }
        if ((command = this.updateGoal()) == null) {
            this.cancel();
            return null;
        }
        return command;
    }

    private void updateLoucaSystem() {
        HashMap<class_2338, Long> copy = new HashMap<class_2338, Long>(this.anticipatedDrops);
        this.ctx.getSelectedBlock().ifPresent(posx -> {
            if (this.knownOreLocations.contains(posx)) {
                copy.put((class_2338)posx, System.currentTimeMillis() + this.baritone.settings().mineDropLoiterDurationMSThanksLouca.get());
            }
        });
        for (class_2338 pos : this.anticipatedDrops.keySet()) {
            if ((Long)copy.get(pos) >= System.currentTimeMillis()) continue;
            copy.remove(pos);
        }
        this.anticipatedDrops = copy;
    }

    @Override
    public void onLostControl() {
        this.mine(0, (BlockOptionalMetaLookup)null);
    }

    @Override
    public String displayName0() {
        return "Mine " + String.valueOf(this.filter);
    }

    private PathingCommand updateGoal() {
        boolean legit = this.baritone.settings().legitMine.get();
        List<class_2338> locs = this.knownOreLocations;
        if (locs.isEmpty()) {
            if (!legit) {
                return null;
            }
            int y = this.baritone.settings().legitMineYLevel.get();
            if (this.branchPoint == null) {
                this.branchPoint = this.ctx.feetPos();
            }
            if (this.branchPointRunaway == null) {
                this.branchPointRunaway = new GoalRunAway(1.0, y, new class_2338[]{this.branchPoint}){

                    @Override
                    public boolean isInGoal(int x, int yx, int z) {
                        return false;
                    }

                    @Override
                    public double heuristic() {
                        return Double.NEGATIVE_INFINITY;
                    }
                };
            }
            return new PathingCommand(this.branchPointRunaway, PathingCommandType.REVALIDATE_GOAL_AND_PATH);
        }
        CalculationContext context = new CalculationContext(this.baritone);
        locs = MineProcess.prune(context, new ArrayList<class_2338>(locs), this.filter, 64, this.blacklist, this.droppedItemsScan());
        int locsSize = locs.size();
        Goal[] list = new Goal[locsSize];
        for (int i = 0; i < locsSize; ++i) {
            Goal coalesce;
            class_2338 loc = locs.get(i);
            list[i] = coalesce = this.coalesce(loc, locs, context);
        }
        GoalComposite goal = new GoalComposite(list);
        this.knownOreLocations = locs;
        return new PathingCommand(goal, legit ? PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH : PathingCommandType.REVALIDATE_GOAL_AND_PATH);
    }

    private void rescan(List<class_2338> already, CalculationContext context) {
        if (this.filter != null && !this.baritone.settings().legitMine.get().booleanValue()) {
            List<class_2338> dropped = this.droppedItemsScan();
            List<class_2338> locs = MineProcess.searchWorld(context, this.filter, 64, already, this.blacklist, dropped);
            locs.addAll(dropped);
            if (locs.isEmpty()) {
                this.logDirect("No locations for " + String.valueOf(this.filter) + " known, cancelling");
                if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnMineFail.get().booleanValue()) {
                    NotificationHelper.notify("No locations for " + String.valueOf(this.filter) + " known, cancelling", true);
                }
                this.cancel();
            } else {
                this.knownOreLocations = locs;
            }
        }
    }

    private boolean internalMiningGoal(class_2338 pos, CalculationContext context, List<class_2338> locs) {
        if (locs.contains(pos)) {
            return true;
        }
        class_2680 state = context.bsi.get0(pos);
        return this.baritone.settings().internalMiningAirException.get() != false && state.method_26204() instanceof class_2189 ? true : this.filter.has(state) && MineProcess.plausibleToBreak(context, pos);
    }

    private Goal coalesce(class_2338 loc, List<class_2338> locs, CalculationContext context) {
        boolean assumeVerticalShaftMine;
        boolean bl = assumeVerticalShaftMine = !(this.baritone.bsi.get0(loc.method_10084()).method_26204() instanceof class_2346);
        if (!this.baritone.settings().forceInternalMining.get().booleanValue()) {
            return assumeVerticalShaftMine ? new GoalThreeBlocks(loc) : new GoalTwoBlocks(loc);
        }
        boolean upwardGoal = this.internalMiningGoal(loc.method_10084(), context, locs);
        boolean downwardGoal = this.internalMiningGoal(loc.method_10074(), context, locs);
        boolean doubleDownwardGoal = this.internalMiningGoal(loc.method_10087(2), context, locs);
        if (upwardGoal == downwardGoal) {
            return doubleDownwardGoal && assumeVerticalShaftMine ? new GoalThreeBlocks(loc) : new GoalTwoBlocks(loc);
        }
        if (upwardGoal) {
            return new GoalBlock(loc);
        }
        return doubleDownwardGoal && assumeVerticalShaftMine ? new GoalTwoBlocks(loc.method_10074()) : new GoalBlock(loc.method_10074());
    }

    public List<class_2338> droppedItemsScan() {
        if (!this.baritone.settings().mineScanDroppedItems.get().booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<class_2338> ret = new ArrayList<class_2338>();
        for (class_1297 entity : this.ctx.world().method_27909()) {
            class_1542 ei;
            if (!(entity instanceof class_1542) || !this.filter.has((ei = (class_1542)entity).method_6983())) continue;
            ret.add(entity.method_24515());
        }
        ret.addAll(this.anticipatedDrops.keySet());
        return ret;
    }

    public static List<class_2338> searchWorld(CalculationContext ctx, BlockOptionalMetaLookup filter, int max, List<class_2338> alreadyKnown, List<class_2338> blacklist, List<class_2338> dropped) {
        List<class_2338> locs = new ArrayList<class_2338>();
        ArrayList<class_2248> untracked = new ArrayList<class_2248>();
        for (BlockOptionalMeta bom : filter.blocks()) {
            class_2248 block = bom.getBlock();
            if (CachedChunk.BLOCKS_TO_KEEP_TRACK_OF.contains((Object)block)) {
                BetterBlockPos pf = ctx.baritone.getEntityContext().feetPos();
                locs.addAll(ctx.worldData.getCachedWorld().getLocationsOf(BlockUtils.blockToString(block), ctx.baritone.settings().maxCachedWorldScanCount.get(), pf.x, pf.z, 2));
                continue;
            }
            untracked.add(block);
        }
        locs = MineProcess.prune(ctx, locs, filter, max, blacklist, dropped);
        if (!untracked.isEmpty() || ctx.baritone.settings().extendCacheOnThreshold.get().booleanValue() && locs.size() < max) {
            locs.addAll(WorldScanner.INSTANCE.scanChunkRadius(ctx.getBaritone().getEntityContext(), filter, max, 10, 32));
        }
        locs.addAll(alreadyKnown);
        return MineProcess.prune(ctx, locs, filter, max, blacklist, dropped);
    }

    private void addNearby() {
        List<class_2338> dropped = this.droppedItemsScan();
        this.knownOreLocations.addAll(dropped);
        BetterBlockPos playerFeet = this.ctx.feetPos();
        BlockStateInterface bsi = new BlockStateInterface(this.ctx);
        int searchDist = 10;
        double fakedBlockReachDistance = 20.0;
        for (int x = playerFeet.method_10263() - searchDist; x <= playerFeet.method_10263() + searchDist; ++x) {
            for (int y = playerFeet.method_10264() - searchDist; y <= playerFeet.method_10264() + searchDist; ++y) {
                for (int z = playerFeet.method_10260() - searchDist; z <= playerFeet.method_10260() + searchDist; ++z) {
                    if (!this.filter.has(bsi.get0(x, y, z))) continue;
                    class_2338 pos = new class_2338(x, y, z);
                    if ((!this.baritone.settings().legitMineIncludeDiagonals.get().booleanValue() || !this.knownOreLocations.stream().anyMatch(ore -> ore.method_10262((class_2382)pos) <= 2.0)) && !RotationUtils.reachable(this.ctx.entity(), pos, fakedBlockReachDistance).isPresent()) continue;
                    this.knownOreLocations.add(pos);
                }
            }
        }
        this.knownOreLocations = MineProcess.prune(new CalculationContext(this.baritone), this.knownOreLocations, this.filter, 64, this.blacklist, dropped);
    }

    private static List<class_2338> prune(CalculationContext ctx, List<class_2338> locs2, BlockOptionalMetaLookup filter, int max, List<class_2338> blacklist, List<class_2338> dropped) {
        dropped.removeIf(drop -> {
            for (class_2338 pos : locs2) {
                if (!(pos.method_10262((class_2382)drop) <= 9.0) || !filter.has(ctx.get(pos.method_10263(), pos.method_10264(), pos.method_10260())) || !MineProcess.plausibleToBreak(ctx, pos)) continue;
                return true;
            }
            return false;
        });
        List<class_2338> locs = locs2.stream().distinct().filter(pos -> !ctx.bsi.worldContainsLoadedChunk(pos.method_10263(), pos.method_10260()) || filter.has(ctx.get(pos.method_10263(), pos.method_10264(), pos.method_10260())) || dropped.contains(pos)).filter(pos -> MineProcess.plausibleToBreak(ctx, pos)).filter(pos -> ctx.getBaritone().settings().allowOnlyExposedOres.get() != false ? MineProcess.isNextToAir(ctx, pos) : true).filter(pos -> pos.method_10264() >= ctx.getBaritone().settings().minYLevelWhileMining.get()).filter(pos -> !blacklist.contains(pos)).sorted(Comparator.comparingDouble(arg_0 -> ((class_2338)ctx.getBaritone().getEntityContext().entity().method_24515()).method_10262(arg_0))).collect(Collectors.toList());
        return locs.size() > max ? locs.subList(0, max) : locs;
    }

    public static boolean isNextToAir(CalculationContext ctx, class_2338 pos) {
        int radius = ctx.getBaritone().settings().allowOnlyExposedOresDistance.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) > radius || !MovementHelper.isTransparent(ctx.getBlock(pos.method_10263() + dx, pos.method_10264() + dy, pos.method_10260() + dz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean plausibleToBreak(CalculationContext ctx, class_2338 pos) {
        return MovementHelper.getMiningDurationTicks(ctx, pos.method_10263(), pos.method_10264(), pos.method_10260(), ctx.bsi.get0(pos), true) >= 1000000.0 ? false : ctx.bsi.get0(pos.method_10084()).method_26204() != class_2246.field_9987 || ctx.bsi.get0(pos.method_10074()).method_26204() != class_2246.field_9987;
    }

    @Override
    public void mineByName(int quantity, String ... blocks) {
        this.mine(quantity, new BlockOptionalMetaLookup(this.baritone.getEntityContext().world(), blocks));
    }

    @Override
    public void mine(int quantity, BlockOptionalMetaLookup filter) {
        this.filter = filter;
        if (filter != null && !this.baritone.settings().allowBreak.get().booleanValue()) {
            this.logDirect("Unable to mine when allowBreak is false!");
            this.mine(quantity, (BlockOptionalMetaLookup)null);
        } else {
            this.desiredQuantity = quantity;
            this.knownOreLocations = new ArrayList<class_2338>();
            this.blacklist = new ArrayList<class_2338>();
            this.branchPoint = null;
            this.branchPointRunaway = null;
            this.anticipatedDrops = new HashMap<class_2338, Long>();
            if (filter != null) {
                this.rescan(new ArrayList<class_2338>(), new CalculationContext(this.baritone));
            }
        }
    }

    @Override
    public void mine(int quantity, class_2248 ... blocks) {
        this.mine(quantity, new BlockOptionalMetaLookup((BlockOptionalMeta[])Stream.of(blocks).map(block -> new BlockOptionalMeta(this.baritone.getEntityContext().world(), (class_2248)block)).toArray(BlockOptionalMeta[]::new)));
    }

    private static class GoalThreeBlocks
    extends GoalTwoBlocks {
        public GoalThreeBlocks(class_2338 pos) {
            super(pos);
        }

        @Override
        public boolean isInGoal(int x, int y, int z) {
            return x == this.x && (y == this.y || y == this.y - 1 || y == this.y - 2) && z == this.z;
        }

        @Override
        public double heuristic(int x, int y, int z) {
            int xDiff = x - this.x;
            int yDiff = y - this.y;
            int zDiff = z - this.z;
            return GoalBlock.calculate(xDiff, yDiff < -1 ? yDiff + 2 : (yDiff == -1 ? 0 : yDiff), zDiff);
        }
    }
}

