/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.tasks.base.ITaskOverridesGrounded;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.movement.MLGBucketTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_3959;

public class MLGBucketFallChain
extends SingleTaskChain
implements ITaskOverridesGrounded {
    private final TimerGame tryCollectWaterTimer = new TimerGame(4.0);
    private final TimerGame pickupRepeatTimer = new TimerGame(0.25);
    private MLGBucketTask lastMLG = null;
    private boolean wasPickingUp = false;
    private boolean doingChorusFruit = false;

    public MLGBucketFallChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onTaskFinish(PlayerEngineController mod) {
    }

    @Override
    public float getPriority() {
        if (!PlayerEngineController.inGame()) {
            return Float.NEGATIVE_INFINITY;
        }
        PlayerEngineController mod = this.controller;
        if (this.isFalling(mod)) {
            this.tryCollectWaterTimer.reset();
            this.setTask(new MLGBucketTask());
            this.lastMLG = (MLGBucketTask)this.mainTask;
            return 100.0f;
        }
        if (!this.tryCollectWaterTimer.elapsed() && mod.getItemStorage().hasItem(class_1802.field_8550) && !mod.getItemStorage().hasItem(class_1802.field_8705) && this.lastMLG != null) {
            boolean isPlacedWater;
            class_2338 placed = this.lastMLG.getWaterPlacedPos();
            try {
                isPlacedWater = mod.getWorld().method_8320(placed).method_26204() == class_2246.field_10382;
            }
            catch (Exception var6) {
                isPlacedWater = false;
            }
            if (placed != null && placed.method_19769((class_2374)mod.getPlayer().method_19538(), 5.5) && isPlacedWater) {
                mod.getBehaviour().push();
                mod.getBehaviour().setRayTracingFluidHandling(class_3959.class_242.field_1345);
                Optional<Rotation> reach = LookHelper.getReach(this.controller, placed, class_2350.field_11036);
                if (reach.isPresent()) {
                    mod.getBaritone().getLookBehavior().updateTarget(reach.get(), true);
                    if (mod.getBaritone().getEntityContext().isLookingAt(placed) && mod.getSlotHandler().forceEquipItem(class_1802.field_8550)) {
                        if (this.pickupRepeatTimer.elapsed()) {
                            this.pickupRepeatTimer.reset();
                            mod.getInputControls().tryPress(Input.CLICK_RIGHT);
                            this.wasPickingUp = true;
                        } else if (this.wasPickingUp) {
                            this.wasPickingUp = false;
                        }
                    }
                } else {
                    this.setTask(TaskCatalogue.getItemTask(class_1802.field_8705, 1));
                }
                mod.getBehaviour().pop();
                return 60.0f;
            }
        }
        if (this.wasPickingUp) {
            this.wasPickingUp = false;
            this.lastMLG = null;
        }
        if (mod.getPlayer().method_6059(class_1294.field_5902) && ((class_1293)mod.getPlayer().method_6088().get(class_1294.field_5902)).method_5584() <= 70 && mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8233) && !mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8705)) {
            this.doingChorusFruit = true;
            mod.getSlotHandler().forceEquipItem(class_1802.field_8233);
            mod.getInputControls().hold(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(true);
        } else if (this.doingChorusFruit) {
            this.doingChorusFruit = false;
            mod.getInputControls().release(Input.CLICK_RIGHT);
            mod.getExtraBaritoneSettings().setInteractionPaused(false);
        }
        this.lastMLG = null;
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    public String getName() {
        return "MLG Water Bucket Fall Chain";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean doneMLG() {
        return this.lastMLG == null;
    }

    public boolean isChorusFruiting() {
        return this.doingChorusFruit;
    }

    public boolean isFalling(PlayerEngineController mod) {
        if (!mod.getModSettings().shouldAutoMLGBucket()) {
            return false;
        }
        if (!(mod.getPlayer().method_5681() || mod.getPlayer().method_5799() || mod.getPlayer().method_24828() || mod.getPlayer().method_6101())) {
            double ySpeed = mod.getPlayer().method_18798().field_1351;
            return ySpeed < -0.7;
        }
        return false;
    }
}

