/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.tasks.entity.GiveItemToPlayerTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.FuzzySearchHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.HashSet;
import net.minecraft.class_1799;

public class GiveCommand
extends Command {
    public GiveCommand() throws CommandException {
        super("give", "Give or drop an item to a player. Examples: `give Ellie diamond 3` to give player with username Ellie 3 diamonds.", new Arg<Object>(String.class, "username", null, 2), new Arg<String>(String.class, "item"), new Arg<Integer>(Integer.class, "count", 1, 1));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        String username = parser.get(String.class);
        if (username == null) {
            if (mod.getOwner() == null) {
                mod.logWarning("No butler user currently present. Running this command with no user argument can ONLY be done via butler.");
                this.finish();
                return;
            }
            username = mod.getOwner().method_5477().getString();
        }
        String item = parser.get(String.class);
        int count = parser.get(Integer.class);
        ItemTarget target = null;
        if (TaskCatalogue.taskExists(item)) {
            target = TaskCatalogue.getItemTarget(item, count);
        } else {
            for (int i = 0; i < mod.getInventory().method_5439(); ++i) {
                String name;
                class_1799 stack = mod.getInventory().method_5438(i);
                if (stack.method_7960() || !(name = ItemHelper.stripItemName(stack.method_7909())).equals(item)) continue;
                target = new ItemTarget(stack.method_7909(), count);
                break;
            }
        }
        if (!mod.getEntityTracker().isPlayerLoaded(username)) {
            String nearbyUsernames = String.join((CharSequence)",", mod.getEntityTracker().getAllLoadedPlayerUsernames());
            Debug.logMessage("No user in render distance found with username \"" + username + "\". Maybe this was a typo or there is a user with a similar name around? Nearby users: [" + nearbyUsernames + "].");
            this.finish();
        } else if (target != null) {
            Debug.logMessage("USER: " + username + " : ITEM: " + item + " x " + count);
            mod.runUserTask(new GiveItemToPlayerTask(username, target), () -> this.finish());
        } else {
            HashSet<String> validNames = new HashSet<String>(TaskCatalogue.resourceNames());
            for (int ix = 0; ix < mod.getInventory().method_5439(); ++ix) {
                class_1799 stack = mod.getInventory().method_5438(ix);
                if (stack.method_7960()) continue;
                String name = ItemHelper.stripItemName(stack.method_7909());
                validNames.add(name);
            }
            String closestMatch = FuzzySearchHelper.getClosestMatchMinecraftItems(item, validNames);
            mod.log("Item not found or task does not exist for item: \"" + item + "\". Does the user mean \"" + closestMatch + "\"?");
            this.finish();
        }
    }
}

