/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.ConversationHistory;
import com.player2.playerengine.player2api.manager.HeartbeatManager;
import com.player2.playerengine.player2api.utils.Player2HTTPUtils;
import com.player2.playerengine.player2api.utils.Utils;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Player2APIService {
    private static final Logger LOGGER = LogManager.getLogger();
    private String clientId;
    private PlayerEngineController controller;
    private static MinecraftServer server;

    public Player2APIService(PlayerEngineController controller, String clientId) {
        this.clientId = clientId;
        this.controller = controller;
    }

    public JsonObject completeConversation(ConversationHistory conversationHistory) throws Exception {
        JsonObject messageObject;
        JsonArray choices;
        JsonObject requestBody = new JsonObject();
        JsonArray messagesArray = new JsonArray();
        for (JsonObject msg : conversationHistory.getListJSON()) {
            messagesArray.add((JsonElement)msg);
        }
        String lastMessageForDebug = conversationHistory.getListJSON().get(conversationHistory.getListJSON().size() - 1).toString();
        requestBody.add("messages", (JsonElement)messagesArray);
        LOGGER.info("Called complete conversation HTTP request, last msg={}", (Object)lastMessageForDebug);
        Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(this.controller.getOwner(), this.clientId, "/v1/chat/completions", true, requestBody);
        responseMap.forEach((k, v) -> LOGGER.info("RESPONSE: key={}, value={}", k, v));
        if (responseMap.containsKey("choices") && (choices = responseMap.get("choices").getAsJsonArray()).size() != 0 && (messageObject = choices.get(0).getAsJsonObject().getAsJsonObject("message")) != null && messageObject.has("content")) {
            String content = messageObject.get("content").getAsString();
            LOGGER.info("Finished complete conversation HTTP request last msg={}", (Object)lastMessageForDebug);
            return Utils.parseCleanedJson(content);
        }
        throw new Exception("Invalid response format: " + responseMap.toString());
    }

    public String completeConversationToString(ConversationHistory conversationHistory) throws Exception {
        JsonObject messageObject;
        JsonArray choices;
        JsonObject requestBody = new JsonObject();
        JsonArray messagesArray = new JsonArray();
        for (JsonObject msg : conversationHistory.getListJSON()) {
            messagesArray.add((JsonElement)msg);
        }
        requestBody.add("messages", (JsonElement)messagesArray);
        String lastMessageForDebug = conversationHistory.getListJSON().get(conversationHistory.getListJSON().size() - 1).toString();
        LOGGER.info("Called complete conversation (string) HTTP request, last msg={}", (Object)lastMessageForDebug);
        Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(this.controller.getOwner(), this.clientId, "/v1/chat/completions", true, requestBody);
        if (responseMap.containsKey("choices") && (choices = responseMap.get("choices").getAsJsonArray()).size() != 0 && (messageObject = choices.get(0).getAsJsonObject().getAsJsonObject("message")) != null && messageObject.has("content")) {
            LOGGER.info("Finished complete conversation HTTP (string) request last msg={}", (Object)lastMessageForDebug);
            return messageObject.get("content").getAsString();
        }
        throw new Exception("Invalid response format: " + responseMap.toString());
    }

    public void textToSpeech(String message, Character character, Consumer<Map<String, JsonElement>> onFinish) {
        try {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814(this.clientId);
            buf.method_10814(Player2HTTPUtils.awaitToken(this.controller.getOwner(), this.clientId));
            buf.method_10814(message);
            buf.writeDouble(1.0);
            buf.method_10804(character.voiceIds().length);
            for (String id : character.voiceIds()) {
                buf.method_10814(id);
            }
            ((class_3222)this.controller.getOwner()).field_13987.method_14364(NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)new class_2960("playerengine", "stream_tts"), (class_2540)buf));
            onFinish.accept(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startSTT() {
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("timeout", (Number)180);
        try {
            Player2HTTPUtils.sendRequest(this.controller.getOwner(), this.clientId, "/v1/stt/start", true, requestBody);
        }
        catch (Exception var3) {
            System.err.println("[Player2APIService/startSTT]: Error" + var3.getMessage());
        }
    }

    public String stopSTT() {
        try {
            Map<String, JsonElement> responseMap = Player2HTTPUtils.sendRequest(this.controller.getOwner(), this.clientId, "/v1/stt/stop", true, null);
            if (!responseMap.containsKey("text")) {
                throw new Exception("Could not find key 'text' in response");
            }
            return responseMap.get("text").getAsString();
        }
        catch (Exception var2) {
            return var2.getMessage();
        }
    }

    public void trySendHeartbeat() {
        if (HeartbeatManager.shouldHeartbeat(this.controller.getOwnerUsername(), this.clientId)) {
            this.sendHeartbeat();
            HeartbeatManager.storeHeartbeatTime(this.controller.getOwnerUsername(), this.clientId);
        }
    }

    public void sendHeartbeat() {
        try {
            System.out.println("Sending Heartbeat " + this.clientId);
            Player2HTTPUtils.sendRequest(this.controller.getOwner(), this.clientId, "/v1/health", false, null);
            System.out.println("Heartbeat Successful");
        }
        catch (Exception var2) {
            System.err.printf("Heartbeat Fail: %s", var2.getMessage());
        }
    }

    public String getClientId() {
        return this.clientId;
    }
}

