/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.manager;

import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.Player2APIService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TTSManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TTScharactersPerSecond = 25;
    private static boolean TTSLocked = false;
    private static long estimatedEndTime = 0L;
    private static final ExecutorService ttsThread = Executors.newSingleThreadExecutor();
    public static boolean enabled = true;

    public static ExecutorService getExecutor() {
        return ttsThread;
    }

    private static void setEstimatedEndTime(String message) {
        int waitTimeSec = (int)Math.ceil((double)message.length() / 25.0) + 1;
        LOGGER.info("TTSManager/ waiting time={} (sec) for message={}", (Object)waitTimeSec, (Object)message);
        long waitNanos = TimeUnit.SECONDS.toNanos(waitTimeSec);
        estimatedEndTime = System.nanoTime() + waitNanos;
    }

    public static void TTS(String message, Character character, Player2APIService player2apiService) {
        if (!enabled) {
            return;
        }
        TTSLocked = true;
        LOGGER.info("Locking TTS based on msg={}", (Object)message);
        estimatedEndTime = Long.MAX_VALUE;
        ttsThread.submit(() -> player2apiService.textToSpeech(message, character, _unusedMap -> TTSManager.setEstimatedEndTime(message)));
    }

    public static boolean isLocked() {
        return TTSLocked;
    }

    public static void injectOnTick(MinecraftServer server) {
        server.execute(() -> {
            if (System.nanoTime() > estimatedEndTime && TTSLocked) {
                LOGGER.info("TTS releasing lock");
                TTSLocked = false;
            }
        });
    }
}

