/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.player2.playerengine.player2api.auth.AuthKey;
import com.player2.playerengine.player2api.auth.AuthenticationManager;
import com.player2.playerengine.player2api.utils.HTTPUtils;
import com.player2.playerengine.player2api.utils.HttpApiException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1657;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Player2HTTPUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String WEB_API_URL = "https://api.player2.game";

    public static Map<String, JsonElement> sendRequest(class_1657 player, String clientId, String endpoint, boolean postRequest, JsonObject requestBody) throws Exception {
        String token = Player2HTTPUtils.awaitToken(player, clientId);
        Map<String, String> headers = Player2HTTPUtils.getHeaders(clientId, token);
        try {
            return HTTPUtils.sendRequest(WEB_API_URL, endpoint, postRequest, requestBody, headers);
        }
        catch (HttpApiException e) {
            if (e.getStatusCode() == 401) {
                LOGGER.warn("Received 401 Unauthorized for {}. Invalidating token.", (Object)new AuthKey(player.method_5667(), clientId));
                AuthenticationManager.getInstance().invalidateToken(player, clientId);
                throw new Exception("Token expired, re-authentication started.", e);
            }
            if (e.getStatusCode() == 402) {
                LOGGER.warn("Insufficient AI power for user {}", (Object)player.method_5477().getString());
                throw new Exception("Insufficient AI Power. Go to player2.game to get more AI Power.");
            }
            throw e;
        }
    }

    private static Map<String, String> getHeaders(String clientId, String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("player2-game-key", clientId);
        headers.put("Authorization", "Bearer " + token);
        return headers;
    }

    public static String awaitToken(class_1657 player, String clientId) throws ExecutionException, InterruptedException {
        return AuthenticationManager.getInstance().authenticate(player, clientId).get();
    }
}

